"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const integration_1 = require("../integration");
/**
 * You can integrate an API method with an HTTP endpoint using the HTTP proxy integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 */
class HttpIntegration extends integration_1.Integration {
    /**
     *
     */
    constructor(url, props = {}) {
        const proxy = props.proxy !== undefined ? props.proxy : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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