#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

/* Definitions for bus frequencies */
#define XPAR_CPU_M_AXI_DP_FREQ_HZ 100000000
/******************************************************************/

/* Canonical definitions for bus frequencies */
/******************************************************************/

#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 100000000
#define XPAR_MICROBLAZE_CORE_CLOCK_FREQ_HZ 100000000

/******************************************************************/


/* Definitions for peripheral IOP_ARDUINO_MB */
#define XPAR_IOP_ARDUINO_MB_ADDR_SIZE 32
#define XPAR_IOP_ARDUINO_MB_ADDR_TAG_BITS 17
#define XPAR_IOP_ARDUINO_MB_ALLOW_DCACHE_WR 1
#define XPAR_IOP_ARDUINO_MB_ALLOW_ICACHE_WR 1
#define XPAR_IOP_ARDUINO_MB_AREA_OPTIMIZED 0
#define XPAR_IOP_ARDUINO_MB_ASYNC_INTERRUPT 1
#define XPAR_IOP_ARDUINO_MB_ASYNC_WAKEUP 3
#define XPAR_IOP_ARDUINO_MB_AVOID_PRIMITIVES 0
#define XPAR_IOP_ARDUINO_MB_BASE_VECTORS 0x0000000000000000
#define XPAR_IOP_ARDUINO_MB_BRANCH_TARGET_CACHE_SIZE 0
#define XPAR_IOP_ARDUINO_MB_CACHE_BYTE_SIZE 8192
#define XPAR_IOP_ARDUINO_MB_DADDR_SIZE 32
#define XPAR_IOP_ARDUINO_MB_DATA_SIZE 32
#define XPAR_IOP_ARDUINO_MB_DCACHE_ADDR_TAG 17
#define XPAR_IOP_ARDUINO_MB_DCACHE_ALWAYS_USED 1
#define XPAR_IOP_ARDUINO_MB_DCACHE_BASEADDR 0x00000000
#define XPAR_IOP_ARDUINO_MB_DCACHE_BYTE_SIZE 8192
#define XPAR_IOP_ARDUINO_MB_DCACHE_DATA_WIDTH 0
#define XPAR_IOP_ARDUINO_MB_DCACHE_FORCE_TAG_LUTRAM 0
#define XPAR_IOP_ARDUINO_MB_DCACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_IOP_ARDUINO_MB_DCACHE_LINE_LEN 4
#define XPAR_IOP_ARDUINO_MB_DCACHE_USE_WRITEBACK 0
#define XPAR_IOP_ARDUINO_MB_DCACHE_VICTIMS 0
#define XPAR_IOP_ARDUINO_MB_DC_AXI_MON 0
#define XPAR_IOP_ARDUINO_MB_DEBUG_COUNTER_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_DEBUG_ENABLED 1
#define XPAR_IOP_ARDUINO_MB_DEBUG_EVENT_COUNTERS 5
#define XPAR_IOP_ARDUINO_MB_DEBUG_EXTERNAL_TRACE 0
#define XPAR_IOP_ARDUINO_MB_DEBUG_INTERFACE 0
#define XPAR_IOP_ARDUINO_MB_DEBUG_LATENCY_COUNTERS 1
#define XPAR_IOP_ARDUINO_MB_DEBUG_PROFILE_SIZE 0
#define XPAR_IOP_ARDUINO_MB_DEBUG_TRACE_ASYNC_RESET 0
#define XPAR_IOP_ARDUINO_MB_DEBUG_TRACE_SIZE 8192
#define XPAR_IOP_ARDUINO_MB_DIV_ZERO_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_DP_AXI_MON 0
#define XPAR_IOP_ARDUINO_MB_DYNAMIC_BUS_SIZING 0
#define XPAR_IOP_ARDUINO_MB_D_AXI 1
#define XPAR_IOP_ARDUINO_MB_D_LMB 1
#define XPAR_IOP_ARDUINO_MB_D_LMB_MON 0
#define XPAR_IOP_ARDUINO_MB_D_LMB_PROTOCOL 0
#define XPAR_IOP_ARDUINO_MB_ECC_USE_CE_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_EDGE_IS_POSITIVE 1
#define XPAR_IOP_ARDUINO_MB_ENABLE_DISCRETE_PORTS 0
#define XPAR_IOP_ARDUINO_MB_ENDIANNESS 1
#define XPAR_IOP_ARDUINO_MB_FAULT_TOLERANT 0
#define XPAR_IOP_ARDUINO_MB_FPU_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_FREQ 100000000
#define XPAR_IOP_ARDUINO_MB_FSL_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_FSL_LINKS 0
#define XPAR_IOP_ARDUINO_MB_IADDR_SIZE 32
#define XPAR_IOP_ARDUINO_MB_ICACHE_ALWAYS_USED 1
#define XPAR_IOP_ARDUINO_MB_ICACHE_BASEADDR 0x00000000
#define XPAR_IOP_ARDUINO_MB_ICACHE_DATA_WIDTH 0
#define XPAR_IOP_ARDUINO_MB_ICACHE_FORCE_TAG_LUTRAM 0
#define XPAR_IOP_ARDUINO_MB_ICACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_IOP_ARDUINO_MB_ICACHE_LINE_LEN 4
#define XPAR_IOP_ARDUINO_MB_ICACHE_STREAMS 0
#define XPAR_IOP_ARDUINO_MB_ICACHE_VICTIMS 0
#define XPAR_IOP_ARDUINO_MB_IC_AXI_MON 0
#define XPAR_IOP_ARDUINO_MB_ILL_OPCODE_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_IMPRECISE_EXCEPTIONS 0
#define XPAR_IOP_ARDUINO_MB_INSTR_SIZE 32
#define XPAR_IOP_ARDUINO_MB_INTERCONNECT 2
#define XPAR_IOP_ARDUINO_MB_INTERRUPT_IS_EDGE 0
#define XPAR_IOP_ARDUINO_MB_INTERRUPT_MON 0
#define XPAR_IOP_ARDUINO_MB_IP_AXI_MON 0
#define XPAR_IOP_ARDUINO_MB_I_AXI 0
#define XPAR_IOP_ARDUINO_MB_I_LMB 1
#define XPAR_IOP_ARDUINO_MB_I_LMB_MON 0
#define XPAR_IOP_ARDUINO_MB_I_LMB_PROTOCOL 0
#define XPAR_IOP_ARDUINO_MB_LMB_DATA_SIZE 32
#define XPAR_IOP_ARDUINO_MB_LOCKSTEP_MASTER 0
#define XPAR_IOP_ARDUINO_MB_LOCKSTEP_SELECT 0
#define XPAR_IOP_ARDUINO_MB_LOCKSTEP_SLAVE 0
#define XPAR_IOP_ARDUINO_MB_M0_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M0_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M1_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M1_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M2_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M2_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M3_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M3_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M4_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M4_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M5_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M5_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M6_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M6_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M7_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M7_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M8_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M8_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M9_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M9_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M10_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M10_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M11_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M11_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M12_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M12_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M13_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M13_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M14_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M14_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_M15_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M15_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_MMU_DTLB_SIZE 4
#define XPAR_IOP_ARDUINO_MB_MMU_ITLB_SIZE 2
#define XPAR_IOP_ARDUINO_MB_MMU_PRIVILEGED_INSTR 0
#define XPAR_IOP_ARDUINO_MB_MMU_TLB_ACCESS 3
#define XPAR_IOP_ARDUINO_MB_MMU_ZONES 16
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_ADDR_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_ARUSER_WIDTH 5
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_AWUSER_WIDTH 5
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_BUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_EXCLUSIVE_ACCESS 0
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_RUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_THREAD_ID_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_USER_SIGNALS 0
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_USER_VALUE 31
#define XPAR_IOP_ARDUINO_MB_M_AXI_DC_WUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_DP_ADDR_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_DP_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_DP_EXCLUSIVE_ACCESS 0
#define XPAR_IOP_ARDUINO_MB_M_AXI_DP_THREAD_ID_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_D_BUS_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_ADDR_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_ARUSER_WIDTH 5
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_AWUSER_WIDTH 5
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_BUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_RUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_THREAD_ID_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_USER_SIGNALS 0
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_USER_VALUE 31
#define XPAR_IOP_ARDUINO_MB_M_AXI_IC_WUSER_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_IP_ADDR_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_IP_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_M_AXI_IP_THREAD_ID_WIDTH 1
#define XPAR_IOP_ARDUINO_MB_M_AXI_I_BUS_EXCEPTION 0
#define XPAR_IOP_ARDUINO_MB_NUMBER_OF_PC_BRK 1
#define XPAR_IOP_ARDUINO_MB_NUMBER_OF_RD_ADDR_BRK 0
#define XPAR_IOP_ARDUINO_MB_NUMBER_OF_WR_ADDR_BRK 0
#define XPAR_IOP_ARDUINO_MB_NUM_SYNC_FF_CLK 2
#define XPAR_IOP_ARDUINO_MB_NUM_SYNC_FF_CLK_DEBUG 2
#define XPAR_IOP_ARDUINO_MB_NUM_SYNC_FF_CLK_IRQ 1
#define XPAR_IOP_ARDUINO_MB_NUM_SYNC_FF_DBG_CLK 1
#define XPAR_IOP_ARDUINO_MB_NUM_SYNC_FF_DBG_TRACE_CLK 2
#define XPAR_IOP_ARDUINO_MB_OPCODE_0X0_ILLEGAL 0
#define XPAR_IOP_ARDUINO_MB_OPTIMIZATION 0
#define XPAR_IOP_ARDUINO_MB_PC_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_PIADDR_SIZE 32
#define XPAR_IOP_ARDUINO_MB_PVR 0
#define XPAR_IOP_ARDUINO_MB_PVR_USER1 0x00
#define XPAR_IOP_ARDUINO_MB_PVR_USER2 0x00000000
#define XPAR_IOP_ARDUINO_MB_RESET_MSR 0x00000000
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_BIP 0
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_DCE 0
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_EE 0
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_EIP 0
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_ICE 0
#define XPAR_IOP_ARDUINO_MB_RESET_MSR_IE 0
#define XPAR_IOP_ARDUINO_MB_S0_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S0_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S1_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S1_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S2_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S2_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S3_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S3_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S4_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S4_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S5_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S5_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S6_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S6_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S7_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S7_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S8_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S8_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S9_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S9_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S10_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S10_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S11_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S11_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S12_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S12_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S13_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S13_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S14_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S14_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_S15_AXIS_DATA_WIDTH 32
#define XPAR_IOP_ARDUINO_MB_S15_AXIS_PROTOCOL GENERIC
#define XPAR_IOP_ARDUINO_MB_SCO 0
#define XPAR_IOP_ARDUINO_MB_TRACE 0
#define XPAR_IOP_ARDUINO_MB_UNALIGNED_EXCEPTIONS 0
#define XPAR_IOP_ARDUINO_MB_USE_BARREL 0
#define XPAR_IOP_ARDUINO_MB_USE_BRANCH_TARGET_CACHE 0
#define XPAR_IOP_ARDUINO_MB_USE_CONFIG_RESET 0
#define XPAR_IOP_ARDUINO_MB_USE_DCACHE 0
#define XPAR_IOP_ARDUINO_MB_USE_DIV 0
#define XPAR_IOP_ARDUINO_MB_USE_EXTENDED_FSL_INSTR 0
#define XPAR_IOP_ARDUINO_MB_USE_EXT_BRK 0
#define XPAR_IOP_ARDUINO_MB_USE_EXT_NM_BRK 0
#define XPAR_IOP_ARDUINO_MB_USE_FPU 0
#define XPAR_IOP_ARDUINO_MB_USE_HW_MUL 0
#define XPAR_IOP_ARDUINO_MB_USE_ICACHE 0
#define XPAR_IOP_ARDUINO_MB_USE_INTERRUPT 1
#define XPAR_IOP_ARDUINO_MB_USE_MMU 0
#define XPAR_IOP_ARDUINO_MB_USE_MSR_INSTR 0
#define XPAR_IOP_ARDUINO_MB_USE_NON_SECURE 0
#define XPAR_IOP_ARDUINO_MB_USE_PCMP_INSTR 0
#define XPAR_IOP_ARDUINO_MB_USE_REORDER_INSTR 1
#define XPAR_IOP_ARDUINO_MB_USE_STACK_PROTECTION 0
#define XPAR_IOP_ARDUINO_MB_COMPONENT_NAME base_mb_0
#define XPAR_IOP_ARDUINO_MB_EDK_IPTYPE PROCESSOR
#define XPAR_IOP_ARDUINO_MB_EDK_SPECIAL microblaze
#define XPAR_IOP_ARDUINO_MB_G_TEMPLATE_LIST 0
#define XPAR_IOP_ARDUINO_MB_G_USE_EXCEPTIONS 0

/******************************************************************/

#define XPAR_CPU_ID 0
#define XPAR_MICROBLAZE_ID 0
#define XPAR_MICROBLAZE_ADDR_SIZE 32
#define XPAR_MICROBLAZE_ADDR_TAG_BITS 17
#define XPAR_MICROBLAZE_ALLOW_DCACHE_WR 1
#define XPAR_MICROBLAZE_ALLOW_ICACHE_WR 1
#define XPAR_MICROBLAZE_AREA_OPTIMIZED 0
#define XPAR_MICROBLAZE_ASYNC_INTERRUPT 1
#define XPAR_MICROBLAZE_ASYNC_WAKEUP 3
#define XPAR_MICROBLAZE_AVOID_PRIMITIVES 0
#define XPAR_MICROBLAZE_BASE_VECTORS 0x0000000000000000
#define XPAR_MICROBLAZE_BRANCH_TARGET_CACHE_SIZE 0
#define XPAR_MICROBLAZE_CACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DADDR_SIZE 32
#define XPAR_MICROBLAZE_DATA_SIZE 32
#define XPAR_MICROBLAZE_DCACHE_ADDR_TAG 17
#define XPAR_MICROBLAZE_DCACHE_ALWAYS_USED 1
#define XPAR_MICROBLAZE_DCACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_DCACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DCACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_DCACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_DCACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_DCACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_DCACHE_USE_WRITEBACK 0
#define XPAR_MICROBLAZE_DCACHE_VICTIMS 0
#define XPAR_MICROBLAZE_DC_AXI_MON 0
#define XPAR_MICROBLAZE_DEBUG_COUNTER_WIDTH 32
#define XPAR_MICROBLAZE_DEBUG_ENABLED 1
#define XPAR_MICROBLAZE_DEBUG_EVENT_COUNTERS 5
#define XPAR_MICROBLAZE_DEBUG_EXTERNAL_TRACE 0
#define XPAR_MICROBLAZE_DEBUG_INTERFACE 0
#define XPAR_MICROBLAZE_DEBUG_LATENCY_COUNTERS 1
#define XPAR_MICROBLAZE_DEBUG_PROFILE_SIZE 0
#define XPAR_MICROBLAZE_DEBUG_TRACE_ASYNC_RESET 0
#define XPAR_MICROBLAZE_DEBUG_TRACE_SIZE 8192
#define XPAR_MICROBLAZE_DIV_ZERO_EXCEPTION 0
#define XPAR_MICROBLAZE_DP_AXI_MON 0
#define XPAR_MICROBLAZE_DYNAMIC_BUS_SIZING 0
#define XPAR_MICROBLAZE_D_AXI 1
#define XPAR_MICROBLAZE_D_LMB 1
#define XPAR_MICROBLAZE_D_LMB_MON 0
#define XPAR_MICROBLAZE_D_LMB_PROTOCOL 0
#define XPAR_MICROBLAZE_ECC_USE_CE_EXCEPTION 0
#define XPAR_MICROBLAZE_EDGE_IS_POSITIVE 1
#define XPAR_MICROBLAZE_ENABLE_DISCRETE_PORTS 0
#define XPAR_MICROBLAZE_ENDIANNESS 1
#define XPAR_MICROBLAZE_FAULT_TOLERANT 0
#define XPAR_MICROBLAZE_FPU_EXCEPTION 0
#define XPAR_MICROBLAZE_FREQ 100000000
#define XPAR_MICROBLAZE_FSL_EXCEPTION 0
#define XPAR_MICROBLAZE_FSL_LINKS 0
#define XPAR_MICROBLAZE_IADDR_SIZE 32
#define XPAR_MICROBLAZE_ICACHE_ALWAYS_USED 1
#define XPAR_MICROBLAZE_ICACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_ICACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_ICACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_ICACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_ICACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_ICACHE_STREAMS 0
#define XPAR_MICROBLAZE_ICACHE_VICTIMS 0
#define XPAR_MICROBLAZE_IC_AXI_MON 0
#define XPAR_MICROBLAZE_ILL_OPCODE_EXCEPTION 0
#define XPAR_MICROBLAZE_IMPRECISE_EXCEPTIONS 0
#define XPAR_MICROBLAZE_INSTR_SIZE 32
#define XPAR_MICROBLAZE_INTERCONNECT 2
#define XPAR_MICROBLAZE_INTERRUPT_IS_EDGE 0
#define XPAR_MICROBLAZE_INTERRUPT_MON 0
#define XPAR_MICROBLAZE_IP_AXI_MON 0
#define XPAR_MICROBLAZE_I_AXI 0
#define XPAR_MICROBLAZE_I_LMB 1
#define XPAR_MICROBLAZE_I_LMB_MON 0
#define XPAR_MICROBLAZE_I_LMB_PROTOCOL 0
#define XPAR_MICROBLAZE_LMB_DATA_SIZE 32
#define XPAR_MICROBLAZE_LOCKSTEP_MASTER 0
#define XPAR_MICROBLAZE_LOCKSTEP_SELECT 0
#define XPAR_MICROBLAZE_LOCKSTEP_SLAVE 0
#define XPAR_MICROBLAZE_M0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_MMU_DTLB_SIZE 4
#define XPAR_MICROBLAZE_MMU_ITLB_SIZE 2
#define XPAR_MICROBLAZE_MMU_PRIVILEGED_INSTR 0
#define XPAR_MICROBLAZE_MMU_TLB_ACCESS 3
#define XPAR_MICROBLAZE_MMU_ZONES 16
#define XPAR_MICROBLAZE_M_AXI_DC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_DC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_DC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_D_BUS_EXCEPTION 0
#define XPAR_MICROBLAZE_M_AXI_IC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_IC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_IC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_I_BUS_EXCEPTION 0
#define XPAR_MICROBLAZE_NUMBER_OF_PC_BRK 1
#define XPAR_MICROBLAZE_NUMBER_OF_RD_ADDR_BRK 0
#define XPAR_MICROBLAZE_NUMBER_OF_WR_ADDR_BRK 0
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_DEBUG 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_IRQ 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_DBG_CLK 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_DBG_TRACE_CLK 2
#define XPAR_MICROBLAZE_OPCODE_0X0_ILLEGAL 0
#define XPAR_MICROBLAZE_OPTIMIZATION 0
#define XPAR_MICROBLAZE_PC_WIDTH 32
#define XPAR_MICROBLAZE_PIADDR_SIZE 32
#define XPAR_MICROBLAZE_PVR 0
#define XPAR_MICROBLAZE_PVR_USER1 0x00
#define XPAR_MICROBLAZE_PVR_USER2 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR_BIP 0
#define XPAR_MICROBLAZE_RESET_MSR_DCE 0
#define XPAR_MICROBLAZE_RESET_MSR_EE 0
#define XPAR_MICROBLAZE_RESET_MSR_EIP 0
#define XPAR_MICROBLAZE_RESET_MSR_ICE 0
#define XPAR_MICROBLAZE_RESET_MSR_IE 0
#define XPAR_MICROBLAZE_S0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_SCO 0
#define XPAR_MICROBLAZE_TRACE 0
#define XPAR_MICROBLAZE_UNALIGNED_EXCEPTIONS 0
#define XPAR_MICROBLAZE_USE_BARREL 0
#define XPAR_MICROBLAZE_USE_BRANCH_TARGET_CACHE 0
#define XPAR_MICROBLAZE_USE_CONFIG_RESET 0
#define XPAR_MICROBLAZE_USE_DCACHE 0
#define XPAR_MICROBLAZE_USE_DIV 0
#define XPAR_MICROBLAZE_USE_EXTENDED_FSL_INSTR 0
#define XPAR_MICROBLAZE_USE_EXT_BRK 0
#define XPAR_MICROBLAZE_USE_EXT_NM_BRK 0
#define XPAR_MICROBLAZE_USE_FPU 0
#define XPAR_MICROBLAZE_USE_HW_MUL 0
#define XPAR_MICROBLAZE_USE_ICACHE 0
#define XPAR_MICROBLAZE_USE_INTERRUPT 1
#define XPAR_MICROBLAZE_USE_MMU 0
#define XPAR_MICROBLAZE_USE_MSR_INSTR 0
#define XPAR_MICROBLAZE_USE_NON_SECURE 0
#define XPAR_MICROBLAZE_USE_PCMP_INSTR 0
#define XPAR_MICROBLAZE_USE_REORDER_INSTR 1
#define XPAR_MICROBLAZE_USE_STACK_PROTECTION 0
#define XPAR_MICROBLAZE_COMPONENT_NAME base_mb_0
#define XPAR_MICROBLAZE_EDK_IPTYPE PROCESSOR
#define XPAR_MICROBLAZE_EDK_SPECIAL microblaze
#define XPAR_MICROBLAZE_G_TEMPLATE_LIST 0
#define XPAR_MICROBLAZE_G_USE_EXCEPTIONS 0

/******************************************************************/

#define STDIN_BASEADDRESS 0x00000000
#define STDOUT_BASEADDRESS 0x00000000

/******************************************************************/

/* Platform specific definitions */
#define PLATFORM_MB
 
/* Definitions for sleep timer configuration */
#define XSLEEP_TIMER_IS_DEFAULT_TIMER
 
 
/******************************************************************/

/* Definitions for peripheral ADDRESS_REMAP_0 */
#define XPAR_ADDRESS_REMAP_0_S_AXI_IN_BASEADDR 0x20000000
#define XPAR_ADDRESS_REMAP_0_S_AXI_IN_HIGHADDR 0x3FFFFFFF


/******************************************************************/

/* Definitions for driver GPIO */
#define XPAR_XGPIO_NUM_INSTANCES 1

/* Definitions for peripheral IOP_ARDUINO_ARDUINO_GPIO */
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_BASEADDR 0x40020000
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_HIGHADDR 0x4002FFFF
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_DEVICE_ID 0
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_INTERRUPT_PRESENT 1
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_IS_DUAL 0


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_ARDUINO_GPIO */
#define XPAR_GPIO_0_BASEADDR 0x40020000
#define XPAR_GPIO_0_HIGHADDR 0x4002FFFF
#define XPAR_GPIO_0_DEVICE_ID XPAR_IOP_ARDUINO_ARDUINO_GPIO_DEVICE_ID
#define XPAR_GPIO_0_INTERRUPT_PRESENT 1
#define XPAR_GPIO_0_IS_DUAL 0


/******************************************************************/

/* Definitions for driver IIC */
#define XPAR_XIIC_NUM_INSTANCES 1

/* Definitions for peripheral IOP_ARDUINO_IIC_DIRECT */
#define XPAR_IOP_ARDUINO_IIC_DIRECT_DEVICE_ID 0
#define XPAR_IOP_ARDUINO_IIC_DIRECT_BASEADDR 0x40800000
#define XPAR_IOP_ARDUINO_IIC_DIRECT_HIGHADDR 0x4080FFFF
#define XPAR_IOP_ARDUINO_IIC_DIRECT_TEN_BIT_ADR 0
#define XPAR_IOP_ARDUINO_IIC_DIRECT_GPO_WIDTH 1


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_IIC_DIRECT */
#define XPAR_IIC_0_DEVICE_ID XPAR_IOP_ARDUINO_IIC_DIRECT_DEVICE_ID
#define XPAR_IIC_0_BASEADDR 0x40800000
#define XPAR_IIC_0_HIGHADDR 0x4080FFFF
#define XPAR_IIC_0_TEN_BIT_ADR 0
#define XPAR_IIC_0_GPO_WIDTH 1


/******************************************************************/

#define XPAR_INTC_MAX_NUM_INTR_INPUTS 11
#define XPAR_XINTC_HAS_IPR 1
#define XPAR_XINTC_HAS_SIE 1
#define XPAR_XINTC_HAS_CIE 1
#define XPAR_XINTC_HAS_IVR 1
/* Definitions for driver INTC */
#define XPAR_XINTC_NUM_INSTANCES 1

/* Definitions for peripheral IOP_ARDUINO_INTC */
#define XPAR_IOP_ARDUINO_INTC_DEVICE_ID 0
#define XPAR_IOP_ARDUINO_INTC_BASEADDR 0x41200000
#define XPAR_IOP_ARDUINO_INTC_HIGHADDR 0x4120FFFF
#define XPAR_IOP_ARDUINO_INTC_KIND_OF_INTR 0xFFFFFB80
#define XPAR_IOP_ARDUINO_INTC_HAS_FAST 0
#define XPAR_IOP_ARDUINO_INTC_IVAR_RESET_VALUE 0x0000000000000010
#define XPAR_IOP_ARDUINO_INTC_NUM_INTR_INPUTS 11
#define XPAR_IOP_ARDUINO_INTC_NUM_SW_INTR 0
#define XPAR_IOP_ARDUINO_INTC_ADDR_WIDTH 32


/******************************************************************/

#define XPAR_INTC_SINGLE_BASEADDR 0x41200000
#define XPAR_INTC_SINGLE_HIGHADDR 0x4120FFFF
#define XPAR_INTC_SINGLE_DEVICE_ID XPAR_IOP_ARDUINO_INTC_DEVICE_ID
#define XPAR_IOP_ARDUINO_INTC_TYPE 0U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_INTERRUPT_MASK 0X000001U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_INTERRUPT_INTR 0U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_INTERRUPT_MASK 0X000002U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_INTERRUPT_INTR 1U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_INTERRUPT_MASK 0X000004U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_INTERRUPT_INTR 2U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_INTERRUPT_MASK 0X000008U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_INTERRUPT_INTR 3U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_INTERRUPT_MASK 0X000010U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_INTERRUPT_INTR 4U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_INTERRUPT_MASK 0X000020U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_INTERRUPT_INTR 5U
#define XPAR_IOP_ARDUINO_IIC_DIRECT_IIC2INTC_IRPT_MASK 0X000040U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_IIC_DIRECT_IIC2INTC_IRPT_INTR 6U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_IP2INTC_IRPT_MASK 0X000080U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_IP2INTC_IRPT_INTR 7U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_IP2INTC_IRPT_MASK 0X000100U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_IP2INTC_IRPT_INTR 8U
#define XPAR_IOP_ARDUINO_UARTLITE_INTERRUPT_MASK 0X000200U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_UARTLITE_INTERRUPT_INTR 9U
#define XPAR_IOP_ARDUINO_ARDUINO_GPIO_IP2INTC_IRPT_MASK 0X000400U
#define XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_ARDUINO_GPIO_IP2INTC_IRPT_INTR 10U

/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_INTC */
#define XPAR_INTC_0_DEVICE_ID XPAR_IOP_ARDUINO_INTC_DEVICE_ID
#define XPAR_INTC_0_BASEADDR 0x41200000U
#define XPAR_INTC_0_HIGHADDR 0x4120FFFFU
#define XPAR_INTC_0_KIND_OF_INTR 0xFFFFFB80U
#define XPAR_INTC_0_HAS_FAST 0U
#define XPAR_INTC_0_IVAR_RESET_VALUE 0x0000000000000010U
#define XPAR_INTC_0_NUM_INTR_INPUTS 11U
#define XPAR_INTC_0_NUM_SW_INTR 0U
#define XPAR_INTC_0_ADDR_WIDTH 32U
#define XPAR_INTC_0_INTC_TYPE 0U

#define XPAR_INTC_0_TMRCTR_0_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_INTERRUPT_INTR
#define XPAR_INTC_0_TMRCTR_1_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_INTERRUPT_INTR
#define XPAR_INTC_0_TMRCTR_2_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_INTERRUPT_INTR
#define XPAR_INTC_0_TMRCTR_3_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_INTERRUPT_INTR
#define XPAR_INTC_0_TMRCTR_4_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_INTERRUPT_INTR
#define XPAR_INTC_0_TMRCTR_5_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_INTERRUPT_INTR
#define XPAR_INTC_0_IIC_0_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_IIC_DIRECT_IIC2INTC_IRPT_INTR
#define XPAR_INTC_0_SPI_0_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_SPI_1_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_UARTLITE_0_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_UARTLITE_INTERRUPT_INTR
#define XPAR_INTC_0_GPIO_0_VEC_ID XPAR_IOP_ARDUINO_INTC_IOP_ARDUINO_ARDUINO_GPIO_IP2INTC_IRPT_INTR

/******************************************************************/

/* Definitions for driver INTRGPIO */
#define XPAR_INTRGPIO_NUM_INSTANCES 1

/* Definitions for peripheral IOP_ARDUINO_INTR */
#define XPAR_IOP_ARDUINO_INTR_BASEADDR 0x40010000
#define XPAR_IOP_ARDUINO_INTR_HIGHADDR 0x4001FFFF
#define XPAR_IOP_ARDUINO_INTR_DEVICE_ID 0
#define XPAR_IOP_ARDUINO_INTR_INTERRUPT_PRESENT 0
#define XPAR_IOP_ARDUINO_INTR_IS_DUAL 0


/******************************************************************/

/* Definitions for driver IO_SWITCH */
#define XPAR_IO_SWITCH_NUM_INSTANCES 1

/* Definitions for peripheral IOP_ARDUINO_IO_SWITCH */
#define XPAR_IOP_ARDUINO_IO_SWITCH_DEVICE_ID 0
#define XPAR_IOP_ARDUINO_IO_SWITCH_S_AXI_BASEADDR 0x44A20000
#define XPAR_IOP_ARDUINO_IO_SWITCH_S_AXI_HIGHADDR 0x44A2FFFF
#define XPAR_IOP_ARDUINO_IO_SWITCH_INTERFACE_TYPE 3
#define XPAR_IOP_ARDUINO_IO_SWITCH_IO_SWITCH_WIDTH 20
#define XPAR_IOP_ARDUINO_IO_SWITCH_NUM_PWMS 6
#define XPAR_IOP_ARDUINO_IO_SWITCH_NUM_TIMERS 8
#define XPAR_IOP_ARDUINO_IO_SWITCH_NUM_SS 1


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_IO_SWITCH */
#define XPAR_IO_SWITCH_0_DEVICE_ID XPAR_IOP_ARDUINO_IO_SWITCH_DEVICE_ID
#define XPAR_IO_SWITCH_0_S_AXI_BASEADDR 0x44A20000
#define XPAR_IO_SWITCH_0_S_AXI_HIGHADDR 0x44A2FFFF
#define XPAR_IO_SWITCH_0_INTERFACE_TYPE 3
#define XPAR_IO_SWITCH_0_IO_SWITCH_WIDTH 20
#define XPAR_IO_SWITCH_0_NUM_PWMS 6
#define XPAR_IO_SWITCH_0_NUM_TIMERS 8
#define XPAR_IO_SWITCH_0_NUM_SS 1


/******************************************************************/

/******* PARAMETERS RELATED TO IPs CONNECTED TO IO_SWITCH *******/
#define XPAR_IOP_ARDUINO_IO_SWITCH_GPIO_BASEADDR 0x40020000
#define XPAR_IO_SWITCH_0_GPIO_BASEADDR 0x40020000
#define XPAR_IOP_ARDUINO_IO_SWITCH_UART0_BASEADDR 0x40600000
#define XPAR_IO_SWITCH_0_UART0_BASEADDR 0x40600000
#define XPAR_IOP_ARDUINO_IO_SWITCH_SPI0_BASEADDR 0x44A00000
#define XPAR_IO_SWITCH_0_SPI0_BASEADDR 0x44A00000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM0_BASEADDR 0x41C00000
#define XPAR_IO_SWITCH_0_PWM0_BASEADDR 0x41C00000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM1_BASEADDR 0x41C10000
#define XPAR_IO_SWITCH_0_PWM1_BASEADDR 0x41C10000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM2_BASEADDR 0x41C20000
#define XPAR_IO_SWITCH_0_PWM2_BASEADDR 0x41C20000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM3_BASEADDR 0x41C30000
#define XPAR_IO_SWITCH_0_PWM3_BASEADDR 0x41C30000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM4_BASEADDR 0x41C40000
#define XPAR_IO_SWITCH_0_PWM4_BASEADDR 0x41C40000
#define XPAR_IOP_ARDUINO_IO_SWITCH_PWM5_BASEADDR 0x41C50000
#define XPAR_IO_SWITCH_0_PWM5_BASEADDR 0x41C50000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER0_BASEADDR 0x41C00000
#define XPAR_IO_SWITCH_0_TIMER0_BASEADDR 0x41C00000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER1_BASEADDR 0x41C10000
#define XPAR_IO_SWITCH_0_TIMER1_BASEADDR 0x41C10000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER2_BASEADDR 0x41C20000
#define XPAR_IO_SWITCH_0_TIMER2_BASEADDR 0x41C20000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER3_BASEADDR 0x41C30000
#define XPAR_IO_SWITCH_0_TIMER3_BASEADDR 0x41C30000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER4_BASEADDR 0x41C40000
#define XPAR_IO_SWITCH_0_TIMER4_BASEADDR 0x41C40000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER5_BASEADDR 0x41C50000
#define XPAR_IO_SWITCH_0_TIMER5_BASEADDR 0x41C50000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER6_BASEADDR 0x41C10000
#define XPAR_IO_SWITCH_0_TIMER6_BASEADDR 0x41C10000
#define XPAR_IOP_ARDUINO_IO_SWITCH_TIMER7_BASEADDR 0x41C20000
#define XPAR_IO_SWITCH_0_TIMER7_BASEADDR 0x41C20000
/* Definitions for driver SPI */
#define XPAR_XSPI_NUM_INSTANCES 2U

/* Definitions for peripheral IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT */
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_DEVICE_ID 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_BASEADDR 0x44A10000U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_HIGHADDR 0x44A1FFFFU
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_FIFO_EXIST 1U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_FIFO_DEPTH 16U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_SPI_SLAVE_ONLY 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_NUM_SS_BITS 1U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_NUM_TRANSFER_BITS 8U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_SPI_MODE 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_TYPE_OF_AXI4_INTERFACE 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_AXI4_BASEADDR 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_AXI4_HIGHADDR 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT_XIP_MODE 0U

/* Canonical definitions for peripheral IOP_ARDUINO_SPI_SUBSYSTEM_SPI_DIRECT */
#define XPAR_SPI_0_DEVICE_ID 0U
#define XPAR_SPI_0_BASEADDR 0x44A10000U
#define XPAR_SPI_0_HIGHADDR 0x44A1FFFFU
#define XPAR_SPI_0_FIFO_EXIST 1U
#define XPAR_SPI_0_FIFO_DEPTH 16U
#define XPAR_SPI_0_SPI_SLAVE_ONLY 0U
#define XPAR_SPI_0_NUM_SS_BITS 1U
#define XPAR_SPI_0_NUM_TRANSFER_BITS 8U
#define XPAR_SPI_0_SPI_MODE 0U
#define XPAR_SPI_0_TYPE_OF_AXI4_INTERFACE 0U
#define XPAR_SPI_0_AXI4_BASEADDR 0U
#define XPAR_SPI_0_AXI4_HIGHADDR 0U
#define XPAR_SPI_0_XIP_MODE 0U
#define XPAR_SPI_0_USE_STARTUP 0U



/* Definitions for peripheral IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED */
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_DEVICE_ID 1U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_BASEADDR 0x44A00000U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_HIGHADDR 0x44A0FFFFU
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_FIFO_EXIST 1U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_FIFO_DEPTH 16U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_SPI_SLAVE_ONLY 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_NUM_SS_BITS 1U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_NUM_TRANSFER_BITS 8U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_SPI_MODE 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_TYPE_OF_AXI4_INTERFACE 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_AXI4_BASEADDR 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_AXI4_HIGHADDR 0U
#define XPAR_IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED_XIP_MODE 0U

/* Canonical definitions for peripheral IOP_ARDUINO_SPI_SUBSYSTEM_SPI_SHARED */
#define XPAR_SPI_1_DEVICE_ID 1U
#define XPAR_SPI_1_BASEADDR 0x44A00000U
#define XPAR_SPI_1_HIGHADDR 0x44A0FFFFU
#define XPAR_SPI_1_FIFO_EXIST 1U
#define XPAR_SPI_1_FIFO_DEPTH 16U
#define XPAR_SPI_1_SPI_SLAVE_ONLY 0U
#define XPAR_SPI_1_NUM_SS_BITS 1U
#define XPAR_SPI_1_NUM_TRANSFER_BITS 8U
#define XPAR_SPI_1_SPI_MODE 0U
#define XPAR_SPI_1_TYPE_OF_AXI4_INTERFACE 0U
#define XPAR_SPI_1_AXI4_BASEADDR 0U
#define XPAR_SPI_1_AXI4_HIGHADDR 0U
#define XPAR_SPI_1_XIP_MODE 0U
#define XPAR_SPI_1_USE_STARTUP 0U



/******************************************************************/

/* Definitions for driver SYSMON */
#define XPAR_XSYSMON_NUM_INSTANCES 1U

/* Definitions for peripheral IOP_ARDUINO_XADC */
#define XPAR_IOP_ARDUINO_XADC_IP_TYPE 0U
#define XPAR_IOP_ARDUINO_XADC_DEVICE_ID 0U
#define XPAR_IOP_ARDUINO_XADC_BASEADDR 0x44A30000U
#define XPAR_IOP_ARDUINO_XADC_HIGHADDR 0x44A3FFFFU
#define XPAR_IOP_ARDUINO_XADC_INCLUDE_INTR 1U


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_XADC */
#define XPAR_SYSMON_0_IP_TYPE 0U
#define XPAR_SYSMON_0_DEVICE_ID XPAR_IOP_ARDUINO_XADC_DEVICE_ID
#define XPAR_SYSMON_0_BASEADDR 0x44A30000U
#define XPAR_SYSMON_0_HIGHADDR 0x44A3FFFFU
#define XPAR_SYSMON_0_INCLUDE_INTR 1U


/******************************************************************/

/* Definitions for driver TMRCTR */
#define XPAR_XTMRCTR_NUM_INSTANCES 6U

/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_DEVICE_ID 0U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_BASEADDR 0x41C00000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_HIGHADDR 0x41C0FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_DEVICE_ID 1U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_BASEADDR 0x41C10000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_HIGHADDR 0x41C1FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_DEVICE_ID 2U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_BASEADDR 0x41C20000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_HIGHADDR 0x41C2FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_DEVICE_ID 3U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_BASEADDR 0x41C30000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_HIGHADDR 0x41C3FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_DEVICE_ID 4U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_BASEADDR 0x41C40000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_HIGHADDR 0x41C4FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5 */
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_DEVICE_ID 5U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_BASEADDR 0x41C50000U
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_HIGHADDR 0x41C5FFFFU
#define XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_CLOCK_FREQ_HZ 100000000U


/******************************************************************/

/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0 */
#define XPAR_TMRCTR_0_DEVICE_ID 0U
#define XPAR_TMRCTR_0_BASEADDR 0x41C00000U
#define XPAR_TMRCTR_0_HIGHADDR 0x41C0FFFFU
#define XPAR_TMRCTR_0_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_0_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1 */
#define XPAR_TMRCTR_1_DEVICE_ID 1U
#define XPAR_TMRCTR_1_BASEADDR 0x41C10000U
#define XPAR_TMRCTR_1_HIGHADDR 0x41C1FFFFU
#define XPAR_TMRCTR_1_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_1_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2 */
#define XPAR_TMRCTR_2_DEVICE_ID 2U
#define XPAR_TMRCTR_2_BASEADDR 0x41C20000U
#define XPAR_TMRCTR_2_HIGHADDR 0x41C2FFFFU
#define XPAR_TMRCTR_2_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_2_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3 */
#define XPAR_TMRCTR_3_DEVICE_ID 3U
#define XPAR_TMRCTR_3_BASEADDR 0x41C30000U
#define XPAR_TMRCTR_3_HIGHADDR 0x41C3FFFFU
#define XPAR_TMRCTR_3_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_3_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4 */
#define XPAR_TMRCTR_4_DEVICE_ID 4U
#define XPAR_TMRCTR_4_BASEADDR 0x41C40000U
#define XPAR_TMRCTR_4_HIGHADDR 0x41C4FFFFU
#define XPAR_TMRCTR_4_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_4_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5 */
#define XPAR_TMRCTR_5_DEVICE_ID 5U
#define XPAR_TMRCTR_5_BASEADDR 0x41C50000U
#define XPAR_TMRCTR_5_HIGHADDR 0x41C5FFFFU
#define XPAR_TMRCTR_5_CLOCK_FREQ_HZ XPAR_IOP_ARDUINO_TIMERS_SUBSYSTEM_TIMER_5_CLOCK_FREQ_HZ

/******************************************************************/

/* Definitions for driver UARTLITE */
#define XPAR_XUARTLITE_NUM_INSTANCES 1U

/* Definitions for peripheral IOP_ARDUINO_UARTLITE */
#define XPAR_IOP_ARDUINO_UARTLITE_DEVICE_ID 0U
#define XPAR_IOP_ARDUINO_UARTLITE_BASEADDR 0x40600000U
#define XPAR_IOP_ARDUINO_UARTLITE_HIGHADDR 0x4060FFFFU
#define XPAR_IOP_ARDUINO_UARTLITE_BAUDRATE 9600U
#define XPAR_IOP_ARDUINO_UARTLITE_USE_PARITY 0U
#define XPAR_IOP_ARDUINO_UARTLITE_ODD_PARITY 0U
#define XPAR_IOP_ARDUINO_UARTLITE_DATA_BITS 8U

/* Canonical definitions for peripheral IOP_ARDUINO_UARTLITE */
#define XPAR_UARTLITE_0_DEVICE_ID 0U
#define XPAR_UARTLITE_0_BASEADDR 0x40600000U
#define XPAR_UARTLITE_0_HIGHADDR 0x4060FFFFU
#define XPAR_UARTLITE_0_BAUDRATE 9600U
#define XPAR_UARTLITE_0_USE_PARITY 0U
#define XPAR_UARTLITE_0_ODD_PARITY 0U
#define XPAR_UARTLITE_0_DATA_BITS 8U


/******************************************************************/
#endif  /* end of protection macro */
