#   Copyright (c) 2016, Xilinx, Inc.
#   All rights reserved.
# 
#   Redistribution and use in source and binary forms, with or without 
#   modification, are permitted provided that the following conditions are met:
#
#   1.  Redistributions of source code must retain the above copyright notice, 
#       this list of conditions and the following disclaimer.
#
#   2.  Redistributions in binary form must reproduce the above copyright 
#       notice, this list of conditions and the following disclaimer in the 
#       documentation and/or other materials provided with the distribution.
#
#   3.  Neither the name of the copyright holder nor the names of its 
#       contributors may be used to endorse or promote products derived from 
#       this software without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
#   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
#   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR 
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
#   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
#   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
#   OR BUSINESS INTERRUPTION). HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
#   WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
#   OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
#   ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import sys
import select
import termios
from time import sleep
import pytest
from pynq import Overlay
from pynq.lib.pmod import Pmod_LED8
from pynq.lib.pmod import PMODA
from pynq.lib.pmod import PMODB
from pynq.tests.util import user_answer_yes
from pynq.tests.util import get_interface_id


__author__ = "Giuseppe Natale, Yun Rock Qu"
__copyright__ = "Copyright 2016, Xilinx"
__email__ = "pynq_support@xilinx.com"


try:
    _ = Overlay('base.bit', download=False)
    flag0 = True
except IOError:
    flag0 = False
flag1 = user_answer_yes("\nPmod LED8 attached to the board?")
if flag1:
    led_id = eval(get_interface_id('Pmod LED8', options=['PMODA', 'PMODB']))
flag = flag0 and flag1


@pytest.mark.skipif(not flag, 
                    reason="need Pmod LED8 attached to the base overlay")
def test_led8():
    """Test for the Pmod LED8 module.

    There are 3 tests done here:

    1. Instantiate an LED8 object on index 0 and perform some actions 
    on it, requesting user confirmation.

    2. Instantiate 8 LED objects and shift from right to left.

    3. Toggles the states of the 8 LEDs.
    
    """
    Overlay('base.bit').download()
    leds = [Pmod_LED8(led_id, index) for index in range(8)]

    led = leds[0]
    led.on()
    assert led.read() == 1
    assert user_answer_yes("\nPmod LED 0 on?")
    led.off()
    assert led.read() == 0
    assert user_answer_yes("Pmod LED 0 off?")
    led.toggle()
    assert led.read() == 1
    led.write(0)
    assert led.read() == 0
    led.write(1)
    assert led.read() == 1
    led.off()
    for led in leds:
        led.off()
    
    print("Shifting LEDs on Pmod LED8.", end='')
    print("\nPress enter to stop shifting ...", end='')
    while True:
        for led in leds:
            led.on()
            sleep(0.1)
        for led in leds:
            led.off()
            sleep(0.1)
        if sys.stdin in select.select([sys.stdin], [], [], 0)[0]:
            termios.tcflush(sys.stdin, termios.TCIOFLUSH)
            break
    assert user_answer_yes("Pmod LEDs were shifting from LD0 to LD7?")

    for led in leds:
        led.off()
    leds[0].on()
    leds[2].on()
    leds[4].on()
    leds[6].on()

    print("Toggling LEDs on Pmod LED8.", end='')
    print("\nPress enter to stop toggling ...", end='')
    while True:
        for led in leds:
            led.toggle()
        sleep(0.2)
        if sys.stdin in select.select([sys.stdin], [], [], 0)[0]:
            termios.tcflush(sys.stdin, termios.TCIOFLUSH)
            break
    for led in leds:
        led.off()
    assert user_answer_yes("Pmod LEDs were toggling?")

    del leds
