from typing import Union, List, Optional

from pyspark.sql.types import StructType, StructField, StringType, BooleanType, DataType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ConformanceResourceSchema:
    """
    A conformance statement is a set of capabilities of a FHIR Server that may be
    used as a statement of actual server functionality or a statement of required
    or desired server implementation.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueQuantity",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A conformance statement is a set of capabilities of a FHIR Server that may be
        used as a statement of actual server functionality or a statement of required
        or desired server implementation.


            id: None
            extension: May be used to represent additional information that is not part of the basic
        definition of the element. In order to make the use of extensions safe and
        manageable, there is a strict set of governance  applied to the definition and
        use of extensions. Though any implementer is allowed to define an extension,
        there is a set of requirements that SHALL be met as part of the definition of
        the extension.
            modifierExtension: May be used to represent additional information that is not part of the basic
        definition of the element, and that modifies the understanding of the element
        that contains it. Usually modifier elements provide negation or qualification.
        In order to make the use of extensions safe and manageable, there is a strict
        set of governance applied to the definition and use of extensions. Though any
        implementer is allowed to define an extension, there is a set of requirements
        that SHALL be met as part of the definition of the extension. Applications
        processing a resource are required to check for modifier extensions.
            type: A type of resource exposed via the restful interface.
            profile: A specification of the profile that describes the solution's overall support
        for the resource, including any constraints on cardinality, bindings, lengths
        or other limitations. See further discussion in [Using
        Profiles]{profiling.html#profile-uses}.
            interaction: Identifies a restful operation supported by the solution.
            versioning: This field is set to no-version to specify that the system does not support
        (server) or use (client) versioning for this resource type. If this has some
        other value, the server must at least correctly track and populate the
        versionId meta-property on resources. If the value is 'versioned-update', then
        the server supports all the versioning features, including using e-tags for
        version integrity in the API.
            readHistory: A flag for whether the server is able to return past versions as part of the
        vRead operation.
            updateCreate: A flag to indicate that the server allows or needs to allow the client to
        create new identities on the server (e.g. that is, the client PUTs to a
        location where there is no existing resource). Allowing this operation means
        that the server allows the client to create new identities on the server.
            conditionalCreate: A flag that indicates that the server supports conditional create.
            conditionalUpdate: A flag that indicates that the server supports conditional update.
            conditionalDelete: A code that indicates how the server supports conditional delete.
            searchInclude: A list of _include values supported by the server.
            searchRevInclude: A list of _revinclude (reverse include) values supported by the server.
            searchParam: Search parameters for implementations to support and/or make use of - either
        references to ones defined in the specification, or additional ones defined
        for/by the implementation.
        """
        # id
        from spark_fhir_schemas.dstu2.simple_types.id import idSchema

        # extension
        from spark_fhir_schemas.dstu2.complex_types.extension import ExtensionSchema

        # type
        # type = code
        # profile
        from spark_fhir_schemas.dstu2.complex_types.reference import ReferenceSchema

        # interaction
        from spark_fhir_schemas.dstu2.backbone_elements.conformanceinteraction import (
            ConformanceInteractionSchema,
        )

        # searchParam
        from spark_fhir_schemas.dstu2.backbone_elements.conformancesearchparam import (
            ConformanceSearchParamSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ConformanceResource") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ConformanceResource"]
        schema = StructType(
            [
                # None
                StructField(
                    "id",
                    idSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # May be used to represent additional information that is not part of the basic
                # definition of the element, and that modifies the understanding of the element
                # that contains it. Usually modifier elements provide negation or qualification.
                # In order to make the use of extensions safe and manageable, there is a strict
                # set of governance applied to the definition and use of extensions. Though any
                # implementer is allowed to define an extension, there is a set of requirements
                # that SHALL be met as part of the definition of the extension. Applications
                # processing a resource are required to check for modifier extensions.
                StructField(
                    "modifierExtension",
                    ExtensionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A type of resource exposed via the restful interface.
                StructField("type", StringType(), True),
                # A specification of the profile that describes the solution's overall support
                # for the resource, including any constraints on cardinality, bindings, lengths
                # or other limitations. See further discussion in [Using
                # Profiles]{profiling.html#profile-uses}.
                StructField(
                    "profile",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Identifies a restful operation supported by the solution.
                StructField(
                    "interaction",
                    ConformanceInteractionSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # This field is set to no-version to specify that the system does not support
                # (server) or use (client) versioning for this resource type. If this has some
                # other value, the server must at least correctly track and populate the
                # versionId meta-property on resources. If the value is 'versioned-update', then
                # the server supports all the versioning features, including using e-tags for
                # version integrity in the API.
                StructField("versioning", StringType(), True),
                # A flag for whether the server is able to return past versions as part of the
                # vRead operation.
                StructField("readHistory", BooleanType(), True),
                # A flag to indicate that the server allows or needs to allow the client to
                # create new identities on the server (e.g. that is, the client PUTs to a
                # location where there is no existing resource). Allowing this operation means
                # that the server allows the client to create new identities on the server.
                StructField("updateCreate", BooleanType(), True),
                # A flag that indicates that the server supports conditional create.
                StructField("conditionalCreate", BooleanType(), True),
                # A flag that indicates that the server supports conditional update.
                StructField("conditionalUpdate", BooleanType(), True),
                # A code that indicates how the server supports conditional delete.
                StructField("conditionalDelete", StringType(), True),
                # A list of _include values supported by the server.
                StructField("searchInclude", StringType(), True),
                # A list of _revinclude (reverse include) values supported by the server.
                StructField("searchRevInclude", StringType(), True),
                # Search parameters for implementations to support and/or make use of - either
                # references to ones defined in the specification, or additional ones defined
                # for/by the implementation.
                StructField(
                    "searchParam",
                    ConformanceSearchParamSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
