# OCSP-Requester

## Overview

OCSP-Requester is a python package based on Alban Diquet's [nassl](https://github.com/nabla-c0d3/nassl) wrapper and the Python Cryptographic Authority's [cryptography](https://github.com/pyca/cryptography) package. Relying on a web browser to check the revocation status of a x509 digital certificate [has](https://www.imperialviolet.org/2014/04/19/revchecking.html) [been](https://www.imperialviolet.org/2014/04/29/revocationagain.html) [broken](https://scotthelme.co.uk/revocation-is-broken/) from the beginning, and validating certificates outside of the web browser is a manual process. OCSP-Requester aims to solve this by providing an automated means to check the [OCSP](https://en.wikipedia.org/wiki/Online_Certificate_Status_Protocol) revocation status for a x509 digital certificate.


## Pre-requisites

__Python__ - Python 3.7 (64-bit) and above.


## Installation

```pip install ocsp-checker```


## Usage

```
from ocspchecker import ocspchecker

ocsp_request = ocspchecker.get_ocsp_status("github.com")


```

## Sample Output

Sample output below, let me know if you want to add more fields/information to the output.

```
["Target": "microsoft.com", "OCSP URL": "http://ocsp.msocsp.com", "OCSP Status": "OCSPCertStatus.GOOD"]
```

PLEASE NOTE: If you run this on a network with a MITM SSL proxy, you may receive unintended results (see below):
```
{
  "Error Type": "Certificate Authority Information Access (AIA) Extension Missing",
  "Message": "No <ObjectIdentifier(oid=1.3.6.1.5.5.7.1.1, name=authorityInfoAccess)> extension was found for netflix.com. Possible MITM SSL Proxy"
}
```

## Feedback

Send me mail at joe@metlife.com