/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.MergingIterator;
import org.openstreetmap.osmosis.core.store.ChunkedObjectStore;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.PersistentIterator;
import org.openstreetmap.osmosis.core.store.Storeable;

public class FileBasedSort<T extends Storeable>
implements Closeable {
    private static final int MAX_MEMORY_SORT_COUNT = 16384;
    private static final int MAX_MERGE_SOURCE_COUNT = 2;
    private static final int MAX_MEMORY_SORT_DEPTH = 8;
    private ObjectSerializationFactory serializationFactory;
    private Comparator<T> comparator;
    private ChunkedObjectStore<T> chunkedEntityStore;
    private List<T> addBuffer;
    private boolean useCompression;

    public FileBasedSort(ObjectSerializationFactory serializationFactory, Comparator<T> comparator, boolean useCompression) {
        this.serializationFactory = serializationFactory;
        this.comparator = comparator;
        this.useCompression = useCompression;
        this.chunkedEntityStore = new ChunkedObjectStore(serializationFactory, "emta", "idx", useCompression);
        this.addBuffer = new ArrayList<T>(16384);
    }

    private void flushAddBuffer() {
        if (this.addBuffer.size() >= 0) {
            Collections.sort(this.addBuffer, this.comparator);
            for (Storeable entity : this.addBuffer) {
                this.chunkedEntityStore.add(entity);
            }
            this.addBuffer.clear();
            this.chunkedEntityStore.closeChunk();
        }
    }

    public void add(T value) {
        this.addBuffer.add(value);
        if (this.addBuffer.size() >= 16384) {
            this.flushAddBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<T> iteratePersisted(int nestLevel, long beginChunkIndex, long chunkCount) {
        try (PersistentIterator<T> persistentIterator = new PersistentIterator<T>(this.serializationFactory, this.iterate(nestLevel, beginChunkIndex, chunkCount), "emtb", this.useCompression);){
            PersistentIterator<T> result = persistentIterator;
            persistentIterator.hasNext();
            persistentIterator = null;
            PersistentIterator<T> persistentIterator2 = result;
            return persistentIterator2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<T> iterate(int nestLevel, long beginChunkIndex, long chunkCount) {
        ArrayList sources = new ArrayList();
        try {
            if (chunkCount <= 2L) {
                int i = 0;
                while ((long)i < chunkCount) {
                    sources.add(this.chunkedEntityStore.iterate(beginChunkIndex + (long)i));
                    ++i;
                }
            } else {
                long l = chunkCount / 2L;
                l += chunkCount % 2L;
                long maxChunkIndex = beginChunkIndex + chunkCount;
                for (long subFirstChunk = beginChunkIndex; subFirstChunk < maxChunkIndex; subFirstChunk += l) {
                    if (subFirstChunk + l > maxChunkIndex) {
                        l = maxChunkIndex - subFirstChunk;
                    }
                    if ((nestLevel + 1) % 8 == 0 && l > 1L) {
                        sources.add(this.iteratePersisted(nestLevel + 1, subFirstChunk, l));
                        continue;
                    }
                    sources.add(this.iterate(nestLevel + 1, subFirstChunk, l));
                }
            }
            MergingIterator mergingIterator = new MergingIterator(sources, this.comparator);
            sources.clear();
            MergingIterator mergingIterator2 = mergingIterator;
            return mergingIterator2;
        }
        finally {
            for (ReleasableIterator releasableIterator : sources) {
                releasableIterator.close();
            }
        }
    }

    public ReleasableIterator<T> iterate() {
        this.flushAddBuffer();
        return this.iterate(0, 0L, this.chunkedEntityStore.getChunkCount());
    }

    @Override
    public void close() {
        this.chunkedEntityStore.close();
    }
}

