import * as kms from '@aws-cdk/aws-kms';
import * as s3 from '@aws-cdk/aws-s3';
import * as ses from '@aws-cdk/aws-ses';
import * as sns from '@aws-cdk/aws-sns';
/**
 * Construction properties for a S3 action.
 *
 * @stability stable
 */
export interface S3Props {
    /**
     * The S3 bucket that incoming email will be saved to.
     *
     * @stability stable
     */
    readonly bucket: s3.IBucket;
    /**
     * The master key that SES should use to encrypt your emails before saving them to the S3 bucket.
     *
     * @default no encryption
     * @stability stable
     */
    readonly kmsKey?: kms.IKey;
    /**
     * The key prefix of the S3 bucket.
     *
     * @default no prefix
     * @stability stable
     */
    readonly objectKeyPrefix?: string;
    /**
     * The SNS topic to notify when the S3 action is taken.
     *
     * @default no notification
     * @stability stable
     */
    readonly topic?: sns.ITopic;
}
/**
 * Saves the received message to an Amazon S3 bucket and, optionally, publishes a notification to Amazon SNS.
 *
 * @stability stable
 */
export declare class S3 implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: S3Props);
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
