import * as ses from '@aws-cdk/aws-ses';
import * as sns from '@aws-cdk/aws-sns';
/**
 * The type of email encoding to use for a SNS action.
 *
 * @stability stable
 */
export declare enum EmailEncoding {
    /**
     * Base 64.
     *
     * @stability stable
     */
    BASE64 = "Base64",
    /**
     * UTF-8.
     *
     * @stability stable
     */
    UTF8 = "UTF-8"
}
/**
 * Construction properties for a SNS action.
 *
 * @stability stable
 */
export interface SnsProps {
    /**
     * The encoding to use for the email within the Amazon SNS notification.
     *
     * @default UTF-8
     * @stability stable
     */
    readonly encoding?: EmailEncoding;
    /**
     * The SNS topic to notify.
     *
     * @stability stable
     */
    readonly topic: sns.ITopic;
}
/**
 * Publishes the email content within a notification to Amazon SNS.
 *
 * @stability stable
 */
export declare class Sns implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: SnsProps);
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
