import * as ses from '@aws-cdk/aws-ses';
import * as sns from '@aws-cdk/aws-sns';
/**
 * Construction properties for a stop action.
 *
 * @stability stable
 */
export interface StopProps {
    /**
     * The SNS topic to notify when the stop action is taken.
     *
     * @stability stable
     */
    readonly topic?: sns.ITopic;
}
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a notification to Amazon SNS.
 *
 * @stability stable
 */
export declare class Stop implements ses.IReceiptRuleAction {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props?: StopProps);
    /**
     * Returns the receipt rule action specification.
     *
     * @stability stable
     */
    bind(_rule: ses.IReceiptRule): ses.ReceiptRuleActionConfig;
}
