# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetHttpResult',
    'AwaitableGetHttpResult',
    'get_http',
    'get_http_output',
]

@pulumi.output_type
class GetHttpResult:
    """
    A collection of values returned by getHttp.
    """
    def __init__(__self__, body=None, ca_cert_pem=None, id=None, insecure=None, method=None, request_body=None, request_headers=None, request_timeout_ms=None, response_body=None, response_body_base64=None, response_headers=None, retry=None, status_code=None, url=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if ca_cert_pem and not isinstance(ca_cert_pem, str):
            raise TypeError("Expected argument 'ca_cert_pem' to be a str")
        pulumi.set(__self__, "ca_cert_pem", ca_cert_pem)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insecure and not isinstance(insecure, bool):
            raise TypeError("Expected argument 'insecure' to be a bool")
        pulumi.set(__self__, "insecure", insecure)
        if method and not isinstance(method, str):
            raise TypeError("Expected argument 'method' to be a str")
        pulumi.set(__self__, "method", method)
        if request_body and not isinstance(request_body, str):
            raise TypeError("Expected argument 'request_body' to be a str")
        pulumi.set(__self__, "request_body", request_body)
        if request_headers and not isinstance(request_headers, dict):
            raise TypeError("Expected argument 'request_headers' to be a dict")
        pulumi.set(__self__, "request_headers", request_headers)
        if request_timeout_ms and not isinstance(request_timeout_ms, int):
            raise TypeError("Expected argument 'request_timeout_ms' to be a int")
        pulumi.set(__self__, "request_timeout_ms", request_timeout_ms)
        if response_body and not isinstance(response_body, str):
            raise TypeError("Expected argument 'response_body' to be a str")
        pulumi.set(__self__, "response_body", response_body)
        if response_body_base64 and not isinstance(response_body_base64, str):
            raise TypeError("Expected argument 'response_body_base64' to be a str")
        pulumi.set(__self__, "response_body_base64", response_body_base64)
        if response_headers and not isinstance(response_headers, dict):
            raise TypeError("Expected argument 'response_headers' to be a dict")
        pulumi.set(__self__, "response_headers", response_headers)
        if retry and not isinstance(retry, dict):
            raise TypeError("Expected argument 'retry' to be a dict")
        pulumi.set(__self__, "retry", retry)
        if status_code and not isinstance(status_code, int):
            raise TypeError("Expected argument 'status_code' to be a int")
        pulumi.set(__self__, "status_code", status_code)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The response body returned as a string. **NOTE**: This is deprecated, use `response_body` instead.
        """
        warnings.warn("""Use response_body instead""", DeprecationWarning)
        pulumi.log.warn("""body is deprecated: Use response_body instead""")

        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="caCertPem")
    def ca_cert_pem(self) -> Optional[str]:
        """
        Certificate data of the Certificate Authority (CA) in [PEM (RFC 1421)](https://datatracker.ietf.org/doc/html/rfc1421) format.
        """
        return pulumi.get(self, "ca_cert_pem")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The URL used for the request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        """
        Disables verification of the server's certificate chain and hostname. Defaults to `false`
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        The HTTP Method for the request. Allowed methods are a subset of methods defined in [RFC7231](https://datatracker.ietf.org/doc/html/rfc7231#section-4.3) namely, `GET`, `HEAD`, and `POST`. `POST` support is only intended for read-only URLs, such as submitting a search.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[str]:
        """
        The request body as a string.
        """
        return pulumi.get(self, "request_body")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Mapping[str, str]]:
        """
        A map of request header field names and values.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter(name="requestTimeoutMs")
    def request_timeout_ms(self) -> Optional[int]:
        """
        The request timeout in milliseconds.
        """
        return pulumi.get(self, "request_timeout_ms")

    @property
    @pulumi.getter(name="responseBody")
    def response_body(self) -> str:
        """
        The response body returned as a string.
        """
        return pulumi.get(self, "response_body")

    @property
    @pulumi.getter(name="responseBodyBase64")
    def response_body_base64(self) -> str:
        """
        The response body encoded as base64 (standard) as defined in [RFC 4648](https://datatracker.ietf.org/doc/html/rfc4648#section-4).
        """
        return pulumi.get(self, "response_body_base64")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Mapping[str, str]:
        """
        A map of response header field names and values. Duplicate headers are concatenated according to [RFC2616](https://www.w3.org/Protocols/rfc2616/rfc2616-sec4.html#sec4.2).
        """
        return pulumi.get(self, "response_headers")

    @property
    @pulumi.getter
    def retry(self) -> Optional['outputs.GetHttpRetryResult']:
        """
        Retry request configuration. By default there are no retries. Configuring this block will result in retries if an error is returned by the client (e.g., connection errors) or if a 5xx-range (except 501) status code is received. For further details see [go-retryablehttp](https://pkg.go.dev/github.com/hashicorp/go-retryablehttp).
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> int:
        """
        The HTTP response status code.
        """
        return pulumi.get(self, "status_code")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL for the request. Supported schemes are `get_http` and `https`.
        """
        return pulumi.get(self, "url")


class AwaitableGetHttpResult(GetHttpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHttpResult(
            body=self.body,
            ca_cert_pem=self.ca_cert_pem,
            id=self.id,
            insecure=self.insecure,
            method=self.method,
            request_body=self.request_body,
            request_headers=self.request_headers,
            request_timeout_ms=self.request_timeout_ms,
            response_body=self.response_body,
            response_body_base64=self.response_body_base64,
            response_headers=self.response_headers,
            retry=self.retry,
            status_code=self.status_code,
            url=self.url)


def get_http(ca_cert_pem: Optional[str] = None,
             insecure: Optional[bool] = None,
             method: Optional[str] = None,
             request_body: Optional[str] = None,
             request_headers: Optional[Mapping[str, str]] = None,
             request_timeout_ms: Optional[int] = None,
             retry: Optional[pulumi.InputType['GetHttpRetryArgs']] = None,
             url: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHttpResult:
    """
    Use this data source to access information about an existing resource.

    :param str ca_cert_pem: Certificate data of the Certificate Authority (CA) in [PEM (RFC 1421)](https://datatracker.ietf.org/doc/html/rfc1421) format.
    :param bool insecure: Disables verification of the server's certificate chain and hostname. Defaults to `false`
    :param str method: The HTTP Method for the request. Allowed methods are a subset of methods defined in [RFC7231](https://datatracker.ietf.org/doc/html/rfc7231#section-4.3) namely, `GET`, `HEAD`, and `POST`. `POST` support is only intended for read-only URLs, such as submitting a search.
    :param str request_body: The request body as a string.
    :param Mapping[str, str] request_headers: A map of request header field names and values.
    :param int request_timeout_ms: The request timeout in milliseconds.
    :param pulumi.InputType['GetHttpRetryArgs'] retry: Retry request configuration. By default there are no retries. Configuring this block will result in retries if an error is returned by the client (e.g., connection errors) or if a 5xx-range (except 501) status code is received. For further details see [go-retryablehttp](https://pkg.go.dev/github.com/hashicorp/go-retryablehttp).
    :param str url: The URL for the request. Supported schemes are `get_http` and `https`.
    """
    __args__ = dict()
    __args__['caCertPem'] = ca_cert_pem
    __args__['insecure'] = insecure
    __args__['method'] = method
    __args__['requestBody'] = request_body
    __args__['requestHeaders'] = request_headers
    __args__['requestTimeoutMs'] = request_timeout_ms
    __args__['retry'] = retry
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('http:index/getHttp:getHttp', __args__, opts=opts, typ=GetHttpResult).value

    return AwaitableGetHttpResult(
        body=pulumi.get(__ret__, 'body'),
        ca_cert_pem=pulumi.get(__ret__, 'ca_cert_pem'),
        id=pulumi.get(__ret__, 'id'),
        insecure=pulumi.get(__ret__, 'insecure'),
        method=pulumi.get(__ret__, 'method'),
        request_body=pulumi.get(__ret__, 'request_body'),
        request_headers=pulumi.get(__ret__, 'request_headers'),
        request_timeout_ms=pulumi.get(__ret__, 'request_timeout_ms'),
        response_body=pulumi.get(__ret__, 'response_body'),
        response_body_base64=pulumi.get(__ret__, 'response_body_base64'),
        response_headers=pulumi.get(__ret__, 'response_headers'),
        retry=pulumi.get(__ret__, 'retry'),
        status_code=pulumi.get(__ret__, 'status_code'),
        url=pulumi.get(__ret__, 'url'))


@_utilities.lift_output_func(get_http)
def get_http_output(ca_cert_pem: Optional[pulumi.Input[Optional[str]]] = None,
                    insecure: Optional[pulumi.Input[Optional[bool]]] = None,
                    method: Optional[pulumi.Input[Optional[str]]] = None,
                    request_body: Optional[pulumi.Input[Optional[str]]] = None,
                    request_headers: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                    request_timeout_ms: Optional[pulumi.Input[Optional[int]]] = None,
                    retry: Optional[pulumi.Input[Optional[pulumi.InputType['GetHttpRetryArgs']]]] = None,
                    url: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHttpResult]:
    """
    Use this data source to access information about an existing resource.

    :param str ca_cert_pem: Certificate data of the Certificate Authority (CA) in [PEM (RFC 1421)](https://datatracker.ietf.org/doc/html/rfc1421) format.
    :param bool insecure: Disables verification of the server's certificate chain and hostname. Defaults to `false`
    :param str method: The HTTP Method for the request. Allowed methods are a subset of methods defined in [RFC7231](https://datatracker.ietf.org/doc/html/rfc7231#section-4.3) namely, `GET`, `HEAD`, and `POST`. `POST` support is only intended for read-only URLs, such as submitting a search.
    :param str request_body: The request body as a string.
    :param Mapping[str, str] request_headers: A map of request header field names and values.
    :param int request_timeout_ms: The request timeout in milliseconds.
    :param pulumi.InputType['GetHttpRetryArgs'] retry: Retry request configuration. By default there are no retries. Configuring this block will result in retries if an error is returned by the client (e.g., connection errors) or if a 5xx-range (except 501) status code is received. For further details see [go-retryablehttp](https://pkg.go.dev/github.com/hashicorp/go-retryablehttp).
    :param str url: The URL for the request. Supported schemes are `get_http` and `https`.
    """
    ...
