#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['streams_explorer',
 'streams_explorer.api',
 'streams_explorer.api.dependencies',
 'streams_explorer.api.routes',
 'streams_explorer.core',
 'streams_explorer.core.extractor',
 'streams_explorer.core.extractor.default',
 'streams_explorer.core.services',
 'streams_explorer.models']

package_data = \
{'': ['*']}

install_requires = \
['aiofiles==0.6.0',
 'dynaconf==3.1.2',
 'fastapi==0.63.0',
 'kubernetes==12.0.1',
 'loguru==0.5.3',
 'matplotlib==3.3.3',
 'networkx==2.5',
 'numpy==1.19.5',
 'pandas==1.2.0',
 'prometheus-api-client==0.4.2',
 'pygraphviz==1.6',
 'uvicorn==0.13.3',
 'fastapi-utils==0.2.1']

extras_require = \
{'test': ['pytest',
          'pytest-cov',
          'pytest-mock',
          'nest-asyncio',
          'pytest-asyncio']}

setup(name='streams-explorer',
      version='1.0.2',
      description='Streams Explorer.',
      author='bakdata',
      author_email=None,
      url='https://github.com/bakdata/streams-explorer',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
