"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservabilityConfiguration = exports.TraceConfigurationVendor = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * The implementation provider chosen for tracing App Runner services
 *
 * @see https://docs.aws.amazon.com/apprunner/latest/dg/monitor.html
 */
var TraceConfigurationVendor;
(function (TraceConfigurationVendor) {
    /**
     * Tracing (X-Ray)
     */
    TraceConfigurationVendor["AWSXRAY"] = "AWSXRAY";
})(TraceConfigurationVendor || (exports.TraceConfigurationVendor = TraceConfigurationVendor = {}));
/**
 * The App Runner Observability configuration
 *
 * @resource AWS::AppRunner::ObservabilityConfiguration
 */
class ObservabilityConfiguration extends cdk.Resource {
    /**
     * Imports an App Runner Observability Configuration from attributes.
     */
    static fromObservabilityConfigurationAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromObservabilityConfigurationAttributes);
            }
            throw error;
        }
        const observabilityConfigurationName = attrs.observabilityConfigurationName;
        const observabilityConfigurationRevision = attrs.observabilityConfigurationRevision;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = cdk.Stack.of(this).formatArn({
                    resource: 'observabilityconfiguration',
                    service: 'apprunner',
                    resourceName: `${attrs.observabilityConfigurationName}/${attrs.observabilityConfigurationRevision}`,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner Observability Configuration from its ARN
     */
    static fromArn(scope, id, observabilityConfigurationArn) {
        const resourceParts = cdk.Fn.split('/', observabilityConfigurationArn);
        if (!resourceParts || resourceParts.length < 3) {
            throw new cdk.UnscopedValidationError(`Unexpected ARN format: ${observabilityConfigurationArn}.`);
        }
        const observabilityConfigurationName = cdk.Fn.select(0, resourceParts);
        const observabilityConfigurationRevision = Number(cdk.Fn.select(1, resourceParts));
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.observabilityConfigurationName = observabilityConfigurationName;
                this.observabilityConfigurationRevision = observabilityConfigurationRevision;
                this.observabilityConfigurationArn = observabilityConfigurationArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.observabilityConfigurationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ObservabilityConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ObservabilityConfiguration);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.observabilityConfigurationName !== undefined && !cdk.Token.isUnresolved(props.observabilityConfigurationName)) {
            if (props.observabilityConfigurationName.length < 4 || props.observabilityConfigurationName.length > 32) {
                throw new cdk.ValidationError(`\`observabilityConfigurationName\` must be between 4 and 32 characters, got: ${props.observabilityConfigurationName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.observabilityConfigurationName)) {
                throw new cdk.ValidationError(`\`observabilityConfigurationName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.observabilityConfigurationName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnObservabilityConfiguration(this, 'Resource', {
            observabilityConfigurationName: props.observabilityConfigurationName,
            traceConfiguration: {
                vendor: props.traceConfigurationVendor,
            },
        });
        this.observabilityConfigurationArn = resource.attrObservabilityConfigurationArn;
        this.observabilityConfigurationRevision = resource.attrObservabilityConfigurationRevision;
        this.observabilityConfigurationName = resource.ref;
    }
}
exports.ObservabilityConfiguration = ObservabilityConfiguration;
_a = JSII_RTTI_SYMBOL_1;
ObservabilityConfiguration[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.ObservabilityConfiguration", version: "2.189.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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