"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.IpAddressType = exports.HealthCheck = exports.HealthCheckProtocolType = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib/core");
const core_1 = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType || (exports.ImageRepositoryType = ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) {
        const numericPatterns = ['256', '512', '1024', '2048', '4096'];
        const unitPatterns = ['0.25 vCPU', '0.5 vCPU', '1 vCPU', '2 vCPU', '4 vCPU'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new cdk.UnscopedValidationError('CPU value is invalid');
        }
        return new Cpu(unit);
    }
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.189.1-alpha.0" };
/**
 * 0.25 vCPU
 */
Cpu.QUARTER_VCPU = Cpu.of('0.25 vCPU');
/**
 * 0.5 vCPU
 */
Cpu.HALF_VCPU = Cpu.of('0.5 vCPU');
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * 4 vCPU
 */
Cpu.FOUR_VCPU = Cpu.of('4 vCPU');
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) {
        const numericPatterns = ['512', '1024', '2048', '3072', '4096', '6144', '8192', '10240', '12288'];
        const unitPatterns = ['0.5 GB', '1 GB', '2 GB', '3 GB', '4 GB', '6 GB', '8 GB', '10 GB', '12 GB'];
        const allowedPatterns = numericPatterns.concat(unitPatterns);
        const isValidValue = allowedPatterns.some((pattern) => pattern === unit);
        if (!isValidValue) {
            throw new cdk.UnscopedValidationError('Memory value is invalid');
        }
        return new Memory(unit);
    }
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.189.1-alpha.0" };
/**
 * 0.5 GB(for 0.25 vCPU)
 */
Memory.HALF_GB = Memory.of('0.5 GB');
/**
 * 1 GB(for 0.25 or 0.5 vCPU)
 */
Memory.ONE_GB = Memory.of('1 GB');
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * 6 GB(for 2 vCPU)
 */
Memory.SIX_GB = Memory.of('6 GB');
/**
 * 8 GB(for 4 vCPU)
 */
Memory.EIGHT_GB = Memory.of('8 GB');
/**
 * 10 GB(for 4 vCPU)
 */
Memory.TEN_GB = Memory.of('10 GB');
/**
 * 12 GB(for 4 vCPU)
 */
Memory.TWELVE_GB = Memory.of('12 GB');
/**
 * The code runtimes
 */
class Runtime {
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.189.1-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * NodeJS 18
 */
Runtime.NODEJS_18 = Runtime.of('NODEJS_18');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Python 3.11
 */
Runtime.PYTHON_311 = Runtime.of('PYTHON_311');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.189.1-alpha.0" };
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.189.1-alpha.0" };
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.189.1-alpha.0" };
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.189.1-alpha.0" };
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.189.1-alpha.0" };
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType || (exports.ConfigurationSourceType = ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
    constructor(arn) {
        this.connectionArn = arn;
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.189.1-alpha.0" };
/**
 * The health check protocol type
 */
var HealthCheckProtocolType;
(function (HealthCheckProtocolType) {
    /**
     * HTTP protocol
     */
    HealthCheckProtocolType["HTTP"] = "HTTP";
    /**
     * TCP protocol
     */
    HealthCheckProtocolType["TCP"] = "TCP";
})(HealthCheckProtocolType || (exports.HealthCheckProtocolType = HealthCheckProtocolType = {}));
/**
 * Contains static factory methods for creating health checks for different protocols
 */
class HealthCheck {
    /**
     * Construct a HTTP health check
     */
    static http(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_HttpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.http);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.HTTP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold, options.path);
    }
    /**
     * Construct a TCP health check
     */
    static tcp(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_TcpHealthCheckOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.tcp);
            }
            throw error;
        }
        return new HealthCheck(HealthCheckProtocolType.TCP, options.healthyThreshold, options.interval, options.timeout, options.unhealthyThreshold);
    }
    constructor(healthCheckProtocolType, healthyThreshold = 1, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), unhealthyThreshold = 5, path) {
        this.healthCheckProtocolType = healthCheckProtocolType;
        this.healthyThreshold = healthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.unhealthyThreshold = unhealthyThreshold;
        this.path = path;
        if (this.healthCheckProtocolType === HealthCheckProtocolType.HTTP) {
            if (this.path !== undefined && this.path.length === 0) {
                throw new cdk.UnscopedValidationError('path length must be greater than 0');
            }
            if (this.path === undefined) {
                this.path = '/';
            }
        }
        if (this.healthyThreshold < 1 || this.healthyThreshold > 20) {
            throw new cdk.UnscopedValidationError(`healthyThreshold must be between 1 and 20, got ${this.healthyThreshold}`);
        }
        if (this.unhealthyThreshold < 1 || this.unhealthyThreshold > 20) {
            throw new cdk.UnscopedValidationError(`unhealthyThreshold must be between 1 and 20, got ${this.unhealthyThreshold}`);
        }
        if (this.interval.toSeconds() < 1 || this.interval.toSeconds() > 20) {
            throw new cdk.UnscopedValidationError(`interval must be between 1 and 20 seconds, got ${this.interval.toSeconds()}`);
        }
        if (this.timeout.toSeconds() < 1 || this.timeout.toSeconds() > 20) {
            throw new cdk.UnscopedValidationError(`timeout must be between 1 and 20 seconds, got ${this.timeout.toSeconds()}`);
        }
    }
    bind() {
        return {
            healthyThreshold: this.healthyThreshold,
            interval: this.interval?.toSeconds(),
            path: this.path,
            protocol: this.healthCheckProtocolType,
            timeout: this.timeout?.toSeconds(),
            unhealthyThreshold: this.unhealthyThreshold,
        };
    }
}
exports.HealthCheck = HealthCheck;
_k = JSII_RTTI_SYMBOL_1;
HealthCheck[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.HealthCheck", version: "2.189.1-alpha.0" };
/**
 * The IP address type for your incoming public network configuration.
 */
var IpAddressType;
(function (IpAddressType) {
    /**
     * IPV4
     */
    IpAddressType["IPV4"] = "IPV4";
    /**
     * DUAL_STACK
     */
    IpAddressType["DUAL_STACK"] = "DUAL_STACK";
})(IpAddressType || (exports.IpAddressType = IpAddressType = {}));
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
exports.Secret = Secret;
_l = JSII_RTTI_SYMBOL_1;
Secret[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.189.1-alpha.0" };
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole ?? this.createInstanceRole();
        this.grantPrincipal = this.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new cdk.ValidationError('configurationValues cannot be provided if the ConfigurationSource is Repository', this);
        }
        if (props.serviceName !== undefined && !cdk.Token.isUnresolved(props.serviceName)) {
            if (props.serviceName.length < 4 || props.serviceName.length > 40) {
                throw new cdk.ValidationError(`\`serviceName\` must be between 4 and 40 characters, got: ${props.serviceName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.serviceName)) {
                throw new cdk.ValidationError(`\`serviceName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.serviceName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            serviceName: this.props.serviceName,
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: core_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                autoDeploymentsEnabled: this.props.autoDeploymentsEnabled,
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            encryptionConfiguration: this.props.kmsKey ? {
                kmsKey: this.props.kmsKey.keyArn,
            } : undefined,
            autoScalingConfigurationArn: this.props.autoScalingConfiguration?.autoScalingConfigurationArn,
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
                ingressConfiguration: props.isPubliclyAccessible !== undefined ? { isPubliclyAccessible: props.isPubliclyAccessible } : undefined,
                ipAddressType: this.props.ipAddressType,
            },
            healthCheckConfiguration: this.props.healthCheck ?
                this.props.healthCheck.bind() :
                undefined,
            observabilityConfiguration: props.observabilityConfiguration ? {
                observabilityEnabled: true,
                observabilityConfigurationArn: props.observabilityConfiguration.observabilityConfigurationArn,
            } : undefined,
        });
        // grant required privileges for the role to access an image in Amazon ECR
        // See https://docs.aws.amazon.com/apprunner/latest/dg/security_iam_service-with-iam.html#security_iam_service-with-iam-roles
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
            this.source.ecrRepository.grant(this.accessRole, 'ecr:DescribeImages');
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        /**
         * Cloudformaton does not return the serviceName attribute so we extract it from the serviceArn.
         * The ARN comes with this format:
         * arn:aws:apprunner:us-east-1:123456789012:service/SERVICE_NAME/SERVICE_ID
         */
        // First, get the last element by splitting with ':'
        const resourceFullName = cdk.Fn.select(5, cdk.Fn.split(':', this.serviceArn));
        // Now, split the resourceFullName with '/' to get the serviceName
        this.serviceName = cdk.Fn.select(1, cdk.Fn.split('/', resourceFullName));
    }
    /**
     * Adds a statement to the instance role.
     */
    addToRolePolicy(statement) {
        this.instanceRole.addToPrincipalPolicy(statement);
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new cdk.ValidationError(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`, this);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new cdk.ValidationError(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`, this);
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new cdk.ValidationError([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '), this);
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: core_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: core_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
}
exports.Service = Service;
_m = JSII_RTTI_SYMBOL_1;
Service[_m] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.189.1-alpha.0" };
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addToRolePolicy", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addEnvironmentVariable", null);
__decorate([
    (0, metadata_resource_1.MethodMetadata)()
], Service.prototype, "addSecret", null);
//# sourceMappingURL=data:application/json;base64,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