"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcConnector = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * The App Runner VPC Connector
 *
 * @resource AWS::AppRunner::VpcConnector
 */
class VpcConnector extends cdk.Resource {
    /**
     * Import from VPC connector attributes.
     */
    static fromVpcConnectorAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcConnectorAttributes);
            }
            throw error;
        }
        const vpcConnectorArn = attrs.vpcConnectorArn;
        const vpcConnectorName = attrs.vpcConnectorName;
        const vpcConnectorRevision = attrs.vpcConnectorRevision;
        const securityGroups = attrs.securityGroups;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcConnectorArn = vpcConnectorArn;
                this.vpcConnectorName = vpcConnectorName;
                this.vpcConnectorRevision = vpcConnectorRevision;
                this.connections = new aws_ec2_1.Connections({ securityGroups });
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcConnectorName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcConnectorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcConnector);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.vpcConnectorName !== undefined && !cdk.Token.isUnresolved(props.vpcConnectorName)) {
            if (props.vpcConnectorName.length < 4 || props.vpcConnectorName.length > 40) {
                throw new cdk.ValidationError(`\`vpcConnectorName\` must be between 4 and 40 characters, got: ${props.vpcConnectorName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcConnectorName)) {
                throw new cdk.ValidationError(`\`vpcConnectorName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcConnectorName}.`, this);
            }
        }
        const securityGroups = props.securityGroups?.length ?
            props.securityGroups
            : [new ec2.SecurityGroup(this, 'SecurityGroup', { vpc: props.vpc })];
        const resource = new aws_apprunner_1.CfnVpcConnector(this, 'Resource', {
            subnets: props.vpc.selectSubnets(props.vpcSubnets).subnetIds,
            securityGroups: cdk.Lazy.list({ produce: () => this.connections.securityGroups.map(sg => sg.securityGroupId) }),
            vpcConnectorName: this.physicalName,
        });
        this.vpcConnectorArn = resource.attrVpcConnectorArn;
        this.vpcConnectorRevision = resource.attrVpcConnectorRevision;
        this.vpcConnectorName = resource.ref;
        this.connections = new aws_ec2_1.Connections({ securityGroups });
    }
}
exports.VpcConnector = VpcConnector;
_a = JSII_RTTI_SYMBOL_1;
VpcConnector[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcConnector", version: "2.189.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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