"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcIngressConnection = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib/core");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
/**
 * The App Runner VPC Ingress Connection
 *
 * @resource AWS::AppRunner::VpcIngressConnection
 */
class VpcIngressConnection extends cdk.Resource {
    /**
     * Import from VPC Ingress Connection from attributes.
     */
    static fromVpcIngressConnectionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromVpcIngressConnectionAttributes);
            }
            throw error;
        }
        const vpcIngressConnectionArn = attrs.vpcIngressConnectionArn;
        const domainName = attrs.domainName;
        const status = attrs.status;
        const vpcIngressConnectionName = attrs.vpcIngressConnectionName;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
                this.domainName = domainName;
                this.status = status;
                this.vpcIngressConnectionName = vpcIngressConnectionName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports an App Runner VPC Ingress Connection from its ARN
     */
    static fromArn(scope, id, vpcIngressConnectionArn) {
        const resourceParts = cdk.Fn.split('/', vpcIngressConnectionArn);
        const vpcIngressConnectionName = cdk.Fn.select(0, resourceParts);
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.vpcIngressConnectionName = vpcIngressConnectionName;
                this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.vpcIngressConnectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_VpcIngressConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, VpcIngressConnection);
            }
            throw error;
        }
        // Enhanced CDK Analytics Telemetry
        (0, metadata_resource_1.addConstructMetadata)(this, props);
        if (props.vpcIngressConnectionName !== undefined && !cdk.Token.isUnresolved(props.vpcIngressConnectionName)) {
            if (props.vpcIngressConnectionName.length < 4 || props.vpcIngressConnectionName.length > 40) {
                throw new cdk.ValidationError(`\`vpcIngressConnectionName\` must be between 4 and 40 characters, got: ${props.vpcIngressConnectionName.length} characters.`, this);
            }
            if (!/^[A-Za-z0-9][A-Za-z0-9\-_]*$/.test(props.vpcIngressConnectionName)) {
                throw new cdk.ValidationError(`\`vpcIngressConnectionName\` must start with an alphanumeric character and contain only alphanumeric characters, hyphens, or underscores after that, got: ${props.vpcIngressConnectionName}.`, this);
            }
        }
        const resource = new aws_apprunner_1.CfnVpcIngressConnection(this, 'Resource', {
            ingressVpcConfiguration: {
                vpcEndpointId: props.interfaceVpcEndpoint.vpcEndpointId,
                vpcId: props.vpc.vpcId,
            },
            serviceArn: props.service.serviceArn,
            vpcIngressConnectionName: this.physicalName,
        });
        this.vpcIngressConnectionArn = resource.attrVpcIngressConnectionArn;
        this.vpcIngressConnectionName = resource.ref;
        this.domainName = resource.attrDomainName;
        this.status = resource.attrStatus;
    }
}
exports.VpcIngressConnection = VpcIngressConnection;
_a = JSII_RTTI_SYMBOL_1;
VpcIngressConnection[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.VpcIngressConnection", version: "2.189.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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