"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("aws-cdk-lib");
const aws_ivs_1 = require("aws-cdk-lib/aws-ivs");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
  A new IVS Playback Key Pair
*/
class PlaybackKeyPair extends PlaybackKeyPairBase {
    constructor(scope, id, props) {
        super(scope, id, {});
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ivs_alpha_PlaybackKeyPairProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PlaybackKeyPair);
            }
            throw error;
        }
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new aws_ivs_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "@aws-cdk/aws-ivs-alpha.PlaybackKeyPair", version: "2.51.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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