# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['fastdtlmapper',
 'fastdtlmapper.angst',
 'fastdtlmapper.angst.model',
 'fastdtlmapper.bin',
 'fastdtlmapper.bin.OrthoFinder',
 'fastdtlmapper.bin.OrthoFinder.scripts_of',
 'fastdtlmapper.bin.OrthoFinder.tools',
 'fastdtlmapper.bin.angst.angst_lib',
 'fastdtlmapper.bin.angst.tree_lib',
 'fastdtlmapper.goea',
 'fastdtlmapper.scripts',
 'fastdtlmapper.util']

package_data = \
{'': ['*'],
 'fastdtlmapper.bin': ['mafft/*',
                       'mafft/mafftdir/bin/*',
                       'mafft/mafftdir/libexec/*'],
 'fastdtlmapper.bin.OrthoFinder.scripts_of': ['bin/*']}

install_requires = \
['PyQt5>=5.15.5,<6.0.0',
 'biopython>=1.79,<2.0',
 'ete3>=3.1.2,<4.0.0',
 'goatools>=1.1.6,<2.0.0',
 'numpy>=1.21.2,<2.0.0',
 'pandas>=1.3.3,<2.0.0',
 'scipy>=1.7.1,<2.0.0']

entry_points = \
{'console_scripts': ['FastDTLgoea = fastdtlmapper.scripts.FastDTLgoea:main',
                     'FastDTLmapper = fastdtlmapper.scripts.FastDTLmapper:main',
                     'plot_gain_loss_map = '
                     'fastdtlmapper.scripts.plot_gain_loss_map:main']}

setup_kwargs = {
    'name': 'fastdtlmapper',
    'version': '0.3.3',
    'description': 'Fast genome-wide DTL(Duplication-Transfer-Loss) event mapping tool',
    'long_description': "# FastDTLmapper: Fast genome-wide DTL event mapper\n\n![Python3](https://img.shields.io/badge/Language-Python_3.7_|_3.8_|_3.9-steelblue)\n![OS](https://img.shields.io/badge/OS-Linux-steelblue)\n![License](https://img.shields.io/badge/License-GPL3.0-steelblue)\n[![Latest PyPI version](https://img.shields.io/pypi/v/fastdtlmapper.svg)](https://pypi.python.org/pypi/fastdtlmapper)\n[![Downloads](https://static.pepy.tech/personalized-badge/fastdtlmapper?period=total&units=international_system&left_color=grey&right_color=orange&left_text=Downloads)](https://pepy.tech/project/fastdtlmapper)  \n![CI workflow](https://github.com/moshi4/FastDTLmapper/actions/workflows/ci.yml/badge.svg)\n[![codecov](https://codecov.io/gh/moshi4/FastDTLmapper/branch/main/graph/badge.svg?token=ZJ8D747JUY)](https://codecov.io/gh/moshi4/FastDTLmapper)\n\n## Table of contents\n\n- [Overview](#overview)\n- [Install](#install)\n- [Analysis Pipeline](#analysis-pipeline)\n- [Command Usage](#command-usage)\n- [Output Contents](#output-contents)\n- [Further Analysis](#further-analysis)\n\n## Overview\n\nGene gain/loss is considered to be one of the most important evolutionary processes\ndriving adaptive evolution, but it remains largely unexplored.\nTherefore, to investigate the relationship between gene gain/loss and adaptive evolution\nin the evolutionary process of organisms, I developed a software pipeline **FastDTLmapper**\nwhich automatically estimates and maps genome-wide gene gain/loss.  \nFastDTLmapper takes two inputs, 1. *Species tree (Newick format)* & 2. *Genomic Protein CDSs (Fasta|Genbank format)*,\nand performs genome-wide mapping of DTL(Duplication-Transfer-Loss) events by\nDTL reconciliation of species tree and gene trees.\nAdditionally, FastDTLmapper can perform\n[Plot Gain/Loss Map Figure](#plot-gainloss-map-figure) and\n[Functional Analysis (GOEA)](#functional-analysis-goea)\nusing packaged subtools.  \n\n![demo_all_gain_loss_map.png](https://github.com/moshi4/FastDTLmapper/wiki/images/demo_all_gain_loss_map.png)  \n**Fig. Genome-wide gain/loss map result example (all_gain_loss_map.nwk)**  \nEach node gain/loss data is mapped in following format (*NodeID | GeneNum [gain=GainNum los=LossNum]*)  \nMap data is embeded in newick format bootstrap value field and user can visualize using [SeaView](http://doua.prabi.fr/software/seaview).  \n\n## Install\n\nFastDTLmapper is implemented in **Python3(>=3.7)** and runs on **Linux** (Tested on Ubuntu20.04).  \n> :warning: Additionally, dependent tools require **Python2.7** and **Perl5**.  \n\n**Install PyPI stable package:**\n\n    pip install fastdtlmapper\n\n**Install latest development package:**\n\n    pip install git+git://github.com/moshi4/FastDTLmapper.git\n\n**Use Docker ([Image Registry](https://github.com/moshi4/FastDTLmapper/pkgs/container/fastdtlmapper)):**\n\n    docker pull ghcr.io/moshi4/fastdtlmapper:v0.3.2\n    docker run ghcr.io/moshi4/fastdtlmapper:v0.3.2 FastDTLmapper -h\n\n### Dependencies\n\nPython package dependencies list here (auto installed with pip).\n\nWell known python package `numpy`, `pandas`, `scipy` and\n\n- [BioPython](https://github.com/biopython/biopython)  \n  Utility tools for computational molecular biology\n- [GOAtools](https://github.com/tanghaibao/goatools)  \n  GOEA(GO Enrichment Analysis) tool\n- [ETE3](http://etetoolkit.org/)  \n  Tree analysis and visualization tool\n\nFollowing dependencies are packaged in [src/fastdtlmapper/bin](https://github.com/moshi4/FastDTLmapper/tree/main/src/fastdtlmapper/bin) directory.  \n\n- [OrthoFinder](https://github.com/davidemms/OrthoFinder) [v2.5.2]  \n  Orthology inference tool\n- [mafft](https://mafft.cbrc.jp/alignment/software/) [v7.487]  \n  Sequences alignment tool\n- [trimal](http://trimal.cgenomics.org/) [v1.4]  \n  Alignment sequences trim tool\n- [IQ-TREE](http://www.iqtree.org/) [v2.1.3]  \n  Phylogenetic tree reconstruction tool\n- [Treerecs](https://project.inria.fr/treerecs/) [v1.2]  \n  Multifurcated gene tree correction tool  \n- [AnGST](https://github.com/almlab/angst)  \n  DTL reconciliation tool (Requires Python 2.7 to run)\n- [parallel](https://www.gnu.org/software/parallel/) [v20200922]  \n  Job parallelization tool (Requires Perl5 to run)\n\n<details>\n<summary> Dependencies Citation List</summary>\n\nBioPython:\n>Cock, P.J.A. et al.  \n>Biopython: freely available Python tools for computational molecular biology and bioinformatics. (2009)  \n>Bioinformatics 25(11) 1422-3  \n\nGOAtools:\n>Klopfenstein DV, Zhang L, Pedersen BS, ... Tang H  \n>GOATOOLS: A Python library for Gene Ontologyy analyses (2018)  \n>Scientific reports 8:10872  \n\nETE:\n>Huerta-Cepas J., Serra F. and Bork P.  \n>ETE 3: Reconstruction, analysis and visualization of phylogenomic data (2016)  \n>Mol Biol Evol 33(6) 1635-1638\n\nOrthoFinder:\n>Emms D.M. & Kelly S.  \n>OrthoFinder: phylogenetic orthology inference for comparative genomics (2019)  \n>Genome Biology 20:238  \n\nMAFFT:\n>Yamada, Tomii, Katoh.  \n>Application of the MAFFT sequence alignment program to large data—reexamination of the usefulness of chained guide trees. (2016)  \n>Bioinformatics 32:3246-3251  \n\ntrimAl:\n>Salvador Capella-Gutierrez; Jose M. Silla-Martinez; Toni Gabaldon.  \n>trimAl: a tool for automated alignment trimming in large-scale phylogenetic analyses. (2009)  \n>Bioinformatics 25: 1972-1973.  \n\nIQ-TREE:\n>B.Q. Minh, H.A. Schmidt, O. Chernomor, D. Schrempf, M.D. Woodhams, A. von Haeseler, R. Lanfear.  \n>IQ-TREE 2: New models and efficient methods for phylogenetic inference in the genomic era. (2020)  \n>Mol. Biol. Evol. 37:1530-1534.  \n\nTreerecs:\n>Comte N, Morel B, Hasic D, Guéguen L, Boussau B, Daubin V, Penel S, Scornavacca C, Gouy M, Stamatakis A, et al.  \n>Treerecs: an integrated phylogenetic tool, from sequences to reconciliations (2020)  \n>Bioinformatics 36:4822–4824  \n  \nAnGST:\n>Lawrence A David and Eric J Alm.  \n>Rapid evolutionary innovation during an Archaean genetic expansion. (2010)  \n>Nature. 469(7328):93-6  \n\nparallel:\n>O. Tange  \n>GNU Parallel - The Command-Line Power Tool, ;login: (2011)  \n>The USENIX Magazine, February 2011:42-47.  \n  \n</details>\n\n## Analysis Pipeline\n\nThis is brief description of analysis pipeline. See [wiki](https://github.com/moshi4/FastDTLmapper/wiki/1.1.-Analysis-Pipeline-(FastDTLmapper)) for details.\n\n1. Grouping ortholog sequences using OrthoFinder\n2. Align each OG(Ortholog Group) sequences using mafft\n3. Trim each OG alignment using trimal\n4. Reconstruct each OG gene tree using IQ-TREE\n5. Correct each OG gene tree multifurcation using Treerecs\n6. DTL reconciliation of species tree & each OG gene tree using AnGST\n7. Aggregate and map genome-wide DTL reconciliation result\n\n## Command Usage\n\n### Basic Command\n\n    FastDTLmapper -i [fasta|genbank directory] -t [species tree file] -o [output directory]\n\n### Options\n\n    -h, --help            show this help message and exit\n    -i IN, --indir IN     Input Fasta(*.fa|*.faa|*.fasta), Genbank(*.gb|*.gbk|*.gbff) directory\n    -t TREE, --tree TREE  Input rooted species newick tree file\n    -o OUT, --outdir OUT  Output directory\n    -p , --process_num    Number of processor (Default: MaxProcessor - 1)\n    --dup_cost            Duplication event cost (Default: 2)\n    --los_cost            Loss event cost (Default: 1)\n    --trn_cost            Transfer event cost (Default: 3)\n    --inflation           OrthoFinder MCL inflation parameter (Default: 3.0)\n    --timetree            Use species tree as timetree in AnGST (Default: off)\n    --rseed               Number of random seed (Default: 0)\n\n- **Timetree Option**\n\n  If user set this option, input species tree must be ultrametric tree.  \n  --timetree enable AnGST timetree option below (See [AnGST manual](<https://github.com/almlab/angst/blob/master/doc/manual.pdf>) for details).  \n  > If the branch lengths on the provided species tree represent times,\n  > AnGST can restrict the set of possible inferred gene transfers to\n  > only those between contemporaneous lineages  \n\n- **Input Limitation**\n\n  fasta or genbank files (--indir option)  \n  >:warning: Following characters cannot be included in file name '_', '-', '|', '.', '$'  \n\n  species tree file (--tree option)  \n  >:warning: Species name in species tree must match fasta or genbank file name  \n\n### Example Command\n\nClick [here](https://github.com/moshi4/FastDTLmapper/wiki/dataset/example.zip) to download dataset (5.8Mb).  \n\nThis dataset is identical to [example](https://github.com/moshi4/FastDTLmapper/tree/main/example) in this repository.\n\n- **Minimum test dataset**\n\n  7 species, 100 CDS limited fasta dataset\n\n      FastDTLmapper -i example/minimum_dataset/fasta/ -t example/minimum_dataset/species_tree.nwk -o output_minimum\n\n- **Mycoplasma dataset (Input Format = Fasta)**\n\n  7 Mycoplasma species, 500 ~ 1000 CDS fasta dataset\n\n      FastDTLmapper -i example/mycoplasma_dataset/fasta/ -t example/mycoplasma_dataset/species_tree.nwk -o output_mycoplasma_fasta\n\n- **Mycoplasma dataset (Input Format = Genbank)**\n\n  7 Mycoplasma species, 500 ~ 1000 CDS genbank dataset\n\n      FastDTLmapper -i example/mycoplasma_dataset/genbank/ -t example/mycoplasma_dataset/species_tree.nwk -o output_mycoplasma_genbank\n\n## Output Contents\n\n### Output Top Directory\n\n| Top directory           | Contents                                                     |\n| ----------------------- | ------------------------------------------------------------ |\n| 00_user_data            | Formatted user input fasta and tree files                    |\n| 01_orthofinder          | OrthoFinder raw output results                               |\n| 02_dtl_reconciliation   | Each OG(Ortholog Group) DTL reconciliation result            |\n| 03_aggregate_map_result | Genome-wide DTL reconciliation aggregated and mapped results |\n| log                     | Config log and command log files                             |\n\n### Output Directory Structure & Files\n\n    .\n    ├── 00_user_data/  -- User input data\n    │\xa0\xa0 ├── fasta/     -- Formatted fasta files\n    │\xa0\xa0 └── tree/      -- Formatted newick species tree files\n    │\n    ├── 01_orthofinder/  -- OrthoFinder raw output results\n    │\n    ├── 02_dtl_reconciliation/  -- Each OG(Ortholog Group) DTL reconciliation result\n    │\xa0\xa0 ├── OG0000000/\n    │\xa0\xa0 │   ├── OG0000000.fa                 -- OG fasta file\n    │\xa0\xa0 │   ├── OG0000000_aln.fa             -- OG alignment fasta file\n    │\xa0\xa0 │   ├── OG0000000_aln_trim.fa        -- Trimmed OG alignement fasta file\n    │\xa0\xa0 │   ├── OG0000000_dtl_map.nwk        -- OG DTL event mapped tree file\n    │\xa0\xa0 │   ├── OG0000000_gain_loss_map.nwk  -- OG Gain-Loss event mapped tree file\n    │\xa0\xa0 │   ├── iqtree/                      -- IQ-TREE gene tree reconstruction result\n    │\xa0\xa0 │   ├── treerecs/                    -- Treerecs multifurcated gene tree correction result\n    │\xa0\xa0 │   └── angst/                       -- AnGST DTL reconciliation result\n    │\xa0\xa0 │\n    │\xa0\xa0 ├── OG0000001/\n    │\xa0\xa0 . \n    │\xa0\xa0 . \n    │\xa0\xa0 └── OGXXXXXXX/\n    │\n    ├── 03_aggregate_map_result/  -- Genome-wide DTL reconciliation aggregated and mapped results\n    │\xa0\xa0 ├── all_dtl_map.nwk              -- Genome-wide DTL event mapped tree file\n    │\xa0\xa0 ├── all_gain_loss_map.nwk        -- Genome-wide Gain-Loss event mapped tree file\n    │\xa0\xa0 ├── all_og_node_event.tsv        -- All OG DTL event record file\n    │\xa0\xa0 ├── all_transfer_gene_count.tsv  -- All transfer gene count file\n    │\xa0\xa0 └── all_transfer_gene_list.tsv   -- All transfer gene list file\n    │\n    └── log/\n        ├── parallel_cmds/ -- Parallel run command log results\n        └── run_config.log -- Program run config log file\n\nSee [wiki](https://github.com/moshi4/FastDTLmapper/wiki/1.2.-Output-Contents-(FastDTLmapper)) for output files details.\n\n## Further Analysis\n\n### Plot Gain/Loss Map Figure\n\nFastDTLmapper subtool `plot_gain_loss_map` supports for plotting\npublication-ready gain/loss map figure as shown below.\nUser can plot easily and can output in any format user want by\nchanging plotting parameter.\nSee [wiki](https://github.com/moshi4/FastDTLmapper/wiki/3.1.-Usage-(plot_gain_loss_map)) for details.\n\n![demo_plot_all_gain_loss_map.png](https://github.com/moshi4/FastDTLmapper/wiki/images/demo_plot_all_gain_loss_map.png)  \n**Fig. Gain/Loss map plot result example**\n\n### Functional Analysis (GOEA)\n\nFastDTLmapper subtool `FastDTLgoea` supports for performing\nGOEA(GO Enrichment Analysis) in each node gain/loss genes.\nEach node gain/loss gene's significant GOterms are\nlisted and plotted as shown below.\nThis GOEA functional analysis is useful for getting glasp of genome-wide\nfunctional trends in gain/loss genes. See [wiki](https://github.com/moshi4/FastDTLmapper/wiki/2.1.-Usage-(FastDTLgoea)) for details.\n\n![demo_plot_goea.png](https://github.com/moshi4/FastDTLmapper/wiki/images/demo_plot_goea.png)  \n**Fig. GOEA plot result example**  \nIn this example, gain gene's significant over representation\nGOterms in N023 node is plotted with color.\nCC indicates GO category of 'Cell Components'. 3 GO category BP,MF,CC exists.\n",
    'author': 'moshi',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/moshi4/FastDTLmapper/',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<3.10',
}


setup(**setup_kwargs)
