# mypy-boto3-cloudhsm

[![PyPI - mypy-boto3-cloudhsm](https://img.shields.io/pypi/v/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudhsm.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudhsm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-cloudhsm](#mypy-boto3-cloudhsm)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.CloudHSM 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/cloudhsm.html#CloudHSM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.3](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloudhsm](#mypy-boto3-cloudhsm)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudHSM` service.

```bash
python -m pip install boto3-stubs[cloudhsm]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_cloudhsm` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_cloudhsm import CloudHSMClient

# Now mypy can check if your code is valid.
client: CloudHSMClient = boto3.client("cloudhsm")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CloudHSMClient = session.client("cloudhsm")



# Annotated paginators are included as well

import mypy_boto3_cloudhsm.paginator as cloudhsm_paginators

list_hapgs_paginator: cloudhsm_paginators.ListHapgsPaginator = client.get_paginator("list_hapgs")
list_hsms_paginator: cloudhsm_paginators.ListHsmsPaginator = client.get_paginator("list_hsms")
list_luna_clients_paginator: cloudhsm_paginators.ListLunaClientsPaginator = client.get_paginator("list_luna_clients")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_cloudhsm` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_cloudhsm as cloudhsm
from mypy_boto3_cloudhsm import CloudHSMClient

# with these
from mypy_boto3 import cloudhsm
from mypy_boto3.cloudhsm import CloudHSMClient
```