# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = [
    'ContainerCapabilitiesArgs',
    'ContainerDeviceArgs',
    'ContainerHealthcheckArgs',
    'ContainerHostArgs',
    'ContainerLabelArgs',
    'ContainerMountArgs',
    'ContainerMountBindOptionsArgs',
    'ContainerMountTmpfsOptionsArgs',
    'ContainerMountVolumeOptionsArgs',
    'ContainerMountVolumeOptionsLabelArgs',
    'ContainerNetworkDataArgs',
    'ContainerNetworksAdvancedArgs',
    'ContainerPortArgs',
    'ContainerUlimitArgs',
    'ContainerUploadArgs',
    'ContainerVolumeArgs',
    'NetworkIpamConfigArgs',
    'NetworkLabelArgs',
    'PluginGrantPermissionArgs',
    'ProviderRegistryAuthArgs',
    'RegistryImageBuildArgs',
    'RegistryImageBuildAuthConfigArgs',
    'RegistryImageBuildUlimitArgs',
    'RemoteImageBuildArgs',
    'SecretLabelArgs',
    'ServiceAuthArgs',
    'ServiceConvergeConfigArgs',
    'ServiceEndpointSpecArgs',
    'ServiceEndpointSpecPortArgs',
    'ServiceLabelArgs',
    'ServiceModeArgs',
    'ServiceModeReplicatedArgs',
    'ServiceRollbackConfigArgs',
    'ServiceTaskSpecArgs',
    'ServiceTaskSpecContainerSpecArgs',
    'ServiceTaskSpecContainerSpecConfigArgs',
    'ServiceTaskSpecContainerSpecDnsConfigArgs',
    'ServiceTaskSpecContainerSpecHealthcheckArgs',
    'ServiceTaskSpecContainerSpecHostArgs',
    'ServiceTaskSpecContainerSpecLabelArgs',
    'ServiceTaskSpecContainerSpecMountArgs',
    'ServiceTaskSpecContainerSpecMountBindOptionsArgs',
    'ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs',
    'ServiceTaskSpecContainerSpecMountVolumeOptionsArgs',
    'ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs',
    'ServiceTaskSpecContainerSpecPrivilegesArgs',
    'ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs',
    'ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs',
    'ServiceTaskSpecContainerSpecSecretArgs',
    'ServiceTaskSpecLogDriverArgs',
    'ServiceTaskSpecPlacementArgs',
    'ServiceTaskSpecPlacementPlatformArgs',
    'ServiceTaskSpecResourcesArgs',
    'ServiceTaskSpecResourcesLimitsArgs',
    'ServiceTaskSpecResourcesReservationArgs',
    'ServiceTaskSpecResourcesReservationGenericResourcesArgs',
    'ServiceTaskSpecRestartPolicyArgs',
    'ServiceUpdateConfigArgs',
    'VolumeLabelArgs',
    'CacheFromArgs',
    'DockerBuildArgs',
    'RegistryArgs',
]

@pulumi.input_type
class ContainerCapabilitiesArgs:
    def __init__(__self__, *,
                 adds: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 drops: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] adds: List of linux capabilities to add.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] drops: List of linux capabilities to drop.
        """
        if adds is not None:
            pulumi.set(__self__, "adds", adds)
        if drops is not None:
            pulumi.set(__self__, "drops", drops)

    @property
    @pulumi.getter
    def adds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of linux capabilities to add.
        """
        return pulumi.get(self, "adds")

    @adds.setter
    def adds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "adds", value)

    @property
    @pulumi.getter
    def drops(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of linux capabilities to drop.
        """
        return pulumi.get(self, "drops")

    @drops.setter
    def drops(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "drops", value)


@pulumi.input_type
class ContainerDeviceArgs:
    def __init__(__self__, *,
                 host_path: pulumi.Input[str],
                 container_path: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host_path: The path on the host where the device is located.
        :param pulumi.Input[str] container_path: The path in the container where the device will be bound.
        :param pulumi.Input[str] permissions: The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        pulumi.set(__self__, "host_path", host_path)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> pulumi.Input[str]:
        """
        The path on the host where the device is located.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path in the container where the device will be bound.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[str]]:
        """
        The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class ContainerHealthcheckArgs:
    def __init__(__self__, *,
                 tests: pulumi.Input[Sequence[pulumi.Input[str]]],
                 interval: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 start_period: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tests: Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        :param pulumi.Input[str] interval: Time between running the check (ms|s|m|h). Defaults to `0s`.
        :param pulumi.Input[int] retries: Consecutive failures needed to report unhealthy. Defaults to `0`.
        :param pulumi.Input[str] start_period: Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        :param pulumi.Input[str] timeout: Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def tests(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tests", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        """
        Time between running the check (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        """
        Consecutive failures needed to report unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[str]]:
        """
        Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_period", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ContainerHostArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 ip: pulumi.Input[str]):
        """
        :param pulumi.Input[str] host: Hostname to add
        :param pulumi.Input[str] ip: IP address this hostname should resolve to.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        """
        Hostname to add
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        """
        IP address this hostname should resolve to.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class ContainerLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerMountArgs:
    def __init__(__self__, *,
                 target: pulumi.Input[str],
                 type: pulumi.Input[str],
                 bind_options: Optional[pulumi.Input['ContainerMountBindOptionsArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tmpfs_options: Optional[pulumi.Input['ContainerMountTmpfsOptionsArgs']] = None,
                 volume_options: Optional[pulumi.Input['ContainerMountVolumeOptionsArgs']] = None):
        """
        :param pulumi.Input[str] target: Container path
        :param pulumi.Input[str] type: The mount type
        :param pulumi.Input['ContainerMountBindOptionsArgs'] bind_options: Optional configuration for the bind type.
        :param pulumi.Input[bool] read_only: Whether the mount should be read-only.
        :param pulumi.Input[str] source: Mount source (e.g. a volume name, a host path).
        :param pulumi.Input['ContainerMountTmpfsOptionsArgs'] tmpfs_options: Optional configuration for the tmpfs type.
        :param pulumi.Input['ContainerMountVolumeOptionsArgs'] volume_options: Optional configuration for the volume type.
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        Container path
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The mount type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional[pulumi.Input['ContainerMountBindOptionsArgs']]:
        """
        Optional configuration for the bind type.
        """
        return pulumi.get(self, "bind_options")

    @bind_options.setter
    def bind_options(self, value: Optional[pulumi.Input['ContainerMountBindOptionsArgs']]):
        pulumi.set(self, "bind_options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the mount should be read-only.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Mount source (e.g. a volume name, a host path).
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional[pulumi.Input['ContainerMountTmpfsOptionsArgs']]:
        """
        Optional configuration for the tmpfs type.
        """
        return pulumi.get(self, "tmpfs_options")

    @tmpfs_options.setter
    def tmpfs_options(self, value: Optional[pulumi.Input['ContainerMountTmpfsOptionsArgs']]):
        pulumi.set(self, "tmpfs_options", value)

    @property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional[pulumi.Input['ContainerMountVolumeOptionsArgs']]:
        """
        Optional configuration for the volume type.
        """
        return pulumi.get(self, "volume_options")

    @volume_options.setter
    def volume_options(self, value: Optional[pulumi.Input['ContainerMountVolumeOptionsArgs']]):
        pulumi.set(self, "volume_options", value)


@pulumi.input_type
class ContainerMountBindOptionsArgs:
    def __init__(__self__, *,
                 propagation: Optional[pulumi.Input[str]] = None):
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @property
    @pulumi.getter
    def propagation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "propagation")

    @propagation.setter
    def propagation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "propagation", value)


@pulumi.input_type
class ContainerMountTmpfsOptionsArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[int]] = None,
                 size_bytes: Optional[pulumi.Input[int]] = None):
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_bytes", value)


@pulumi.input_type
class ContainerMountVolumeOptionsArgs:
    def __init__(__self__, *,
                 driver_name: Optional[pulumi.Input[str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountVolumeOptionsLabelArgs']]]] = None,
                 no_copy: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ContainerMountVolumeOptionsLabelArgs']]] labels: User-defined key/value metadata
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "driver_name")

    @driver_name.setter
    def driver_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_name", value)

    @property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "driver_options")

    @driver_options.setter
    def driver_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_options", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountVolumeOptionsLabelArgs']]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContainerMountVolumeOptionsLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "no_copy")

    @no_copy.setter
    def no_copy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_copy", value)


@pulumi.input_type
class ContainerMountVolumeOptionsLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ContainerNetworkDataArgs:
    def __init__(__self__, *,
                 gateway: Optional[pulumi.Input[str]] = None,
                 global_ipv6_address: Optional[pulumi.Input[str]] = None,
                 global_ipv6_prefix_length: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_prefix_length: Optional[pulumi.Input[int]] = None,
                 ipv6_gateway: Optional[pulumi.Input[str]] = None,
                 network_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] gateway: The network gateway of the container.
        :param pulumi.Input[str] ip_address: The IP address of the container.
        :param pulumi.Input[int] ip_prefix_length: The IP prefix length of the container.
        """
        if gateway is not None:
            warnings.warn("""Use `network_data` instead. The network gateway of the container as read from its NetworkSettings.""", DeprecationWarning)
            pulumi.log.warn("""gateway is deprecated: Use `network_data` instead. The network gateway of the container as read from its NetworkSettings.""")
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if global_ipv6_address is not None:
            pulumi.set(__self__, "global_ipv6_address", global_ipv6_address)
        if global_ipv6_prefix_length is not None:
            pulumi.set(__self__, "global_ipv6_prefix_length", global_ipv6_prefix_length)
        if ip_address is not None:
            warnings.warn("""Use `network_data` instead. The IP address of the container's first network it.""", DeprecationWarning)
            pulumi.log.warn("""ip_address is deprecated: Use `network_data` instead. The IP address of the container's first network it.""")
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_prefix_length is not None:
            warnings.warn("""Use `network_data` instead. The IP prefix length of the container as read from its NetworkSettings.""", DeprecationWarning)
            pulumi.log.warn("""ip_prefix_length is deprecated: Use `network_data` instead. The IP prefix length of the container as read from its NetworkSettings.""")
        if ip_prefix_length is not None:
            pulumi.set(__self__, "ip_prefix_length", ip_prefix_length)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The network gateway of the container.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="globalIpv6Address")
    def global_ipv6_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "global_ipv6_address")

    @global_ipv6_address.setter
    def global_ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_ipv6_address", value)

    @property
    @pulumi.getter(name="globalIpv6PrefixLength")
    def global_ipv6_prefix_length(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "global_ipv6_prefix_length")

    @global_ipv6_prefix_length.setter
    def global_ipv6_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "global_ipv6_prefix_length", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the container.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipPrefixLength")
    def ip_prefix_length(self) -> Optional[pulumi.Input[int]]:
        """
        The IP prefix length of the container.
        """
        return pulumi.get(self, "ip_prefix_length")

    @ip_prefix_length.setter
    def ip_prefix_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_prefix_length", value)

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "ipv6_gateway")

    @ipv6_gateway.setter
    def ipv6_gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_gateway", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_name", value)


@pulumi.input_type
class ContainerNetworksAdvancedArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aliases: The network aliases of the container in the specific network.
        :param pulumi.Input[str] ipv4_address: The IPV4 address of the container in the specific network.
        :param pulumi.Input[str] ipv6_address: The IPV6 address of the container in the specific network.
        """
        pulumi.set(__self__, "name", name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The network aliases of the container in the specific network.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPV4 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPV6 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)


@pulumi.input_type
class ContainerPortArgs:
    def __init__(__self__, *,
                 internal: pulumi.Input[int],
                 external: Optional[pulumi.Input[int]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] internal: Port within the container.
        :param pulumi.Input[int] external: Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        :param pulumi.Input[str] ip: IP address/mask that can access this port. Defaults to `0.0.0.0`.
        :param pulumi.Input[str] protocol: Protocol that can be used over this port. Defaults to `tcp`.
        """
        pulumi.set(__self__, "internal", internal)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def internal(self) -> pulumi.Input[int]:
        """
        Port within the container.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: pulumi.Input[int]):
        pulumi.set(self, "internal", value)

    @property
    @pulumi.getter
    def external(self) -> Optional[pulumi.Input[int]]:
        """
        Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        """
        return pulumi.get(self, "external")

    @external.setter
    def external(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "external", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address/mask that can access this port. Defaults to `0.0.0.0`.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Protocol that can be used over this port. Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ContainerUlimitArgs:
    def __init__(__self__, *,
                 hard: pulumi.Input[int],
                 name: pulumi.Input[str],
                 soft: pulumi.Input[int]):
        """
        :param pulumi.Input[int] hard: The hard limit
        :param pulumi.Input[str] name: The name of the ulimit
        :param pulumi.Input[int] soft: The soft limit
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @property
    @pulumi.getter
    def hard(self) -> pulumi.Input[int]:
        """
        The hard limit
        """
        return pulumi.get(self, "hard")

    @hard.setter
    def hard(self, value: pulumi.Input[int]):
        pulumi.set(self, "hard", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the ulimit
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def soft(self) -> pulumi.Input[int]:
        """
        The soft limit
        """
        return pulumi.get(self, "soft")

    @soft.setter
    def soft(self, value: pulumi.Input[int]):
        pulumi.set(self, "soft", value)


@pulumi.input_type
class ContainerUploadArgs:
    def __init__(__self__, *,
                 file: pulumi.Input[str],
                 content: Optional[pulumi.Input[str]] = None,
                 content_base64: Optional[pulumi.Input[str]] = None,
                 executable: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_hash: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] file: Path to the file in the container where is upload goes to
        :param pulumi.Input[str] content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        :param pulumi.Input[bool] executable: If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        :param pulumi.Input[str] source: A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        :param pulumi.Input[str] source_hash: If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        pulumi.set(__self__, "file", file)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)

    @property
    @pulumi.getter
    def file(self) -> pulumi.Input[str]:
        """
        Path to the file in the container where is upload goes to
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[str]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_base64", value)

    @property
    @pulumi.getter
    def executable(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        """
        return pulumi.get(self, "executable")

    @executable.setter
    def executable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "executable", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[pulumi.Input[str]]:
        """
        If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        return pulumi.get(self, "source_hash")

    @source_hash.setter
    def source_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_hash", value)


@pulumi.input_type
class ContainerVolumeArgs:
    def __init__(__self__, *,
                 container_path: Optional[pulumi.Input[str]] = None,
                 from_container: Optional[pulumi.Input[str]] = None,
                 host_path: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 volume_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] container_path: The path in the container where the volume will be mounted.
        :param pulumi.Input[str] from_container: The container where the volume is coming from.
        :param pulumi.Input[str] host_path: The path on the host where the volume is coming from.
        :param pulumi.Input[bool] read_only: If `true`, this volume will be readonly. Defaults to `false`.
        :param pulumi.Input[str] volume_name: The name of the docker volume which should be mounted.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if from_container is not None:
            pulumi.set(__self__, "from_container", from_container)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path in the container where the volume will be mounted.
        """
        return pulumi.get(self, "container_path")

    @container_path.setter
    def container_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_path", value)

    @property
    @pulumi.getter(name="fromContainer")
    def from_container(self) -> Optional[pulumi.Input[str]]:
        """
        The container where the volume is coming from.
        """
        return pulumi.get(self, "from_container")

    @from_container.setter
    def from_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "from_container", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path on the host where the volume is coming from.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_path", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, this volume will be readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the docker volume which should be mounted.
        """
        return pulumi.get(self, "volume_name")

    @volume_name.setter
    def volume_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "volume_name", value)


@pulumi.input_type
class NetworkIpamConfigArgs:
    def __init__(__self__, *,
                 aux_address: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 ip_range: Optional[pulumi.Input[str]] = None,
                 subnet: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] aux_address: Auxiliary IPv4 or IPv6 addresses used by Network driver
        :param pulumi.Input[str] gateway: The IP address of the gateway
        :param pulumi.Input[str] ip_range: The ip range in CIDR form
        :param pulumi.Input[str] subnet: The subnet in CIDR form
        """
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Auxiliary IPv4 or IPv6 addresses used by Network driver
        """
        return pulumi.get(self, "aux_address")

    @aux_address.setter
    def aux_address(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "aux_address", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the gateway
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[str]]:
        """
        The ip range in CIDR form
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet in CIDR form
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class NetworkLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PluginGrantPermissionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] name: The name of the permission
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The value of the permission
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the permission
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The value of the permission
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ProviderRegistryAuthArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 config_file: Optional[pulumi.Input[str]] = None,
                 config_file_content: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "address", address)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if config_file_content is not None:
            pulumi.set(__self__, "config_file_content", config_file_content)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_file")

    @config_file.setter
    def config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file", value)

    @property
    @pulumi.getter(name="configFileContent")
    def config_file_content(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_file_content")

    @config_file_content.setter
    def config_file_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_file_content", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class RegistryImageBuildArgs:
    def __init__(__self__, *,
                 context: pulumi.Input[str],
                 auth_configs: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildAuthConfigArgs']]]] = None,
                 build_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 build_id: Optional[pulumi.Input[str]] = None,
                 cache_froms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cgroup_parent: Optional[pulumi.Input[str]] = None,
                 cpu_period: Optional[pulumi.Input[int]] = None,
                 cpu_quota: Optional[pulumi.Input[int]] = None,
                 cpu_set_cpus: Optional[pulumi.Input[str]] = None,
                 cpu_set_mems: Optional[pulumi.Input[str]] = None,
                 cpu_shares: Optional[pulumi.Input[int]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 extra_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_remove: Optional[pulumi.Input[bool]] = None,
                 isolation: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 memory_swap: Optional[pulumi.Input[int]] = None,
                 network_mode: Optional[pulumi.Input[str]] = None,
                 no_cache: Optional[pulumi.Input[bool]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 pull_parent: Optional[pulumi.Input[bool]] = None,
                 remote_context: Optional[pulumi.Input[str]] = None,
                 remove: Optional[pulumi.Input[bool]] = None,
                 security_opts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 session_id: Optional[pulumi.Input[str]] = None,
                 shm_size: Optional[pulumi.Input[int]] = None,
                 squash: Optional[pulumi.Input[bool]] = None,
                 suppress_output: Optional[pulumi.Input[bool]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 ulimits: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildUlimitArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] context: The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildAuthConfigArgs']]] auth_configs: The configuration for the authentication
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_args: Pairs for build-time variables in the form TODO
        :param pulumi.Input[str] build_id: BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cache_froms: Images to consider as cache sources
        :param pulumi.Input[str] cgroup_parent: Optional parent cgroup for the container
        :param pulumi.Input[int] cpu_period: The length of a CPU period in microseconds
        :param pulumi.Input[int] cpu_quota: Microseconds of CPU time that the container can get in a CPU period
        :param pulumi.Input[str] cpu_set_cpus: CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        :param pulumi.Input[str] cpu_set_mems: MEMs in which to allow execution (`0-3`, `0`, `1`)
        :param pulumi.Input[int] cpu_shares: CPU shares (relative weight)
        :param pulumi.Input[str] dockerfile: Dockerfile file. Defaults to `Dockerfile`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extra_hosts: A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        :param pulumi.Input[bool] force_remove: Always remove intermediate containers
        :param pulumi.Input[str] isolation: Isolation represents the isolation technology of a container. The supported values are
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined key/value metadata
        :param pulumi.Input[int] memory: Set memory limit for build
        :param pulumi.Input[int] memory_swap: Total memory (memory + swap), -1 to enable unlimited swap
        :param pulumi.Input[str] network_mode: Set the networking mode for the RUN instructions during build
        :param pulumi.Input[bool] no_cache: Do not use the cache when building the image
        :param pulumi.Input[str] platform: Set platform if server is multi-platform capable
        :param pulumi.Input[bool] pull_parent: Attempt to pull the image even if an older image exists locally
        :param pulumi.Input[str] remote_context: A Git repository URI or HTTP/HTTPS context URI
        :param pulumi.Input[bool] remove: Remove intermediate containers after a successful build (default behavior)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_opts: The security options
        :param pulumi.Input[str] session_id: Set an ID for the build session
        :param pulumi.Input[int] shm_size: Size of /dev/shm in bytes. The size must be greater than 0
        :param pulumi.Input[bool] squash: If true the new layers are squashed into a new image with a single new layer
        :param pulumi.Input[bool] suppress_output: Suppress the build output and print image ID on success
        :param pulumi.Input[str] target: Set the target build stage to build
        :param pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildUlimitArgs']]] ulimits: Configuration for ulimits
        :param pulumi.Input[str] version: Version of the underlying builder to use
        """
        pulumi.set(__self__, "context", context)
        if auth_configs is not None:
            pulumi.set(__self__, "auth_configs", auth_configs)
        if build_args is not None:
            pulumi.set(__self__, "build_args", build_args)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if cache_froms is not None:
            pulumi.set(__self__, "cache_froms", cache_froms)
        if cgroup_parent is not None:
            pulumi.set(__self__, "cgroup_parent", cgroup_parent)
        if cpu_period is not None:
            pulumi.set(__self__, "cpu_period", cpu_period)
        if cpu_quota is not None:
            pulumi.set(__self__, "cpu_quota", cpu_quota)
        if cpu_set_cpus is not None:
            pulumi.set(__self__, "cpu_set_cpus", cpu_set_cpus)
        if cpu_set_mems is not None:
            pulumi.set(__self__, "cpu_set_mems", cpu_set_mems)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pull_parent is not None:
            pulumi.set(__self__, "pull_parent", pull_parent)
        if remote_context is not None:
            pulumi.set(__self__, "remote_context", remote_context)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if suppress_output is not None:
            pulumi.set(__self__, "suppress_output", suppress_output)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def context(self) -> pulumi.Input[str]:
        """
        The absolute path to the context folder. You can use the helper function '${path.cwd}/context-dir'.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: pulumi.Input[str]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="authConfigs")
    def auth_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildAuthConfigArgs']]]]:
        """
        The configuration for the authentication
        """
        return pulumi.get(self, "auth_configs")

    @auth_configs.setter
    def auth_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildAuthConfigArgs']]]]):
        pulumi.set(self, "auth_configs", value)

    @property
    @pulumi.getter(name="buildArgs")
    def build_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Pairs for build-time variables in the form TODO
        """
        return pulumi.get(self, "build_args")

    @build_args.setter
    def build_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_args", value)

    @property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[pulumi.Input[str]]:
        """
        BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        """
        return pulumi.get(self, "build_id")

    @build_id.setter
    def build_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_id", value)

    @property
    @pulumi.getter(name="cacheFroms")
    def cache_froms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Images to consider as cache sources
        """
        return pulumi.get(self, "cache_froms")

    @cache_froms.setter
    def cache_froms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cache_froms", value)

    @property
    @pulumi.getter(name="cgroupParent")
    def cgroup_parent(self) -> Optional[pulumi.Input[str]]:
        """
        Optional parent cgroup for the container
        """
        return pulumi.get(self, "cgroup_parent")

    @cgroup_parent.setter
    def cgroup_parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cgroup_parent", value)

    @property
    @pulumi.getter(name="cpuPeriod")
    def cpu_period(self) -> Optional[pulumi.Input[int]]:
        """
        The length of a CPU period in microseconds
        """
        return pulumi.get(self, "cpu_period")

    @cpu_period.setter
    def cpu_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_period", value)

    @property
    @pulumi.getter(name="cpuQuota")
    def cpu_quota(self) -> Optional[pulumi.Input[int]]:
        """
        Microseconds of CPU time that the container can get in a CPU period
        """
        return pulumi.get(self, "cpu_quota")

    @cpu_quota.setter
    def cpu_quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_quota", value)

    @property
    @pulumi.getter(name="cpuSetCpus")
    def cpu_set_cpus(self) -> Optional[pulumi.Input[str]]:
        """
        CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_cpus")

    @cpu_set_cpus.setter
    def cpu_set_cpus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_set_cpus", value)

    @property
    @pulumi.getter(name="cpuSetMems")
    def cpu_set_mems(self) -> Optional[pulumi.Input[str]]:
        """
        MEMs in which to allow execution (`0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_mems")

    @cpu_set_mems.setter
    def cpu_set_mems(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_set_mems", value)

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[pulumi.Input[int]]:
        """
        CPU shares (relative weight)
        """
        return pulumi.get(self, "cpu_shares")

    @cpu_shares.setter
    def cpu_shares(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_shares", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        Dockerfile file. Defaults to `Dockerfile`
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        """
        return pulumi.get(self, "extra_hosts")

    @extra_hosts.setter
    def extra_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extra_hosts", value)

    @property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[pulumi.Input[bool]]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @force_remove.setter
    def force_remove(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_remove", value)

    @property
    @pulumi.getter
    def isolation(self) -> Optional[pulumi.Input[str]]:
        """
        Isolation represents the isolation technology of a container. The supported values are
        """
        return pulumi.get(self, "isolation")

    @isolation.setter
    def isolation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isolation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        """
        Set memory limit for build
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[pulumi.Input[int]]:
        """
        Total memory (memory + swap), -1 to enable unlimited swap
        """
        return pulumi.get(self, "memory_swap")

    @memory_swap.setter
    def memory_swap(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_swap", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Set the networking mode for the RUN instructions during build
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not use the cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @no_cache.setter
    def no_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_cache", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Set platform if server is multi-platform capable
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="pullParent")
    def pull_parent(self) -> Optional[pulumi.Input[bool]]:
        """
        Attempt to pull the image even if an older image exists locally
        """
        return pulumi.get(self, "pull_parent")

    @pull_parent.setter
    def pull_parent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pull_parent", value)

    @property
    @pulumi.getter(name="remoteContext")
    def remote_context(self) -> Optional[pulumi.Input[str]]:
        """
        A Git repository URI or HTTP/HTTPS context URI
        """
        return pulumi.get(self, "remote_context")

    @remote_context.setter
    def remote_context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_context", value)

    @property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove intermediate containers after a successful build (default behavior)
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove", value)

    @property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security options
        """
        return pulumi.get(self, "security_opts")

    @security_opts.setter
    def security_opts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_opts", value)

    @property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[pulumi.Input[str]]:
        """
        Set an ID for the build session
        """
        return pulumi.get(self, "session_id")

    @session_id.setter
    def session_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_id", value)

    @property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of /dev/shm in bytes. The size must be greater than 0
        """
        return pulumi.get(self, "shm_size")

    @shm_size.setter
    def shm_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shm_size", value)

    @property
    @pulumi.getter
    def squash(self) -> Optional[pulumi.Input[bool]]:
        """
        If true the new layers are squashed into a new image with a single new layer
        """
        return pulumi.get(self, "squash")

    @squash.setter
    def squash(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "squash", value)

    @property
    @pulumi.getter(name="suppressOutput")
    def suppress_output(self) -> Optional[pulumi.Input[bool]]:
        """
        Suppress the build output and print image ID on success
        """
        return pulumi.get(self, "suppress_output")

    @suppress_output.setter
    def suppress_output(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suppress_output", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildUlimitArgs']]]]:
        """
        Configuration for ulimits
        """
        return pulumi.get(self, "ulimits")

    @ulimits.setter
    def ulimits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegistryImageBuildUlimitArgs']]]]):
        pulumi.set(self, "ulimits", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the underlying builder to use
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class RegistryImageBuildAuthConfigArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[str],
                 auth: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 identity_token: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 registry_token: Optional[pulumi.Input[str]] = None,
                 server_address: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "host_name", host_name)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if identity_token is not None:
            pulumi.set(__self__, "identity_token", identity_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if registry_token is not None:
            pulumi.set(__self__, "registry_token", registry_token)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def auth(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auth")

    @auth.setter
    def auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "identity_token")

    @identity_token.setter
    def identity_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identity_token", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="registryToken")
    def registry_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "registry_token")

    @registry_token.setter
    def registry_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_token", value)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "server_address")

    @server_address.setter
    def server_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_address", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class RegistryImageBuildUlimitArgs:
    def __init__(__self__, *,
                 hard: pulumi.Input[int],
                 name: pulumi.Input[str],
                 soft: pulumi.Input[int]):
        """
        :param pulumi.Input[str] name: The name of the Docker image.
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @property
    @pulumi.getter
    def hard(self) -> pulumi.Input[int]:
        return pulumi.get(self, "hard")

    @hard.setter
    def hard(self, value: pulumi.Input[int]):
        pulumi.set(self, "hard", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def soft(self) -> pulumi.Input[int]:
        return pulumi.get(self, "soft")

    @soft.setter
    def soft(self, value: pulumi.Input[int]):
        pulumi.set(self, "soft", value)


@pulumi.input_type
class RemoteImageBuildArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 build_arg: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 force_remove: Optional[pulumi.Input[bool]] = None,
                 label: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 no_cache: Optional[pulumi.Input[bool]] = None,
                 remove: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Context path
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_arg: Set build-time variables
        :param pulumi.Input[str] dockerfile: Name of the Dockerfile. Defaults to `Dockerfile`.
        :param pulumi.Input[bool] force_remove: Always remove intermediate containers
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] label: Set metadata for an image
        :param pulumi.Input[bool] no_cache: Do not use cache when building the image
        :param pulumi.Input[bool] remove: Remove intermediate containers after a successful build. Defaults to  `true`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Name and optionally a tag in the 'name:tag' format
        :param pulumi.Input[str] target: Set the target build stage to build
        """
        pulumi.set(__self__, "path", path)
        if build_arg is not None:
            pulumi.set(__self__, "build_arg", build_arg)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Context path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="buildArg")
    def build_arg(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set build-time variables
        """
        return pulumi.get(self, "build_arg")

    @build_arg.setter
    def build_arg(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_arg", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Dockerfile. Defaults to `Dockerfile`.
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[pulumi.Input[bool]]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @force_remove.setter
    def force_remove(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_remove", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Set metadata for an image
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not use cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @no_cache.setter
    def no_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_cache", value)

    @property
    @pulumi.getter
    def remove(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove intermediate containers after a successful build. Defaults to  `true`.
        """
        return pulumi.get(self, "remove")

    @remove.setter
    def remove(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Name and optionally a tag in the 'name:tag' format
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class SecretLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceAuthArgs:
    def __init__(__self__, *,
                 server_address: pulumi.Input[str],
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] server_address: The address of the server for the authentication
        :param pulumi.Input[str] password: The password
        :param pulumi.Input[str] username: The username
        """
        pulumi.set(__self__, "server_address", server_address)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> pulumi.Input[str]:
        """
        The address of the server for the authentication
        """
        return pulumi.get(self, "server_address")

    @server_address.setter
    def server_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_address", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class ServiceConvergeConfigArgs:
    def __init__(__self__, *,
                 delay: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] delay: The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        :param pulumi.Input[str] timeout: The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        """
        The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ServiceEndpointSpecArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointSpecPortArgs']]]] = None):
        """
        :param pulumi.Input[str] mode: The mode of resolution to use for internal load balancing between tasks
        :param pulumi.Input[Sequence[pulumi.Input['ServiceEndpointSpecPortArgs']]] ports: List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of resolution to use for internal load balancing between tasks
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointSpecPortArgs']]]]:
        """
        List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceEndpointSpecPortArgs']]]]):
        pulumi.set(self, "ports", value)


@pulumi.input_type
class ServiceEndpointSpecPortArgs:
    def __init__(__self__, *,
                 target_port: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 publish_mode: Optional[pulumi.Input[str]] = None,
                 published_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] name: Name of the service
        """
        pulumi.set(__self__, "target_port", target_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if publish_mode is not None:
            pulumi.set(__self__, "publish_mode", publish_mode)
        if published_port is not None:
            pulumi.set(__self__, "published_port", published_port)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "target_port")

    @target_port.setter
    def target_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "target_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publishMode")
    def publish_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "publish_mode")

    @publish_mode.setter
    def publish_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publish_mode", value)

    @property
    @pulumi.getter(name="publishedPort")
    def published_port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "published_port")

    @published_port.setter
    def published_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "published_port", value)


@pulumi.input_type
class ServiceLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceModeArgs:
    def __init__(__self__, *,
                 global_: Optional[pulumi.Input[bool]] = None,
                 replicated: Optional[pulumi.Input['ServiceModeReplicatedArgs']] = None):
        """
        :param pulumi.Input[bool] global_: The global service mode. Defaults to `false`
        :param pulumi.Input['ServiceModeReplicatedArgs'] replicated: The replicated service mode
        """
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if replicated is not None:
            pulumi.set(__self__, "replicated", replicated)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input[bool]]:
        """
        The global service mode. Defaults to `false`
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "global_", value)

    @property
    @pulumi.getter
    def replicated(self) -> Optional[pulumi.Input['ServiceModeReplicatedArgs']]:
        """
        The replicated service mode
        """
        return pulumi.get(self, "replicated")

    @replicated.setter
    def replicated(self, value: Optional[pulumi.Input['ServiceModeReplicatedArgs']]):
        pulumi.set(self, "replicated", value)


@pulumi.input_type
class ServiceModeReplicatedArgs:
    def __init__(__self__, *,
                 replicas: Optional[pulumi.Input[int]] = None):
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)


@pulumi.input_type
class ServiceRollbackConfigArgs:
    def __init__(__self__, *,
                 delay: Optional[pulumi.Input[str]] = None,
                 failure_action: Optional[pulumi.Input[str]] = None,
                 max_failure_ratio: Optional[pulumi.Input[str]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 order: Optional[pulumi.Input[str]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] delay: Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        :param pulumi.Input[str] failure_action: Action on rollback failure: pause | continue. Defaults to `pause`.
        :param pulumi.Input[str] max_failure_ratio: Failure rate to tolerate during a rollback. Defaults to `0.0`.
        :param pulumi.Input[str] monitor: Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param pulumi.Input[str] order: Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param pulumi.Input[int] parallelism: Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        """
        Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action on rollback failure: pause | continue. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @failure_action.setter
    def failure_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_action", value)

    @property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        Failure rate to tolerate during a rollback. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @max_failure_ratio.setter
    def max_failure_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_failure_ratio", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[str]]:
        """
        Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)


@pulumi.input_type
class ServiceTaskSpecArgs:
    def __init__(__self__, *,
                 container_spec: pulumi.Input['ServiceTaskSpecContainerSpecArgs'],
                 force_update: Optional[pulumi.Input[int]] = None,
                 log_driver: Optional[pulumi.Input['ServiceTaskSpecLogDriverArgs']] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement: Optional[pulumi.Input['ServiceTaskSpecPlacementArgs']] = None,
                 resources: Optional[pulumi.Input['ServiceTaskSpecResourcesArgs']] = None,
                 restart_policy: Optional[pulumi.Input['ServiceTaskSpecRestartPolicyArgs']] = None,
                 runtime: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ServiceTaskSpecContainerSpecArgs'] container_spec: The spec for each container
        :param pulumi.Input[int] force_update: A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        :param pulumi.Input['ServiceTaskSpecLogDriverArgs'] log_driver: Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        :param pulumi.Input[Sequence[pulumi.Input[str]]] networks: Ids of the networks in which the  container will be put in
        :param pulumi.Input['ServiceTaskSpecPlacementArgs'] placement: The placement preferences
        :param pulumi.Input['ServiceTaskSpecResourcesArgs'] resources: Resource requirements which apply to each individual container created as part of the service
        :param pulumi.Input['ServiceTaskSpecRestartPolicyArgs'] restart_policy: Specification for the restart policy which applies to containers created as part of this service.
        :param pulumi.Input[str] runtime: Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        pulumi.set(__self__, "container_spec", container_spec)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @property
    @pulumi.getter(name="containerSpec")
    def container_spec(self) -> pulumi.Input['ServiceTaskSpecContainerSpecArgs']:
        """
        The spec for each container
        """
        return pulumi.get(self, "container_spec")

    @container_spec.setter
    def container_spec(self, value: pulumi.Input['ServiceTaskSpecContainerSpecArgs']):
        pulumi.set(self, "container_spec", value)

    @property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[int]]:
        """
        A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "force_update", value)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional[pulumi.Input['ServiceTaskSpecLogDriverArgs']]:
        """
        Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        """
        return pulumi.get(self, "log_driver")

    @log_driver.setter
    def log_driver(self, value: Optional[pulumi.Input['ServiceTaskSpecLogDriverArgs']]):
        pulumi.set(self, "log_driver", value)

    @property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Ids of the networks in which the  container will be put in
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "networks", value)

    @property
    @pulumi.getter
    def placement(self) -> Optional[pulumi.Input['ServiceTaskSpecPlacementArgs']]:
        """
        The placement preferences
        """
        return pulumi.get(self, "placement")

    @placement.setter
    def placement(self, value: Optional[pulumi.Input['ServiceTaskSpecPlacementArgs']]):
        pulumi.set(self, "placement", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ServiceTaskSpecResourcesArgs']]:
        """
        Resource requirements which apply to each individual container created as part of the service
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ServiceTaskSpecResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input['ServiceTaskSpecRestartPolicyArgs']]:
        """
        Specification for the restart policy which applies to containers created as part of this service.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input['ServiceTaskSpecRestartPolicyArgs']]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecConfigArgs']]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 dns_config: Optional[pulumi.Input['ServiceTaskSpecContainerSpecDnsConfigArgs']] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 healthcheck: Optional[pulumi.Input['ServiceTaskSpecContainerSpecHealthcheckArgs']] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecHostArgs']]]] = None,
                 isolation: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecLabelArgs']]]] = None,
                 mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountArgs']]]] = None,
                 privileges: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecSecretArgs']]]] = None,
                 stop_grace_period: Optional[pulumi.Input[str]] = None,
                 stop_signal: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecLabelArgs']]] labels: User-defined key/value metadata
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if stop_grace_period is not None:
            pulumi.set(__self__, "stop_grace_period", stop_grace_period)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecConfigArgs']]]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecDnsConfigArgs']]:
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecHealthcheckArgs']]:
        return pulumi.get(self, "healthcheck")

    @healthcheck.setter
    def healthcheck(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecHealthcheckArgs']]):
        pulumi.set(self, "healthcheck", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecHostArgs']]]]:
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def isolation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "isolation")

    @isolation.setter
    def isolation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isolation", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecLabelArgs']]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountArgs']]]]:
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountArgs']]]]):
        pulumi.set(self, "mounts", value)

    @property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesArgs']]:
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesArgs']]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecSecretArgs']]]]:
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="stopGracePeriod")
    def stop_grace_period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stop_grace_period")

    @stop_grace_period.setter
    def stop_grace_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_grace_period", value)

    @property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "stop_signal")

    @stop_signal.setter
    def stop_signal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_signal", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecConfigArgs:
    def __init__(__self__, *,
                 config_id: pulumi.Input[str],
                 file_name: pulumi.Input[str],
                 config_name: Optional[pulumi.Input[str]] = None,
                 file_gid: Optional[pulumi.Input[str]] = None,
                 file_mode: Optional[pulumi.Input[int]] = None,
                 file_uid: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "file_name", file_name)
        if config_name is not None:
            pulumi.set(__self__, "config_name", config_name)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)

    @property
    @pulumi.getter(name="configId")
    def config_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "config_id")

    @config_id.setter
    def config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_id", value)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="configName")
    def config_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_name")

    @config_name.setter
    def config_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_name", value)

    @property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_gid")

    @file_gid.setter
    def file_gid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_gid", value)

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "file_mode")

    @file_mode.setter
    def file_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_mode", value)

    @property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_uid")

    @file_uid.setter
    def file_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_uid", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecDnsConfigArgs:
    def __init__(__self__, *,
                 nameservers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 searches: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "nameservers")

    @nameservers.setter
    def nameservers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "nameservers", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def searches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "searches")

    @searches.setter
    def searches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "searches", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecHealthcheckArgs:
    def __init__(__self__, *,
                 tests: pulumi.Input[Sequence[pulumi.Input[str]]],
                 interval: Optional[pulumi.Input[str]] = None,
                 retries: Optional[pulumi.Input[int]] = None,
                 start_period: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def tests(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tests", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def retries(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retries")

    @retries.setter
    def retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retries", value)

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "start_period")

    @start_period.setter
    def start_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_period", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecHostArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[str],
                 ip: pulumi.Input[str]):
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[str]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecMountArgs:
    def __init__(__self__, *,
                 target: pulumi.Input[str],
                 type: pulumi.Input[str],
                 bind_options: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountBindOptionsArgs']] = None,
                 read_only: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tmpfs_options: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs']] = None,
                 volume_options: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsArgs']] = None):
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountBindOptionsArgs']]:
        return pulumi.get(self, "bind_options")

    @bind_options.setter
    def bind_options(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountBindOptionsArgs']]):
        pulumi.set(self, "bind_options", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs']]:
        return pulumi.get(self, "tmpfs_options")

    @tmpfs_options.setter
    def tmpfs_options(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs']]):
        pulumi.set(self, "tmpfs_options", value)

    @property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsArgs']]:
        return pulumi.get(self, "volume_options")

    @volume_options.setter
    def volume_options(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsArgs']]):
        pulumi.set(self, "volume_options", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecMountBindOptionsArgs:
    def __init__(__self__, *,
                 propagation: Optional[pulumi.Input[str]] = None):
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @property
    @pulumi.getter
    def propagation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "propagation")

    @propagation.setter
    def propagation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "propagation", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[int]] = None,
                 size_bytes: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] mode: Scheduling mode for the service
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[int]]:
        """
        Scheduling mode for the service
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "size_bytes")

    @size_bytes.setter
    def size_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size_bytes", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecMountVolumeOptionsArgs:
    def __init__(__self__, *,
                 driver_name: Optional[pulumi.Input[str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs']]]] = None,
                 no_copy: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs']]] labels: User-defined key/value metadata
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)

    @property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "driver_name")

    @driver_name.setter
    def driver_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "driver_name", value)

    @property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "driver_options")

    @driver_options.setter
    def driver_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "driver_options", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs']]]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "no_copy")

    @no_copy.setter
    def no_copy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_copy", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecPrivilegesArgs:
    def __init__(__self__, *,
                 credential_spec: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs']] = None,
                 se_linux_context: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs']] = None):
        if credential_spec is not None:
            pulumi.set(__self__, "credential_spec", credential_spec)
        if se_linux_context is not None:
            pulumi.set(__self__, "se_linux_context", se_linux_context)

    @property
    @pulumi.getter(name="credentialSpec")
    def credential_spec(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs']]:
        return pulumi.get(self, "credential_spec")

    @credential_spec.setter
    def credential_spec(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs']]):
        pulumi.set(self, "credential_spec", value)

    @property
    @pulumi.getter(name="seLinuxContext")
    def se_linux_context(self) -> Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs']]:
        return pulumi.get(self, "se_linux_context")

    @se_linux_context.setter
    def se_linux_context(self, value: Optional[pulumi.Input['ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs']]):
        pulumi.set(self, "se_linux_context", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs:
    def __init__(__self__, *,
                 file: Optional[pulumi.Input[str]] = None,
                 registry: Optional[pulumi.Input[str]] = None):
        if file is not None:
            pulumi.set(__self__, "file", file)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)

    @property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file", value)

    @property
    @pulumi.getter
    def registry(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "registry")

    @registry.setter
    def registry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs:
    def __init__(__self__, *,
                 disable: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def disable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "disable")

    @disable.setter
    def disable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class ServiceTaskSpecContainerSpecSecretArgs:
    def __init__(__self__, *,
                 file_name: pulumi.Input[str],
                 secret_id: pulumi.Input[str],
                 file_gid: Optional[pulumi.Input[str]] = None,
                 file_mode: Optional[pulumi.Input[int]] = None,
                 file_uid: Optional[pulumi.Input[str]] = None,
                 secret_name: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "secret_id", secret_id)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "file_name", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_gid")

    @file_gid.setter
    def file_gid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_gid", value)

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "file_mode")

    @file_mode.setter
    def file_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_mode", value)

    @property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "file_uid")

    @file_uid.setter
    def file_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_uid", value)

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_name", value)


@pulumi.input_type
class ServiceTaskSpecLogDriverArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: Name of the service
        """
        pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the service
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class ServiceTaskSpecPlacementArgs:
    def __init__(__self__, *,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_replicas: Optional[pulumi.Input[int]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecPlacementPlatformArgs']]]] = None,
                 prefs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if prefs is not None:
            pulumi.set(__self__, "prefs", prefs)

    @property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "constraints", value)

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_replicas")

    @max_replicas.setter
    def max_replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_replicas", value)

    @property
    @pulumi.getter
    def platforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecPlacementPlatformArgs']]]]:
        return pulumi.get(self, "platforms")

    @platforms.setter
    def platforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTaskSpecPlacementPlatformArgs']]]]):
        pulumi.set(self, "platforms", value)

    @property
    @pulumi.getter
    def prefs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "prefs")

    @prefs.setter
    def prefs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prefs", value)


@pulumi.input_type
class ServiceTaskSpecPlacementPlatformArgs:
    def __init__(__self__, *,
                 architecture: pulumi.Input[str],
                 os: pulumi.Input[str]):
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "os", os)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Input[str]:
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: pulumi.Input[str]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def os(self) -> pulumi.Input[str]:
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: pulumi.Input[str]):
        pulumi.set(self, "os", value)


@pulumi.input_type
class ServiceTaskSpecResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input['ServiceTaskSpecResourcesLimitsArgs']] = None,
                 reservation: Optional[pulumi.Input['ServiceTaskSpecResourcesReservationArgs']] = None):
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if reservation is not None:
            pulumi.set(__self__, "reservation", reservation)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input['ServiceTaskSpecResourcesLimitsArgs']]:
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input['ServiceTaskSpecResourcesLimitsArgs']]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def reservation(self) -> Optional[pulumi.Input['ServiceTaskSpecResourcesReservationArgs']]:
        return pulumi.get(self, "reservation")

    @reservation.setter
    def reservation(self, value: Optional[pulumi.Input['ServiceTaskSpecResourcesReservationArgs']]):
        pulumi.set(self, "reservation", value)


@pulumi.input_type
class ServiceTaskSpecResourcesLimitsArgs:
    def __init__(__self__, *,
                 memory_bytes: Optional[pulumi.Input[int]] = None,
                 nano_cpus: Optional[pulumi.Input[int]] = None):
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "memory_bytes")

    @memory_bytes.setter
    def memory_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_bytes", value)

    @property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "nano_cpus")

    @nano_cpus.setter
    def nano_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nano_cpus", value)


@pulumi.input_type
class ServiceTaskSpecResourcesReservationArgs:
    def __init__(__self__, *,
                 generic_resources: Optional[pulumi.Input['ServiceTaskSpecResourcesReservationGenericResourcesArgs']] = None,
                 memory_bytes: Optional[pulumi.Input[int]] = None,
                 nano_cpus: Optional[pulumi.Input[int]] = None):
        if generic_resources is not None:
            pulumi.set(__self__, "generic_resources", generic_resources)
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @property
    @pulumi.getter(name="genericResources")
    def generic_resources(self) -> Optional[pulumi.Input['ServiceTaskSpecResourcesReservationGenericResourcesArgs']]:
        return pulumi.get(self, "generic_resources")

    @generic_resources.setter
    def generic_resources(self, value: Optional[pulumi.Input['ServiceTaskSpecResourcesReservationGenericResourcesArgs']]):
        pulumi.set(self, "generic_resources", value)

    @property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "memory_bytes")

    @memory_bytes.setter
    def memory_bytes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_bytes", value)

    @property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "nano_cpus")

    @nano_cpus.setter
    def nano_cpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nano_cpus", value)


@pulumi.input_type
class ServiceTaskSpecResourcesReservationGenericResourcesArgs:
    def __init__(__self__, *,
                 discrete_resources_specs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 named_resources_specs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if discrete_resources_specs is not None:
            pulumi.set(__self__, "discrete_resources_specs", discrete_resources_specs)
        if named_resources_specs is not None:
            pulumi.set(__self__, "named_resources_specs", named_resources_specs)

    @property
    @pulumi.getter(name="discreteResourcesSpecs")
    def discrete_resources_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "discrete_resources_specs")

    @discrete_resources_specs.setter
    def discrete_resources_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "discrete_resources_specs", value)

    @property
    @pulumi.getter(name="namedResourcesSpecs")
    def named_resources_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "named_resources_specs")

    @named_resources_specs.setter
    def named_resources_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "named_resources_specs", value)


@pulumi.input_type
class ServiceTaskSpecRestartPolicyArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[str]] = None,
                 delay: Optional[pulumi.Input[str]] = None,
                 max_attempts: Optional[pulumi.Input[int]] = None,
                 window: Optional[pulumi.Input[str]] = None):
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_attempts", value)

    @property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class ServiceUpdateConfigArgs:
    def __init__(__self__, *,
                 delay: Optional[pulumi.Input[str]] = None,
                 failure_action: Optional[pulumi.Input[str]] = None,
                 max_failure_ratio: Optional[pulumi.Input[str]] = None,
                 monitor: Optional[pulumi.Input[str]] = None,
                 order: Optional[pulumi.Input[str]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] delay: Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        :param pulumi.Input[str] failure_action: Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        :param pulumi.Input[str] max_failure_ratio: Failure rate to tolerate during an update. Defaults to `0.0`.
        :param pulumi.Input[str] monitor: Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param pulumi.Input[str] order: Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param pulumi.Input[int] parallelism: Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[str]]:
        """
        Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @failure_action.setter
    def failure_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_action", value)

    @property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        Failure rate to tolerate during an update. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @max_failure_ratio.setter
    def max_failure_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_failure_ratio", value)

    @property
    @pulumi.getter
    def monitor(self) -> Optional[pulumi.Input[str]]:
        """
        Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @monitor.setter
    def monitor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[str]]:
        """
        Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)


@pulumi.input_type
class VolumeLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] label: Name of the label
        :param pulumi.Input[str] value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class CacheFromArgs:
    def __init__(__self__, *,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies information about where to obtain a cache
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stages: A list of cached build stages
        """
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of cached build stages
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "stages", value)


@pulumi.input_type
class DockerBuildArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 builder_version: Optional[pulumi.Input['BuilderVersion']] = None,
                 cache_from: Optional[pulumi.Input[Union[bool, 'CacheFromArgs']]] = None,
                 context: Optional[pulumi.Input[str]] = None,
                 dockerfile: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 extra_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        The Docker build context
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] args: An optional map of named build-time argument variables to set during the Docker build. This flag allows you to pass built-time variablesthat can be accessed like environment variables inside the RUN instruction.
        :param pulumi.Input['BuilderVersion'] builder_version: The version of the Docker builder. 
        :param pulumi.Input[Union[bool, 'CacheFromArgs']] cache_from: A cached image or list of build stages to use as build cache
        :param pulumi.Input[str] context: The path to the build context to use.
        :param pulumi.Input[str] dockerfile: The path to the Dockerfile to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env: Environment variables to set on the invocation of docker build, for example to support DOCKER_BUILDKIT=1 docker build.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extra_options: A bag of extra options to pass on to the docker SDK.
        :param pulumi.Input[str] target: The target of the Dockerfile to build
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if builder_version is None:
            builder_version = 'BuilderBuildKit'
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if cache_from is not None:
            pulumi.set(__self__, "cache_from", cache_from)
        if context is None:
            context = '.'
        if context is not None:
            pulumi.set(__self__, "context", context)
        if dockerfile is None:
            dockerfile = 'Dockerfile'
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if extra_options is not None:
            pulumi.set(__self__, "extra_options", extra_options)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        An optional map of named build-time argument variables to set during the Docker build. This flag allows you to pass built-time variablesthat can be accessed like environment variables inside the RUN instruction.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input['BuilderVersion']]:
        """
        The version of the Docker builder. 
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input['BuilderVersion']]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter(name="cacheFrom")
    def cache_from(self) -> Optional[pulumi.Input[Union[bool, 'CacheFromArgs']]]:
        """
        A cached image or list of build stages to use as build cache
        """
        return pulumi.get(self, "cache_from")

    @cache_from.setter
    def cache_from(self, value: Optional[pulumi.Input[Union[bool, 'CacheFromArgs']]]):
        pulumi.set(self, "cache_from", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the build context to use.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter
    def dockerfile(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the Dockerfile to use.
        """
        return pulumi.get(self, "dockerfile")

    @dockerfile.setter
    def dockerfile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dockerfile", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables to set on the invocation of docker build, for example to support DOCKER_BUILDKIT=1 docker build.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="extraOptions")
    def extra_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A bag of extra options to pass on to the docker SDK.
        """
        return pulumi.get(self, "extra_options")

    @extra_options.setter
    def extra_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extra_options", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The target of the Dockerfile to build
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class RegistryArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 server: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        Describes a Docker container registry
        :param pulumi.Input[str] password: The password to authenticate to the registry
        :param pulumi.Input[str] server: The URL of the Docker registry server
        :param pulumi.Input[str] username: The username to authenticate to the registry
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "server", server)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password to authenticate to the registry
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> pulumi.Input[str]:
        """
        The URL of the Docker registry server
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: pulumi.Input[str]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username to authenticate to the registry
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


