# DipDup

[![PyPI version](https://badge.fury.io/py/dipdup.svg?)](https://badge.fury.io/py/dipdup)
[![Tests](https://github.com/dipdup-net/dipdup-py/workflows/Tests/badge.svg?)](https://github.com/baking-bad/dipdup/actions?query=workflow%3ATests)
[![Made With](https://img.shields.io/badge/made%20with-python-blue.svg?)](ttps://www.python.org)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

Python SDK for developing indexers of [Tezos](https://tezos.com/) smart contracts inspired by [The Graph](https://thegraph.com/).

## Quickstart

Python 3.8+ is required for dipdup to run.

```shell
$ pip install dipdup
```

* Read the rest of the tutorial: [docs.dipdup.net](https://docs.dipdup.net/)  
* Check out [demo projects](https://github.com/dipdup-net/dipdup-py/tree/master/src)

## Contribution

To set up development environment you need to install [poetry](https://python-poetry.org/docs/#installation) package manager and GNU Make. Then run one of the following commands at project's root:

```shell
$ # install project dependencies
$ make install
$ # run linters
$ make lint
$ # run tests
$ make test cover
$ # run full CI pipeline
$ make
```

## Contact
* Telegram chat: [@baking_bad_chat](https://t.me/baking_bad_chat)
* Slack channel: [#baking-bad](https://tezos-dev.slack.com/archives/CV5NX7F2L)
* Discord group: [Baking Bad](https://discord.gg/JZKhv7uW)

## About
This project is maintained by [Baking Bad](https://baking-bad.org/) team.  
Development is supported by [Tezos Foundation](https://tezos.foundation/).
