"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Connection endpoint of a neptune cluster or instance
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = aws_cdk_lib_1.Token.isUnresolved(port) ? aws_cdk_lib_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
exports.Endpoint = Endpoint;
_a = JSII_RTTI_SYMBOL_1;
Endpoint[_a] = { fqn: "@aws-cdk/aws-neptune-alpha.Endpoint", version: "2.24.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFvQztBQUVwQzs7OztHQUlHO0FBQ0gsTUFBYSxRQUFRO0lBZ0JuQixZQUFZLE9BQWUsRUFBRSxJQUFZO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBRWpCLE1BQU0sUUFBUSxHQUFHLG1CQUFLLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxtQkFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ3hFLElBQUksQ0FBQyxhQUFhLEdBQUcsR0FBRyxPQUFPLElBQUksUUFBUSxFQUFFLENBQUM7S0FDL0M7O0FBdEJILDRCQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWInO1xuXG4vKipcbiAqIENvbm5lY3Rpb24gZW5kcG9pbnQgb2YgYSBuZXB0dW5lIGNsdXN0ZXIgb3IgaW5zdGFuY2VcbiAqXG4gKiBDb25zaXN0cyBvZiBhIGNvbWJpbmF0aW9uIG9mIGhvc3RuYW1lIGFuZCBwb3J0LlxuICovXG5leHBvcnQgY2xhc3MgRW5kcG9pbnQge1xuICAvKipcbiAgICogVGhlIGhvc3RuYW1lIG9mIHRoZSBlbmRwb2ludFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGhvc3RuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwb3J0IG9mIHRoZSBlbmRwb2ludFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIGNvbWJpbmF0aW9uIG9mIFwiSE9TVE5BTUU6UE9SVFwiIGZvciB0aGlzIGVuZHBvaW50XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc29ja2V0QWRkcmVzczogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKGFkZHJlc3M6IHN0cmluZywgcG9ydDogbnVtYmVyKSB7XG4gICAgdGhpcy5ob3N0bmFtZSA9IGFkZHJlc3M7XG4gICAgdGhpcy5wb3J0ID0gcG9ydDtcblxuICAgIGNvbnN0IHBvcnREZXNjID0gVG9rZW4uaXNVbnJlc29sdmVkKHBvcnQpID8gVG9rZW4uYXNTdHJpbmcocG9ydCkgOiBwb3J0O1xuICAgIHRoaXMuc29ja2V0QWRkcmVzcyA9IGAke2FkZHJlc3N9OiR7cG9ydERlc2N9YDtcbiAgfVxufVxuIl19