import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IDatabaseCluster } from './cluster';
import { Endpoint } from './endpoint';
import { IParameterGroup } from './parameter-group';
/**
 * Possible Instances Types to use in Neptune cluster
 * used for defining {@link DatabaseInstanceProps.instanceType}.
 */
export declare class InstanceType {
    /**
     * db.r6g.large
     */
    static readonly R6G_LARGE: InstanceType;
    /**
     * db.r6g.xlarge
     */
    static readonly R6G_XLARGE: InstanceType;
    /**
     * db.r6g.2xlarge
     */
    static readonly R6G_2XLARGE: InstanceType;
    /**
     * db.r6g.4xlarge
     */
    static readonly R6G_4XLARGE: InstanceType;
    /**
     * db.r6g.8xlarge
     */
    static readonly R6G_8XLARGE: InstanceType;
    /**
    * db.r6g.12xlarge
    */
    static readonly R6G_12XLARGE: InstanceType;
    /**
     * db.r6g.16xlarge
     */
    static readonly R6G_16XLARGE: InstanceType;
    /**
     * db.t4g.medium
     */
    static readonly T4G_MEDIUM: InstanceType;
    /**
     * db.r5.large
     */
    static readonly R5_LARGE: InstanceType;
    /**
     * db.r5.xlarge
     */
    static readonly R5_XLARGE: InstanceType;
    /**
     * db.r5.2xlarge
     */
    static readonly R5_2XLARGE: InstanceType;
    /**
     * db.r5.4xlarge
     */
    static readonly R5_4XLARGE: InstanceType;
    /**
     * db.r5.8xlarge
     */
    static readonly R5_8XLARGE: InstanceType;
    /**
     * db.r5.12xlarge
     */
    static readonly R5_12XLARGE: InstanceType;
    /**
     * db.r5.24xlarge
     */
    static readonly R5_24XLARGE: InstanceType;
    /**
     * db.r4.large
     */
    static readonly R4_LARGE: InstanceType;
    /**
     * db.r4.xlarge
     */
    static readonly R4_XLARGE: InstanceType;
    /**
     * db.r4.2xlarge
     */
    static readonly R4_2XLARGE: InstanceType;
    /**
     * db.r4.4xlarge
     */
    static readonly R4_4XLARGE: InstanceType;
    /**
     * db.r4.8xlarge
     */
    static readonly R4_8XLARGE: InstanceType;
    /**
     * db.t3.medium
     */
    static readonly T3_MEDIUM: InstanceType;
    /**
     * Build an InstanceType from given string or token, such as CfnParameter.
     */
    static of(instanceType: string): InstanceType;
    /**
     * @internal
     */
    readonly _instanceType: string;
    private constructor();
}
/**
 * A database instance
 */
export interface IDatabaseInstance extends cdk.IResource {
    /**
     * The instance identifier.
     */
    readonly instanceIdentifier: string;
    /**
     * The instance endpoint.
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * The instance endpoint address.
     *
     * @attribute Endpoint
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * The instance endpoint port.
     *
     * @attribute Port
     */
    readonly dbInstanceEndpointPort: string;
}
/**
 * Properties that describe an existing instance
 */
export interface DatabaseInstanceAttributes {
    /**
     * The instance identifier.
     */
    readonly instanceIdentifier: string;
    /**
     * The endpoint address.
     */
    readonly instanceEndpointAddress: string;
    /**
     * The database port.
     */
    readonly port: number;
}
/**
 * Construction properties for a DatabaseInstanceNew
 */
export interface DatabaseInstanceProps {
    /**
     * The Neptune database cluster the instance should launch into.
     */
    readonly cluster: IDatabaseCluster;
    /**
     * What type of instance to start for the replicas
     */
    readonly instanceType: InstanceType;
    /**
     * The name of the Availability Zone where the DB instance will be located.
     *
     * @default - no preference
     */
    readonly availabilityZone?: string;
    /**
     * A name for the DB instance. If you specify a name, AWS CloudFormation
     * converts it to lowercase.
     *
     * @default - a CloudFormation generated name
     */
    readonly dbInstanceName?: string;
    /**
     * The DB parameter group to associate with the instance.
     *
     * @default no parameter group
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * The CloudFormation policy to apply when the instance is removed from the
     * stack or replaced during an update.
     *
     * @default RemovalPolicy.Retain
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * A database instance
 *
 * @resource AWS::Neptune::DBInstance
 */
export declare class DatabaseInstance extends cdk.Resource implements IDatabaseInstance {
    /**
     * Import an existing database instance.
     */
    static fromDatabaseInstanceAttributes(scope: Construct, id: string, attrs: DatabaseInstanceAttributes): IDatabaseInstance;
    /**
     * The instance's database cluster
     */
    readonly cluster: IDatabaseCluster;
    /**
     * @inheritdoc
     */
    readonly instanceIdentifier: string;
    /**
     * @inheritdoc
     */
    readonly instanceEndpoint: Endpoint;
    /**
     * @inheritdoc
     */
    readonly dbInstanceEndpointAddress: string;
    /**
     * @inheritdoc
     */
    readonly dbInstanceEndpointPort: string;
    constructor(scope: Construct, id: string, props: DatabaseInstanceProps);
}
