<a id="mypy-boto3-budgets"></a>

# mypy-boto3-budgets

[![PyPI - mypy-boto3-budgets](https://img.shields.io/pypi/v/mypy-boto3-budgets.svg?color=blue)](https://pypi.org/project/mypy-boto3-budgets)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-budgets.svg?color=blue)](https://pypi.org/project/mypy-boto3-budgets)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-budgets?color=blue)](https://pypistats.org/packages/mypy-boto3-budgets)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Budgets 1.19.10](https://boto3.amazonaws.com/v1/documentation/api/1.19.10/reference/services/budgets.html#Budgets)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.1.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-budgets docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_budgets/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-budgets](#mypy-boto3-budgets)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Budgets` service.

```bash
python -m pip install boto3-stubs[budgets]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[budgets]` in your environment:
  `python -m pip install 'boto3-stubs[budgets]'`

Both type checking and auto-complete should work for `Budgets` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[budgets]` in your environment:
  `python -m pip install 'boto3-stubs[budgets]'`

Both type checking and auto-complete should work for `Budgets` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[budgets]` in your environment:
  `python -m pip install 'boto3-stubs[budgets]'`
- Run `mypy` as usual

Type checking should work for `Budgets` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[budgets]` in your environment:
  `python -m pip install 'boto3-stubs[budgets]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Budgets` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`BudgetsClient` provides annotations for `boto3.client("budgets")`.

```python
import boto3

from mypy_boto3_budgets import BudgetsClient

client: BudgetsClient = boto3.client("budgets")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: BudgetsClient = session.client("budgets")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_budgets.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_budgets import BudgetsClient
from mypy_boto3_budgets.paginator import (
    DescribeBudgetActionHistoriesPaginator,
    DescribeBudgetActionsForAccountPaginator,
    DescribeBudgetActionsForBudgetPaginator,
    DescribeBudgetPerformanceHistoryPaginator,
    DescribeBudgetsPaginator,
    DescribeNotificationsForBudgetPaginator,
    DescribeSubscribersForNotificationPaginator,
)

client: BudgetsClient = boto3.client("budgets")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_budget_action_histories_paginator: DescribeBudgetActionHistoriesPaginator = client.get_paginator("describe_budget_action_histories")
describe_budget_actions_for_account_paginator: DescribeBudgetActionsForAccountPaginator = client.get_paginator("describe_budget_actions_for_account")
describe_budget_actions_for_budget_paginator: DescribeBudgetActionsForBudgetPaginator = client.get_paginator("describe_budget_actions_for_budget")
describe_budget_performance_history_paginator: DescribeBudgetPerformanceHistoryPaginator = client.get_paginator("describe_budget_performance_history")
describe_budgets_paginator: DescribeBudgetsPaginator = client.get_paginator("describe_budgets")
describe_notifications_for_budget_paginator: DescribeNotificationsForBudgetPaginator = client.get_paginator("describe_notifications_for_budget")
describe_subscribers_for_notification_paginator: DescribeSubscribersForNotificationPaginator = client.get_paginator("describe_subscribers_for_notification")
```

<a id="literals"></a>

### Literals

`mypy_boto3_budgets.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_budgets.literals import (
    ActionStatusType,
    ActionSubTypeType,
    ActionTypeType,
    ApprovalModelType,
    BudgetTypeType,
    ComparisonOperatorType,
    DescribeBudgetActionHistoriesPaginatorName,
    DescribeBudgetActionsForAccountPaginatorName,
    DescribeBudgetActionsForBudgetPaginatorName,
    DescribeBudgetPerformanceHistoryPaginatorName,
    DescribeBudgetsPaginatorName,
    DescribeNotificationsForBudgetPaginatorName,
    DescribeSubscribersForNotificationPaginatorName,
    EventTypeType,
    ExecutionTypeType,
    NotificationStateType,
    NotificationTypeType,
    SubscriptionTypeType,
    ThresholdTypeType,
    TimeUnitType,
    ServiceName,
    PaginatorName,
)

def check_value(value: ActionStatusType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_budgets.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_budgets.type_defs import (
    ActionHistoryDetailsTypeDef,
    ActionHistoryTypeDef,
    ActionThresholdTypeDef,
    ActionTypeDef,
    BudgetPerformanceHistoryTypeDef,
    BudgetTypeDef,
    BudgetedAndActualAmountsTypeDef,
    CalculatedSpendTypeDef,
    CostTypesTypeDef,
    CreateBudgetActionRequestRequestTypeDef,
    CreateBudgetActionResponseTypeDef,
    CreateBudgetRequestRequestTypeDef,
    CreateNotificationRequestRequestTypeDef,
    CreateSubscriberRequestRequestTypeDef,
    DefinitionTypeDef,
    DeleteBudgetActionRequestRequestTypeDef,
    DeleteBudgetActionResponseTypeDef,
    DeleteBudgetRequestRequestTypeDef,
    DeleteNotificationRequestRequestTypeDef,
    DeleteSubscriberRequestRequestTypeDef,
    DescribeBudgetActionHistoriesRequestRequestTypeDef,
    DescribeBudgetActionHistoriesResponseTypeDef,
    DescribeBudgetActionRequestRequestTypeDef,
    DescribeBudgetActionResponseTypeDef,
    DescribeBudgetActionsForAccountRequestRequestTypeDef,
    DescribeBudgetActionsForAccountResponseTypeDef,
    DescribeBudgetActionsForBudgetRequestRequestTypeDef,
    DescribeBudgetActionsForBudgetResponseTypeDef,
    DescribeBudgetPerformanceHistoryRequestRequestTypeDef,
    DescribeBudgetPerformanceHistoryResponseTypeDef,
    DescribeBudgetRequestRequestTypeDef,
    DescribeBudgetResponseTypeDef,
    DescribeBudgetsRequestRequestTypeDef,
    DescribeBudgetsResponseTypeDef,
    DescribeNotificationsForBudgetRequestRequestTypeDef,
    DescribeNotificationsForBudgetResponseTypeDef,
    DescribeSubscribersForNotificationRequestRequestTypeDef,
    DescribeSubscribersForNotificationResponseTypeDef,
    ExecuteBudgetActionRequestRequestTypeDef,
    ExecuteBudgetActionResponseTypeDef,
    IamActionDefinitionTypeDef,
    NotificationTypeDef,
    NotificationWithSubscribersTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    ScpActionDefinitionTypeDef,
    SpendTypeDef,
    SsmActionDefinitionTypeDef,
    SubscriberTypeDef,
    TimePeriodTypeDef,
    UpdateBudgetActionRequestRequestTypeDef,
    UpdateBudgetActionResponseTypeDef,
    UpdateBudgetRequestRequestTypeDef,
    UpdateNotificationRequestRequestTypeDef,
    UpdateSubscriberRequestRequestTypeDef,
)

def get_structure() -> ActionHistoryDetailsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-budgets` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-budgets docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_budgets/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
