import sys
import json
import os
import io



def EndPoint(script_name=None, cwd=None, method="GET", q=None, headers=None, body=None, output=None):
    # Initialize environment dictionary
    this_env = {"environ": {"polycl": "Yes"}}
    this_env["environ"]["DOCUMENT_ROOT"] = cwd if cwd else os.getcwd()
    this_env["environ"]["HTTP_REFERER"] = "localhost"
    this_env["environ"]["SCRIPT_FILENAME"] = f'{this_env["environ"]["DOCUMENT_ROOT"]}/{script_name}'
    this_env["environ"]["REQUEST_URI"] = f"/{script_name}"
    this_env["environ"]["SCRIPT_NAME"] = f"/{script_name}"
    this_env["environ"]["CONTENT_TYPE"] = "text/plain"
    this_env["environ"]["REQUEST_METHOD"] = method if method else "GET"
    this_env["environ"]["QUERY_STRING"] = q if q else ""

    # Official HTTP headers
    official_http_headers = {
        "Accept", "Accept-Charset", "Accept-Encoding", "Accept-Language",
        "Authorization", "Cache-Control", "Connection", "Content-Length",
        "Content-Type", "Date", "Expect", "Forwarded", "From",
        "Host", "If-Match", "If-Modified-Since", "If-None-Match",
        "If-Range", "If-Unmodified-Since", "Max-Forwards", "Pragma",
        "Proxy-Authorization", "Range", "Referer", "TE", "Upgrade",
        "User-Agent", "Via", "Warning"
    }

    # Process headers if provided
    if headers:
        for name, value in headers.items():
            key = name.replace("-", "_").upper()
            key = key if name in official_http_headers else f"HTTP_{key}"
            this_env["environ"][key] = value

    # Process request body
    buf = io.BytesIO()
    if body:
        buf.write(body.encode())  # Encode body content to bytes
    buf.seek(0)
    this_env["environ"]['wsgi.input'] = buf

    # Append SDK path
    sdk_path = "/sdk-srvar/wsfg"
    if os.path.exists(sdk_path):
        sys.path.append(sdk_path)
    else:
        print(f"Warning: polyframe-endpoint SDK path '{sdk_path}' not found!")

    # Initialize response variables
    this_status = None
    this_headers = []

    def start_response(status, headers):
        nonlocal this_status, this_headers
        this_status = status
        this_headers = headers

    # Import and execute WSGI application
    try:
        from wsfg import application
        response_body = application(this_env["environ"], start_response)[0]
    except Exception as e:
        start_response("500 Internal Server Error",[])
        response_body  = e
        sys.exit(1)

    # Process response headers
    response_headers = dict(this_headers)

    # Decode response body if necessary
    if isinstance(response_body, bytes):
        response_body = response_body.decode()

    # Prepare response
    response_ = {
        'status': this_status,
        'body': response_body,
        'headers': response_headers
    }

    # Output response based on format
    if output == "s":
       return response_['status']
    elif output == "h":
        for h, value in response_['headers'].items():
            return f"{h}: {value}"
    elif output == "d":
        return response_['body']
    else:
       return json.dumps(response_, indent=2)
