from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    BooleanType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ExpansionProfileSchema:
    """
    Resource to define constraints on the Expansion of a FHIR ValueSet.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Resource to define constraints on the Expansion of a FHIR ValueSet.


        id: The logical id of the resource, as used in the URL for the resource. Once
            assigned, this value never changes.

        extension: May be used to represent additional information that is not part of the basic
            definition of the resource. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        meta: The metadata about the resource. This is content that is maintained by the
            infrastructure. Changes to the content may not always be associated with
            version changes to the resource.

        implicitRules: A reference to a set of rules that were followed when the resource was
            constructed, and which must be understood when processing the content.

        language: The base language in which the resource is written.

        text: A human-readable narrative that contains a summary of the resource, and may be
            used to represent the content of the resource to a human. The narrative need
            not encode all the structured data, but is required to contain sufficient
            detail to make it "clinically safe" for a human to just read the narrative.
            Resource definitions may define what content should be represented in the
            narrative to ensure clinical safety.

        contained: These resources do not have an independent existence apart from the resource
            that contains them - they cannot be identified independently, and nor can they
            have their own independent transaction scope.

        resourceType: This is a ExpansionProfile resource

        url: An absolute URI that is used to identify this expansion profile when it is
            referenced in a specification, model, design or an instance. This SHALL be a
            URL, SHOULD be globally unique, and SHOULD be an address at which this
            expansion profile is (or will be) published. The URL SHOULD include the major
            version of the expansion profile. For more information see [Technical and
            Business Versions](resource.html#versions).

        identifier: A formal identifier that is used to identify this expansion profile when it is
            represented in other formats, or referenced in a specification, model, design
            or an instance.

        version: The identifier that is used to identify this version of the expansion profile
            when it is referenced in a specification, model, design or instance. This is
            an arbitrary value managed by the expansion profile author and is not expected
            to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if
            a managed version is not available. There is also no expectation that versions
            can be placed in a lexicographical sequence.

        name: A natural language name identifying the expansion profile. This name should be
            usable as an identifier for the module by machine processing applications such
            as code generation.

        status: The status of this expansion profile. Enables tracking the life-cycle of the
            content.

        experimental: A boolean value to indicate that this expansion profile is authored for
            testing purposes (or education/evaluation/marketing), and is not intended to
            be used for genuine usage.

        date: The date  (and optionally time) when the expansion profile was published. The
            date must change if and when the business version changes and it must change
            if the status code changes. In addition, it should change when the substantive
            content of the expansion profile changes.

        publisher: The name of the individual or organization that published the expansion
            profile.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        description: A free text natural language description of the expansion profile from a
            consumer's perspective.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate expansion profile instances.

        jurisdiction: A legal or geographic region in which the expansion profile is intended to be
            used.

        fixedVersion: Fix use of a particular code system to a particular version.

        excludedSystem: Code system, or a particular version of a code system to be excluded from
            value set expansions.

        includeDesignations: Controls whether concept designations are to be included or excluded in value
            set expansions.

        designation: A set of criteria that provide the constraints imposed on the value set
            expansion by including or excluding designations.

        includeDefinition: Controls whether the value set definition is included or excluded in value set
            expansions.

        activeOnly: Controls whether inactive concepts are included or excluded in value set
            expansions.

        excludeNested: Controls whether or not the value set expansion nests codes or not (i.e.
            ValueSet.expansion.contains.contains).

        excludeNotForUI: Controls whether or not the value set expansion includes codes which cannot be
            displayed in user interfaces.

        excludePostCoordinated: Controls whether or not the value set expansion includes post coordinated
            codes.

        displayLanguage: Specifies the language to be used for description in the expansions i.e. the
            language to be used for ValueSet.expansion.contains.display.

        limitedExpansion: If the value set being expanded is incomplete (because it is too big to
            expand), return a limited expansion (a subset) with an indicator that
            expansion is incomplete, using the extension
            [http://hl7.org/fhir/StructureDefinition/valueset-toocostly](extension-
            valueset-toocostly.html).

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.meta import MetaSchema
        from spark_fhir_schemas.stu3.complex_types.narrative import NarrativeSchema
        from spark_fhir_schemas.stu3.simple_types.resourcelist import ResourceListSchema
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.contactdetail import (
            ContactDetailSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.usagecontext import (
            UsageContextSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.expansionprofile_fixedversion import (
            ExpansionProfile_FixedVersionSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.expansionprofile_excludedsystem import (
            ExpansionProfile_ExcludedSystemSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.expansionprofile_designation import (
            ExpansionProfile_DesignationSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ExpansionProfile") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ExpansionProfile"]
        schema = StructType(
            [
                # The logical id of the resource, as used in the URL for the resource. Once
                # assigned, this value never changes.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the resource. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The metadata about the resource. This is content that is maintained by the
                # infrastructure. Changes to the content may not always be associated with
                # version changes to the resource.
                StructField(
                    "meta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A reference to a set of rules that were followed when the resource was
                # constructed, and which must be understood when processing the content.
                StructField("implicitRules", StringType(), True),
                # The base language in which the resource is written.
                StructField("language", StringType(), True),
                # A human-readable narrative that contains a summary of the resource, and may be
                # used to represent the content of the resource to a human. The narrative need
                # not encode all the structured data, but is required to contain sufficient
                # detail to make it "clinically safe" for a human to just read the narrative.
                # Resource definitions may define what content should be represented in the
                # narrative to ensure clinical safety.
                StructField(
                    "text",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # These resources do not have an independent existence apart from the resource
                # that contains them - they cannot be identified independently, and nor can they
                # have their own independent transaction scope.
                StructField(
                    "contained",
                    ArrayType(
                        ResourceListSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # This is a ExpansionProfile resource
                StructField("resourceType", StringType(), True),
                # An absolute URI that is used to identify this expansion profile when it is
                # referenced in a specification, model, design or an instance. This SHALL be a
                # URL, SHOULD be globally unique, and SHOULD be an address at which this
                # expansion profile is (or will be) published. The URL SHOULD include the major
                # version of the expansion profile. For more information see [Technical and
                # Business Versions](resource.html#versions).
                StructField("url", StringType(), True),
                # A formal identifier that is used to identify this expansion profile when it is
                # represented in other formats, or referenced in a specification, model, design
                # or an instance.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The identifier that is used to identify this version of the expansion profile
                # when it is referenced in a specification, model, design or instance. This is
                # an arbitrary value managed by the expansion profile author and is not expected
                # to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if
                # a managed version is not available. There is also no expectation that versions
                # can be placed in a lexicographical sequence.
                StructField("version", StringType(), True),
                # A natural language name identifying the expansion profile. This name should be
                # usable as an identifier for the module by machine processing applications such
                # as code generation.
                StructField("name", StringType(), True),
                # The status of this expansion profile. Enables tracking the life-cycle of the
                # content.
                StructField("status", StringType(), True),
                # A boolean value to indicate that this expansion profile is authored for
                # testing purposes (or education/evaluation/marketing), and is not intended to
                # be used for genuine usage.
                StructField("experimental", BooleanType(), True),
                # The date  (and optionally time) when the expansion profile was published. The
                # date must change if and when the business version changes and it must change
                # if the status code changes. In addition, it should change when the substantive
                # content of the expansion profile changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the expansion
                # profile.
                StructField("publisher", StringType(), True),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A free text natural language description of the expansion profile from a
                # consumer's perspective.
                StructField("description", StringType(), True),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate expansion profile instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A legal or geographic region in which the expansion profile is intended to be
                # used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Fix use of a particular code system to a particular version.
                StructField(
                    "fixedVersion",
                    ArrayType(
                        ExpansionProfile_FixedVersionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Code system, or a particular version of a code system to be excluded from
                # value set expansions.
                StructField(
                    "excludedSystem",
                    ExpansionProfile_ExcludedSystemSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Controls whether concept designations are to be included or excluded in value
                # set expansions.
                StructField("includeDesignations", BooleanType(), True),
                # A set of criteria that provide the constraints imposed on the value set
                # expansion by including or excluding designations.
                StructField(
                    "designation",
                    ExpansionProfile_DesignationSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth + 1,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # Controls whether the value set definition is included or excluded in value set
                # expansions.
                StructField("includeDefinition", BooleanType(), True),
                # Controls whether inactive concepts are included or excluded in value set
                # expansions.
                StructField("activeOnly", BooleanType(), True),
                # Controls whether or not the value set expansion nests codes or not (i.e.
                # ValueSet.expansion.contains.contains).
                StructField("excludeNested", BooleanType(), True),
                # Controls whether or not the value set expansion includes codes which cannot be
                # displayed in user interfaces.
                StructField("excludeNotForUI", BooleanType(), True),
                # Controls whether or not the value set expansion includes post coordinated
                # codes.
                StructField("excludePostCoordinated", BooleanType(), True),
                # Specifies the language to be used for description in the expansions i.e. the
                # language to be used for ValueSet.expansion.contains.display.
                StructField("displayLanguage", StringType(), True),
                # If the value set being expanded is incomplete (because it is too big to
                # expand), return a limited expansion (a subset) with an indicator that
                # expansion is incomplete, using the extension
                # [http://hl7.org/fhir/StructureDefinition/valueset-toocostly](extension-
                # valueset-toocostly.html).
                StructField("limitedExpansion", BooleanType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
