# mypy-boto3-ram

[![PyPI - mypy-boto3-ram](https://img.shields.io/pypi/v/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.RAM 1.17.16](https://boto3.amazonaws.com/v1/documentation/api/1.17.16/reference/services/ram.html#RAM) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ram](#mypy-boto3-ram)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `RAM` service.

```bash
python -m pip install boto3-stubs[ram]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ram]` in your environment: `python -m pip install 'boto3-stubs[ram]'`

Both type checking and auto-complete should work for `RAM` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[ram]` in your environment: `python -m pip install 'boto3-stubs[ram]'`

Both type checking and auto-complete should work for `RAM` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ram]` in your environment: `python -m pip install 'boto3-stubs[ram]'`
- Run `mypy` as usual

Type checking should work for `RAM` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ram]` in your environment: `python -m pip install 'boto3-stubs[ram]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RAM` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`RAMClient` provides annotations for `boto3.client("ram")`.

```python
import boto3

from mypy_boto3_ram import RAMClient

client: RAMClient = boto3.client("ram")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RAMClient = session.client("ram")
```

### Paginators annotations

`mypy_boto3_ram.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ram import RAMClient
from mypy_boto3_ram.paginator import (
    GetResourcePoliciesPaginator,
    GetResourceShareAssociationsPaginator,
    GetResourceShareInvitationsPaginator,
    GetResourceSharesPaginator,
    ListPrincipalsPaginator,
    ListResourcesPaginator,
)

client: RAMClient = boto3.client("ram")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_resource_policies_paginator: GetResourcePoliciesPaginator = client.get_paginator("get_resource_policies")
get_resource_share_associations_paginator: GetResourceShareAssociationsPaginator = client.get_paginator("get_resource_share_associations")
get_resource_share_invitations_paginator: GetResourceShareInvitationsPaginator = client.get_paginator("get_resource_share_invitations")
get_resource_shares_paginator: GetResourceSharesPaginator = client.get_paginator("get_resource_shares")
list_principals_paginator: ListPrincipalsPaginator = client.get_paginator("list_principals")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
```







### Typed dictionations

`mypy_boto3_ram.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_ram.type_defs import (
    PrincipalTypeDef,
    ResourceShareAssociationTypeDef,
    ResourceShareInvitationTypeDef,
    ResourceSharePermissionDetailTypeDef,
    ResourceSharePermissionSummaryTypeDef,
    ResourceShareTypeDef,
    ResourceTypeDef,
    ServiceNameAndResourceTypeTypeDef,
    TagTypeDef,
    AcceptResourceShareInvitationResponseTypeDef,
    AssociateResourceSharePermissionResponseTypeDef,
    AssociateResourceShareResponseTypeDef,
    CreateResourceShareResponseTypeDef,
    DeleteResourceShareResponseTypeDef,
    DisassociateResourceSharePermissionResponseTypeDef,
    DisassociateResourceShareResponseTypeDef,
    EnableSharingWithAwsOrganizationResponseTypeDef,
    GetPermissionResponseTypeDef,
    GetResourcePoliciesResponseTypeDef,
    GetResourceShareAssociationsResponseTypeDef,
    GetResourceShareInvitationsResponseTypeDef,
    GetResourceSharesResponseTypeDef,
    ListPendingInvitationResourcesResponseTypeDef,
    ListPermissionsResponseTypeDef,
    ListPrincipalsResponseTypeDef,
    ListResourceSharePermissionsResponseTypeDef,
    ListResourceTypesResponseTypeDef,
    ListResourcesResponseTypeDef,
    PaginatorConfigTypeDef,
    PromoteResourceShareCreatedFromPolicyResponseTypeDef,
    RejectResourceShareInvitationResponseTypeDef,
    TagFilterTypeDef,
    UpdateResourceShareResponseTypeDef,
)

def get_structure() -> PrincipalTypeDef:
    return {
      ...
    }
```
