#      Copyright (C) 2020 <Florian Alu - Prolibre - https://prolibre.com
#      This program is free software: you can redistribute it and/or modify
#      it under the terms of the GNU Affero General Public License as
#      published by the Free Software Foundation, either version 3 of the
#      License, or (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU Affero General Public License for more details.
#
#      You should have received a copy of the GNU Affero General Public License
#      along with this program.  If not, see <https://www.gnu.org/licenses/>.

# Generated by Django 3.1.1 on 2020-09-16 09:04

import datetime

import django.utils.timezone
import model_utils.fields
from django.db import migrations, models
from django.utils.timezone import utc

import nobinobi_daily_follow_up.models


class Migration(migrations.Migration):

    replaces = [('nobinobi_daily_follow_up', '0001_initial'), ('nobinobi_daily_follow_up', '0002_auto_20190513_1535'), ('nobinobi_daily_follow_up', '0003_troubleshooting'), ('nobinobi_daily_follow_up', '0004_auto_20190815_1141'), ('nobinobi_daily_follow_up', '0005_auto_20190923_1517'), ('nobinobi_daily_follow_up', '0006_medication_child'), ('nobinobi_daily_follow_up', '0007_givemedication_date'), ('nobinobi_daily_follow_up', '0008_auto_20191021_1443'), ('nobinobi_daily_follow_up', '0009_fix_early_troubleshoting_relation'), ('nobinobi_daily_follow_up', '0010_add_intermediary_departure_arrival_time'), ('nobinobi_daily_follow_up', '0011_auto_20200401_1117')]

    dependencies = [
        ('nobinobi_staff', '0006_staff_working_base'),
        ('nobinobi_child', '0004_auto_20190531_1027'),
        ('nobinobi_child', '0010_auto_20191016_1523'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActivityGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Groupe d’activités',
                'verbose_name_plural': 'Groupes d’activités',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Lotion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Crème',
                'verbose_name_plural': 'Crèmes',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Meal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('image', models.ImageField(blank=True, null=True, upload_to=nobinobi_daily_follow_up.models.Meal.upload_image_meal, verbose_name='Image')),
            ],
            options={
                'verbose_name': 'Repas',
                'verbose_name_plural': 'Repas',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Presence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('date', models.DateField(verbose_name='Date')),
                ('arrival_time', models.TimeField(verbose_name="Heure d'arrivée")),
                ('departure_time', models.TimeField(blank=True, null=True, verbose_name='Heure de départ')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant')),
                ('classroom', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_child.classroom', verbose_name='Salle de classe')),
                ('intermediate_arrival_time', models.TimeField(blank=True, null=True, verbose_name='Intermediate arrival time')),
                ('intermediate_departure_time', models.TimeField(blank=True, null=True, verbose_name='Intermediate departure time')),
            ],
            options={
                'verbose_name': 'Présence',
                'verbose_name_plural': 'Présences',
                'ordering': ('date',),
                'unique_together': {('child', 'date')},
            },
        ),
        migrations.CreateModel(
            name='TypeMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Type de médicament',
                'verbose_name_plural': 'Types de médicaments',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='DailyFollowUp',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('presence', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.presence')),
                ('important', models.BooleanField(default=False, verbose_name='Important')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
            ],
            options={
                'verbose_name': 'Daily follow-up',
                'verbose_name_plural': 'Daily follow-ups',
                'ordering': ('presence',),
            },
        ),
        migrations.CreateModel(
            name='TypeActivity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('order', models.PositiveSmallIntegerField(verbose_name='Ordre')),
                ('group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.activitygroup', verbose_name='Groupe')),
            ],
            options={
                'verbose_name': "Types d'activité",
                'verbose_name_plural': 'Types d’activités',
                'ordering': ('order', 'name', 'group'),
            },
        ),
        migrations.CreateModel(
            name='Medication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('attachment', models.FileField(blank=True, null=True, upload_to=nobinobi_daily_follow_up.models.Medication.attachment_file_medication, verbose_name='Pièce jointe')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('type_medication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.typemedication', verbose_name='Type medication')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Médicament',
                'verbose_name_plural': 'Médicaments',
                'ordering': ('daily_follow_up', 'type_medication'),
            },
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('type_activity', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.typeactivity', verbose_name='Type activity')),
            ],
            options={
                'verbose_name': 'Activity',
                'verbose_name_plural': 'Activities',
                'ordering': ('daily_follow_up', 'type_activity'),
            },
        ),
        migrations.CreateModel(
            name='LotionDailyFollowUp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('comment', model_utils.fields.SplitField(blank=True, no_excerpt_field=True, null=True, verbose_name='Commentaire')),
                ('_comment_excerpt', models.TextField(editable=False)),
                ('lotion', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.lotion', verbose_name='Lotion')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Daily follow-up')),
            ],
            options={
                'verbose_name': 'Suivi des crèmes',
                'verbose_name_plural': 'Suivis des crèmes',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='activities',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Activity', to='nobinobi_daily_follow_up.TypeActivity', verbose_name='Activities'),
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='lotions',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.LotionDailyFollowUp', to='nobinobi_daily_follow_up.Lotion', verbose_name='Lotions'),
        ),
        migrations.AddField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Medication', to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Medications'),
        ),
        migrations.AddField(
            model_name='activity',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Daily follow-up'),
        ),
        migrations.AlterModelOptions(
            name='activity',
            options={'ordering': ('daily_follow_up', 'type_activity'), 'verbose_name': 'Activité', 'verbose_name_plural': 'Activités'},
        ),
        migrations.AlterModelOptions(
            name='dailyfollowup',
            options={'ordering': ('presence',), 'verbose_name': 'Suivi journalier', 'verbose_name_plural': 'Suivis journaliers'},
        ),
        migrations.AlterField(
            model_name='activity',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='activity',
            name='type_activity',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.typeactivity', verbose_name="Types d'activité"),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='activities',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Activity', to='nobinobi_daily_follow_up.TypeActivity', verbose_name='Activités'),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='lotions',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.LotionDailyFollowUp', to='nobinobi_daily_follow_up.Lotion', verbose_name='Crèmes'),
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.Medication', to='nobinobi_daily_follow_up.TypeMedication', verbose_name='Médicaments'),
        ),
        migrations.CreateModel(
            name='DiaperChange',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('hour', models.TimeField(verbose_name='Heure')),
                ('feces', models.CharField(choices=[('feces', 'caca.png'), ('nothing', 'nothing.png')], default='nothing', max_length=15, verbose_name='Selles')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier')),
            ],
            options={
                'verbose_name': 'Changement de couche',
                'verbose_name_plural': 'Changements de couches',
                'ordering': ('daily_follow_up', 'hour'),
            },
        ),
        migrations.AlterField(
            model_name='lotiondailyfollowup',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='lotiondailyfollowup',
            name='lotion',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.lotion', verbose_name='Crème'),
        ),
        migrations.CreateModel(
            name='MealDailyFollowUp',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('daily_follow_up', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.dailyfollowup')),
                ('snack_time', models.TimeField(blank=True, null=True, verbose_name='Heure de la collation')),
                ('snack_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Bien mangé ?')),
                ('lunch_time', models.TimeField(blank=True, null=True, verbose_name='Heure du diner')),
                ('lunch_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Bien mangé')),
                ('afternoon_snack_time', models.TimeField(blank=True, null=True, verbose_name='Heure du goûter')),
                ('afternoon_snack_quality', models.CharField(blank=True, choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], max_length=10, null=True, verbose_name='Bien mangé ?')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
                ('afternoon_snack_meals', models.ManyToManyField(blank=True, related_name='afternoon_snack_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Goûter')),
                ('lunch_meals', models.ManyToManyField(blank=True, related_name='lunch_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Diner')),
                ('snack_meals', models.ManyToManyField(blank=True, related_name='snack_meals', to='nobinobi_daily_follow_up.Meal', verbose_name='Collation')),
            ],
            options={
                'verbose_name': 'Suivi journalier des repas',
                'verbose_name_plural': 'Suivi journalier des repas',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.AlterField(
            model_name='medication',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier'),
        ),
        migrations.AlterField(
            model_name='medication',
            name='type_medication',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_daily_follow_up.typemedication', verbose_name='Type de médicament'),
        ),
        migrations.CreateModel(
            name='Nap',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('start_time', models.TimeField(verbose_name='Heure de début')),
                ('end_time', models.TimeField(blank=True, null=True, verbose_name='Heure de fin')),
                ('daily_follow_up', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier')),
            ],
            options={
                'verbose_name': 'Sieste',
                'verbose_name_plural': 'Siestes',
                'ordering': ('start_time', 'end_time'),
            },
        ),
        migrations.CreateModel(
            name='Reception',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('daily_follow_up', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='nobinobi_daily_follow_up.dailyfollowup')),
                ('wake_up_time', models.TimeField(choices=[(datetime.time(5, 0), '05H00'), (datetime.time(5, 15), '05H15'), (datetime.time(5, 30), '05H30'), (datetime.time(5, 45), '05H45'), (datetime.time(6, 0), '06H00'), (datetime.time(6, 15), '06H15'), (datetime.time(6, 30), '06H30'), (datetime.time(6, 45), '06H45'), (datetime.time(7, 0), '07H00'), (datetime.time(7, 15), '07H15'), (datetime.time(7, 30), '07H30'), (datetime.time(7, 45), '07H45'), (datetime.time(8, 0), '08H00')], default=datetime.time(6, 0), null=True, verbose_name='Heure de réveil')),
                ('sleep', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('bad', 'spook.png')], default='very_good', max_length=10, null=True, verbose_name='Sommeil')),
                ('breakfast', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('nothing', 'nothing.png')], default='very_good', max_length=20, null=True, verbose_name='Petit-déjeuner')),
                ('breakfast_time', models.TimeField(blank=True, null=True, verbose_name='Heure du petit-déjeuner')),
                ('condition', models.CharField(choices=[('very_good', 'miao.png'), ('good', 'smile.png'), ('sick', 'spook.png')], default='very_good', max_length=10, null=True, verbose_name="Etat de l'enfant")),
                ('fever', models.CharField(choices=[('no', 'Non'), ('37', '37'), ('37.5', '37.5'), ('38', '38'), ('38.5', '38.5'), ('39', '39'), ('39.5', '39.5'), ('40', '40')], default='no', max_length=10, null=True, verbose_name='Fièvre')),
                ('sick', models.CharField(choices=[('no', 'Non'), ('gastroenteritis', 'Gastro-entérite'), ('conjunctivitis', 'Conjonctivite'), ('cough', 'Toux'), ('cold', 'Rhume')], default='no', max_length=25, null=True, verbose_name='Malade')),
                ('comment', models.TextField(blank=True, null=True, verbose_name='Commentaire')),
            ],
            options={
                'verbose_name': 'Accueil',
                'verbose_name_plural': 'Accueils',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.CreateModel(
            name='Troubleshooting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('daily_follow_up', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier')),
                ('periods', models.ManyToManyField(to='nobinobi_child.Period', verbose_name='Périodes')),
            ],
            options={
                'verbose_name': 'Dépannage',
                'verbose_name_plural': 'Dépannage',
                'ordering': ('daily_follow_up',),
            },
        ),
        migrations.CreateModel(
            name='DailyFollowUpToMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'verbose_name': 'Daily Follow-up to Medication',
                'ordering': ('daily_follow_up', 'medication'),
            },
        ),
        migrations.AlterModelOptions(
            name='medication',
            options={'ordering': ('from_date', 'end_date', 'type_medication'), 'verbose_name': 'Médicament', 'verbose_name_plural': 'Médicaments'},
        ),
        migrations.RemoveField(
            model_name='medication',
            name='daily_follow_up',
        ),
        migrations.AddField(
            model_name='medication',
            name='end_date',
            field=models.DateField(default=datetime.datetime(2019, 9, 23, 13, 17, 47, 116305, tzinfo=utc), verbose_name='Date de fin'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='medication',
            name='from_date',
            field=models.DateField(default=datetime.datetime(2019, 9, 23, 13, 17, 54, 284229, tzinfo=utc), verbose_name='Date de début'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='dailyfollowup',
            name='medications',
            field=models.ManyToManyField(through='nobinobi_daily_follow_up.DailyFollowUpToMedication', to='nobinobi_daily_follow_up.Medication', verbose_name='Médicaments'),
        ),
        migrations.AddField(
            model_name='dailyfollowuptomedication',
            name='daily_follow_up',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.dailyfollowup', verbose_name='Suivi journalier'),
        ),
        migrations.AddField(
            model_name='dailyfollowuptomedication',
            name='medication',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.medication', verbose_name='Médicament'),
        ),
        migrations.AddField(
            model_name='medication',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child'),
        ),
        migrations.CreateModel(
            name='GiveMedication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('give_hour', models.TimeField(verbose_name='Donner à')),
                ('given_hour', models.TimeField(blank=True, null=True, verbose_name='Donné à')),
                ('medication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_daily_follow_up.medication', verbose_name='Médicament')),
                ('staff', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.staff', verbose_name='Personnel')),
                ('date', models.DateField(default=datetime.date(2019, 9, 25), verbose_name='Date')),
            ],
            options={
                'verbose_name': 'Donner médicament',
                'verbose_name_plural': 'Donner médicaments',
                'ordering': ('medication',),
            },
        ),
        migrations.CreateModel(
            name='EarlyTroubleshooting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(verbose_name='Date')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child')),
                ('periods', models.ManyToManyField(to='nobinobi_child.Period', verbose_name='Périodes')),
            ],
            options={
                'verbose_name': 'Early Troubleshooting',
                'verbose_name_plural': 'Early Troubleshootings',
                'ordering': ('date',),
                'unique_together': {('child', 'date')},
            },
        ),
    ]
