/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.common.utils;

import com.alibaba.alink.common.lazy.LazyEvaluation;
import com.alibaba.alink.operator.batch.BatchOperator;
import com.alibaba.alink.operator.common.io.csv.CsvFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OperatorCsvCollector {
    public static List<String> collectToCsv(BatchOperator<?>[] ops, String lineTerminator, String fieldDelimiter, Character quoteChar) throws Exception {
        List<LazyEvaluation<String>> lazyCsvs = OperatorCsvCollector.lazyCollectToCsv(ops, lineTerminator, fieldDelimiter, quoteChar);
        BatchOperator.execute();
        ArrayList<String> csvs = new ArrayList<String>();
        for (LazyEvaluation<String> lazyCsv : lazyCsvs) {
            csvs.add((String)lazyCsv.getLatestValue());
        }
        return csvs;
    }

    public static List<LazyEvaluation<String>> lazyCollectToCsv(BatchOperator<?>[] ops, String lineTerminator, String fieldDelimiter, Character quoteChar) {
        return Arrays.stream(ops).map(op -> {
            LazyEvaluation lazyCsv = new LazyEvaluation();
            op.lazyCollect(new Consumer[]{rows -> {
                CsvFormatter csvFormatter = new CsvFormatter(op.getColTypes(), fieldDelimiter, quoteChar);
                String ret = rows.stream().map(arg_0 -> ((CsvFormatter)csvFormatter).format(arg_0)).collect(Collectors.joining(lineTerminator));
                lazyCsv.addValue((Object)ret);
            }});
            return lazyCsv;
        }).collect(Collectors.toList());
    }
}

