import os
import sys

root = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.append(root)

# ----------------------------------------------------------------------------

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

# ----------------------------------------------------------------------------

import numbers  # noqa: E402
try:
    basestring  # basestring was removed in Python 3
except NameError:
    basestring = str

# ----------------------------------------------------------------------------


#  ---------------------------------------------------------------------------

def test_transaction(exchange, transaction, code, now):
    assert transaction
    assert isinstance(transaction['id'], basestring)
    assert isinstance(transaction['timestamp'], numbers.Real)
    assert transaction['timestamp'] > 1230940800000  # 03 Jan 2009 - first block
    assert transaction['timestamp'] < now
    assert 'updated' in transaction
    assert 'address' in transaction
    assert 'tag' in transaction
    assert 'txid' in transaction
    assert transaction['datetime'] == exchange.iso8601(transaction['timestamp'])
    assert(transaction['status'] == 'ok') or (transaction['status'] == 'pending') or (transaction['status'] == 'canceled')
    assert transaction['currency'] == code
    assert isinstance(transaction['type'], basestring)
    assert transaction['type'] == 'deposit' or transaction['type'] == 'withdrawal'
    assert isinstance(transaction['amount'], numbers.Real)
    assert transaction['amount'] >= 0
    if transaction['fee']:
        assert isinstance(transaction['fee']['cost'], numbers.Real)
        if transaction['fee']['cost'] != 0:
            assert isinstance(transaction['fee']['currency'], basestring)

    assert transaction.info
