<a id="mypy-boto3-ram"></a>

# mypy-boto3-ram

[![PyPI - mypy-boto3-ram](https://img.shields.io/pypi/v/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ram.svg?color=blue)](https://pypi.org/project/mypy-boto3-ram)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ram?color=blue)](https://pypistats.org/packages/mypy-boto3-ram)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.RAM 1.19.5](https://boto3.amazonaws.com/v1/documentation/api/1.19.5/reference/services/ram.html#RAM)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ram docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ram/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ram](#mypy-boto3-ram)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `RAM` service.

```bash
python -m pip install boto3-stubs[ram]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ram]` in your environment:
  `python -m pip install 'boto3-stubs[ram]'`

Both type checking and auto-complete should work for `RAM` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ram]` in your environment:
  `python -m pip install 'boto3-stubs[ram]'`

Both type checking and auto-complete should work for `RAM` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ram]` in your environment:
  `python -m pip install 'boto3-stubs[ram]'`
- Run `mypy` as usual

Type checking should work for `RAM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ram]` in your environment:
  `python -m pip install 'boto3-stubs[ram]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `RAM` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`RAMClient` provides annotations for `boto3.client("ram")`.

```python
import boto3

from mypy_boto3_ram import RAMClient

client: RAMClient = boto3.client("ram")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: RAMClient = session.client("ram")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ram.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ram import RAMClient
from mypy_boto3_ram.paginator import (
    GetResourcePoliciesPaginator,
    GetResourceShareAssociationsPaginator,
    GetResourceShareInvitationsPaginator,
    GetResourceSharesPaginator,
    ListPrincipalsPaginator,
    ListResourcesPaginator,
)

client: RAMClient = boto3.client("ram")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_resource_policies_paginator: GetResourcePoliciesPaginator = client.get_paginator("get_resource_policies")
get_resource_share_associations_paginator: GetResourceShareAssociationsPaginator = client.get_paginator("get_resource_share_associations")
get_resource_share_invitations_paginator: GetResourceShareInvitationsPaginator = client.get_paginator("get_resource_share_invitations")
get_resource_shares_paginator: GetResourceSharesPaginator = client.get_paginator("get_resource_shares")
list_principals_paginator: ListPrincipalsPaginator = client.get_paginator("list_principals")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ram.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ram.literals import (
    GetResourcePoliciesPaginatorName,
    GetResourceShareAssociationsPaginatorName,
    GetResourceShareInvitationsPaginatorName,
    GetResourceSharesPaginatorName,
    ListPrincipalsPaginatorName,
    ListResourcesPaginatorName,
    ResourceOwnerType,
    ResourceShareAssociationStatusType,
    ResourceShareAssociationTypeType,
    ResourceShareFeatureSetType,
    ResourceShareInvitationStatusType,
    ResourceShareStatusType,
    ResourceStatusType,
    ServiceName,
    PaginatorName,
)

def check_value(value: GetResourcePoliciesPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ram.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ram.type_defs import (
    AcceptResourceShareInvitationRequestRequestTypeDef,
    AcceptResourceShareInvitationResponseTypeDef,
    AssociateResourceSharePermissionRequestRequestTypeDef,
    AssociateResourceSharePermissionResponseTypeDef,
    AssociateResourceShareRequestRequestTypeDef,
    AssociateResourceShareResponseTypeDef,
    CreateResourceShareRequestRequestTypeDef,
    CreateResourceShareResponseTypeDef,
    DeleteResourceShareRequestRequestTypeDef,
    DeleteResourceShareResponseTypeDef,
    DisassociateResourceSharePermissionRequestRequestTypeDef,
    DisassociateResourceSharePermissionResponseTypeDef,
    DisassociateResourceShareRequestRequestTypeDef,
    DisassociateResourceShareResponseTypeDef,
    EnableSharingWithAwsOrganizationResponseTypeDef,
    GetPermissionRequestRequestTypeDef,
    GetPermissionResponseTypeDef,
    GetResourcePoliciesRequestRequestTypeDef,
    GetResourcePoliciesResponseTypeDef,
    GetResourceShareAssociationsRequestRequestTypeDef,
    GetResourceShareAssociationsResponseTypeDef,
    GetResourceShareInvitationsRequestRequestTypeDef,
    GetResourceShareInvitationsResponseTypeDef,
    GetResourceSharesRequestRequestTypeDef,
    GetResourceSharesResponseTypeDef,
    ListPendingInvitationResourcesRequestRequestTypeDef,
    ListPendingInvitationResourcesResponseTypeDef,
    ListPermissionsRequestRequestTypeDef,
    ListPermissionsResponseTypeDef,
    ListPrincipalsRequestRequestTypeDef,
    ListPrincipalsResponseTypeDef,
    ListResourceSharePermissionsRequestRequestTypeDef,
    ListResourceSharePermissionsResponseTypeDef,
    ListResourceTypesRequestRequestTypeDef,
    ListResourceTypesResponseTypeDef,
    ListResourcesRequestRequestTypeDef,
    ListResourcesResponseTypeDef,
    PaginatorConfigTypeDef,
    PrincipalTypeDef,
    PromoteResourceShareCreatedFromPolicyRequestRequestTypeDef,
    PromoteResourceShareCreatedFromPolicyResponseTypeDef,
    RejectResourceShareInvitationRequestRequestTypeDef,
    RejectResourceShareInvitationResponseTypeDef,
    ResourceShareAssociationTypeDef,
    ResourceShareInvitationTypeDef,
    ResourceSharePermissionDetailTypeDef,
    ResourceSharePermissionSummaryTypeDef,
    ResourceShareTypeDef,
    ResourceTypeDef,
    ResponseMetadataTypeDef,
    ServiceNameAndResourceTypeTypeDef,
    TagFilterTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateResourceShareRequestRequestTypeDef,
    UpdateResourceShareResponseTypeDef,
)

def get_structure() -> AcceptResourceShareInvitationRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ram` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ram docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ram/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
