import requests
import random
import json

from memelib.errors import *
from memelib.cache import MemeCacher

class DankMemeClient:
    def __init__(self, use_reddit_for_memes: bool = True, reddit_user_agent:str = "MemeLsib"):
        self.memes = {
            "random":"meme()"
        }
        self.meme_subreddits = [
            "/dankmemes",
            "/memes",
            "/wholesomememes"
        ]
        self.agent = reddit_user_agent
        self.usereddit = use_reddit_for_memes
    def meme(self, subreddit = None):
        if self.usereddit and subreddit:
            r = requests.request("GET", f"https://reddit.com/r/{subreddit}/random.json", headers={"user-agent": self.agent}).json()
            if r.status_code != 200:
                if r.status_code == 429:
                    raise RateLimitError("Uh-oh, it looks like you were ratelimited! Try changing your user agent by passing it in the `DankMemeClient` call.")
                    return None
                elif r.status_code == 404:
                    raise SubredditNotFoundError("Reddit's API returned a 404 error. Make sure the subreddit that you passed does not include the `r/` in front of it.")
                    return None
                else:
                    raise RedditApiError(f"Reddit's API returned status code {r.status_code}")
                    return None
            data = {
                "title" : r[0]['data']['children'][0]['data']['title'],
                "author" : f"u/{r[0]['data']['children'][0]['data']['author']}",
                "subreddit" : r[0]['data']['children'][0]['data']['subreddit_name_prefixed'],
                "upvotes" : r[0]['data']['children'][0]['data']['ups'],
                "comments" : r[0]['data']['children'][0]['data']['num_comments'],
                "img_url" : r[0]['data']['children'][0]['data']['url'],
                "post_url" : f"https://reddit.com{r[0]['data']['children'][0]['data']['permalink']}"
            }
            return data
        elif self.usereddit and not subreddit:
            subreddit = random.choice(self.meme_subreddits)
            r = requests.request("GET", f"https://reddit.com/r/{subreddit}/random.json", headers={"user-agent": self.agent}).json()
        elif not self.usereddit:
            return("Still in progress")
            raise SubredditNotFoundError("You didn't specify a subreddit")
class CachedDankMemeClient:
    """
    A client to get memes from various api's, but this uses caching to attempt to make it so you don't get repeat memes.


    Note: In it's current development phase, this is *very* slow, and takes up lots of RAM.
    """

