# -*- coding: utf-8; -*-
#
# This file is part of Superdesk.
#
# Copyright 2013 - 2018 Sourcefabric z.u. and contributors.
#
# For the full copyright and license information, please see the
# AUTHORS and LICENSE files distributed with this source code, or
# at https://www.sourcefabric.org/superdesk/license


from superdesk.io.feed_parsers.newsml_2_0 import NewsMLTwoFeedParser
from superdesk.tests import TestCase
from superdesk.etree import etree
import os


class BaseAPTestCase(TestCase):

    vocab = [{"_id": "genre", "items": [{"name": "Current"}]}]

    def setUp(self):
        with self.app.app_context():
            self.app.data.insert("vocabularies", self.vocab)
        dirname = os.path.dirname(os.path.realpath(__file__))
        fixture = os.path.normpath(os.path.join(dirname, "../fixtures", self.filename))
        provider = {"name": "Test"}
        with open(fixture, "rb") as f:
            self.root_elt = etree.fromstring(f.read())
            self.items = NewsMLTwoFeedParser().parse(self.root_elt, provider)


class APTestCase(BaseAPTestCase):
    filename = "ap.xml"

    def test_can_parse(self):
        self.assertTrue(NewsMLTwoFeedParser().can_parse(self.root_elt))

    def test_content(self):
        item = self.items[0]
        self.assertEqual(item["version"], "2")
        self.assertEqual(item["headline"], "Nutrisystem beats 4Q earnings and revenue expectations")
        self.assertEqual(item["slugline"], "BC-US--Earns-Nutrisystem, 1st Ld-Writethru")
        self.assertEqual(
            item["body_html"],
            "<p>FORT WASHINGTON, Pa. (AP) _ Nutrisystem Inc. (NTRI) on Monday reported"
            " fourth-quarter net income of $10.9 million.</p>\n              \n<p>On a"
            " per-share basis, the Fort Washington, Pennsylvania-based company said it"
            " had profit of 36 cents. Earnings, adjusted for non-recurring costs, were"
            " 42 cents per share.</p>\n              \n<p>The results beat Wall Street"
            " expectations. The average estimate of four analysts surveyed by Zacks In"
            "vestment Research was for earnings of 41 cents per share.</p>\n          "
            "    \n<p>The weight-loss company posted revenue of $131.2 million in the "
            "period, also exceeding Street forecasts. Four analysts surveyed by Zacks "
            "expected $129.1 million.</p>\n              \n<p>For the year, the compan"
            "y reported profit of $57.9 million, or $1.90 per share. Revenue was repor"
            "ted as $697 million.</p>\n              \n<p>For the current quarter endi"
            "ng in April, Nutrisystem said it expects revenue in the range of $204 mil"
            "lion to $209 million.</p>\n              \n<p>The company expects full-ye"
            "ar earnings to be $1.99 to $2.09 per share, with revenue ranging from $68"
            "5 million to $705 million.</p>\n              \n<p>Nutrisystem shares hav"
            "e decreased 24 percent since the beginning of the year. In the final minu"
            "tes of trading on Monday, shares hit $39.90, a climb of almost 5 percent "
            "in the last 12 months.</p>\n              \n<p>_____</p>\n              "
            "\n<p>This story was generated by Automated Insights (http://automatedinsig"
            "hts.com/ap) using data from Zacks Investment Research. Access a Zacks sto"
            "ck report on NTRI at https://www.zacks.com/ap/NTRI</p>\n            ",
        )
        self.assertEqual(item["guid"], "tag:ap.org,2011:5e565888b587889c5c8bd62b6164118c-text:2")
        self.assertEqual(item["firstcreated"].isoformat(), "2018-02-26T21:20:36+00:00")
