# Generated by Django 2.2.4 on 2019-08-08 05:02

import django.db.models.deletion
from django.db import migrations, models

import django_loose_fk.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="ZaakType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, verbose_name="name")),
            ],
            options={"verbose_name": "zaaktype", "verbose_name_plural": "zaaktypen"},
        ),
        migrations.CreateModel(
            name="Zaak",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, verbose_name="name")),
                ("extern_zaaktype", models.URLField(blank=True)),
                (
                    "zaaktype",
                    django_loose_fk.fields.FkOrURLField(
                        fk_field="_zaaktype", url_field="extern_zaaktype"
                    ),
                ),
                (
                    "_zaaktype",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="testapp.ZaakType",
                    ),
                ),
            ],
            options={"verbose_name": "zaak", "verbose_name_plural": "zaken"},
        ),
        migrations.CreateModel(
            name="DummyModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("extern_zaaktype1", models.URLField(blank=True)),
                (
                    "zaaktype1",
                    django_loose_fk.fields.FkOrURLField(
                        fk_field="_zaaktype1", url_field="extern_zaaktype1"
                    ),
                ),
                ("extern_zaaktype2", models.URLField(blank=True)),
                (
                    "zaaktype2",
                    django_loose_fk.fields.FkOrURLField(
                        fk_field="_zaaktype2", url_field="extern_zaaktype2"
                    ),
                ),
                (
                    "_zaaktype1",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="testapp.ZaakType",
                    ),
                ),
                (
                    "_zaaktype2",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="testapp.ZaakType",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="zaak",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        models.Q(_negated=True, _zaaktype__isnull=True),
                        ("extern_zaaktype", ""),
                    ),
                    models.Q(
                        ("_zaaktype__isnull", True),
                        models.Q(_negated=True, extern_zaaktype=""),
                    ),
                    _connector="OR",
                ),
                name="_zaaktype_or_extern_zaaktype_filled",
            ),
        ),
        migrations.AddConstraint(
            model_name="dummymodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        models.Q(_negated=True, _zaaktype1__isnull=True),
                        ("extern_zaaktype1", ""),
                    ),
                    models.Q(
                        ("_zaaktype1__isnull", True),
                        models.Q(_negated=True, extern_zaaktype1=""),
                    ),
                    _connector="OR",
                ),
                name="_zaaktype1_or_extern_zaaktype1_filled",
            ),
        ),
        migrations.AddConstraint(
            model_name="dummymodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        models.Q(_negated=True, _zaaktype2__isnull=True),
                        ("extern_zaaktype2", ""),
                    ),
                    models.Q(
                        ("_zaaktype2__isnull", True),
                        models.Q(_negated=True, extern_zaaktype2=""),
                    ),
                    _connector="OR",
                ),
                name="_zaaktype2_or_extern_zaaktype2_filled",
            ),
        ),
    ]
