# Generated by Django 2.2.4 on 2019-08-08 08:05

import django.db.models.deletion
from django.db import migrations, models

import django_loose_fk.fields


class Migration(migrations.Migration):

    dependencies = [("testapp", "0001_initial")]

    operations = [
        migrations.CreateModel(
            name="TypeA",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, verbose_name="name")),
            ],
        ),
        migrations.CreateModel(
            name="TypeB",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, verbose_name="name")),
                ("a_types", models.ManyToManyField(blank=True, to="testapp.TypeA")),
            ],
        ),
        migrations.CreateModel(
            name="B",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("remote_type", models.URLField(blank=True)),
                (
                    "type",
                    django_loose_fk.fields.FkOrURLField(
                        fk_field="local_type", url_field="remote_type"
                    ),
                ),
                (
                    "local_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="testapp.TypeB",
                    ),
                ),
            ],
        ),
        migrations.AddConstraint(
            model_name="b",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        models.Q(_negated=True, local_type__isnull=True),
                        ("remote_type", ""),
                    ),
                    models.Q(
                        ("local_type__isnull", True),
                        models.Q(_negated=True, remote_type=""),
                    ),
                    _connector="OR",
                ),
                name="local_type_or_remote_type_filled",
            ),
        ),
    ]
