import ast
import logging

logger = logging.getLogger("djangobuk_envsettings.conversion")


def none_or_str(v):
    try:
        return ast.literal_eval(v)
    except (ValueError, SyntaxError):
        logger.debug(f'cannot convert using `ast_literal_eval` switching to `str`')
        return str(v)


# todo cannot convert:
# LANGUAGES
MAPPING = {
    'ROOT_URLCONF': str,
    'SITE_ID': int,
    'SETTINGS_MODULE': str,

    'ABSOLUTE_URL_OVERRIDES': ast.literal_eval,
    'ADMINS': ast.literal_eval,
    'ALLOWED_HOSTS': ast.literal_eval,
    'APPEND_SLASH': ast.literal_eval,
    'AUTHENTICATION_BACKENDS': ast.literal_eval,
    'AUTH_PASSWORD_VALIDATORS': ast.literal_eval,
    'AUTH_USER_MODEL': str,
    'CACHES': ast.literal_eval,
    'CACHE_MIDDLEWARE_ALIAS': str,
    'CACHE_MIDDLEWARE_KEY_PREFIX': str,
    'CACHE_MIDDLEWARE_SECONDS': int,
    'CSRF_COOKIE_AGE': ast.literal_eval,
    'CSRF_COOKIE_DOMAIN': none_or_str,
    'CSRF_COOKIE_HTTPONLY': ast.literal_eval,
    'CSRF_COOKIE_NAME': str,
    'CSRF_COOKIE_PATH': str,
    'CSRF_COOKIE_SAMESITE': str,    # missleading doc https://docs.djangoproject.com/en/3.1/ref/settings/#session-cookie-samesite
    'CSRF_COOKIE_SECURE': ast.literal_eval,
    'CSRF_FAILURE_VIEW': str,
    'CSRF_HEADER_NAME': str,
    'CSRF_TRUSTED_ORIGINS': ast.literal_eval,
    'CSRF_USE_SESSIONS': ast.literal_eval,
    'DATABASES': ast.literal_eval,
    'DATABASE_ROUTERS': ast.literal_eval,
    'DATA_UPLOAD_MAX_MEMORY_SIZE': ast.literal_eval,
    'DATA_UPLOAD_MAX_NUMBER_FIELDS': ast.literal_eval,
    'DATETIME_FORMAT': str,
    'DATETIME_INPUT_FORMATS': ast.literal_eval,
    'DATE_FORMAT': str,
    'DATE_INPUT_FORMATS': ast.literal_eval,
    'DEBUG': ast.literal_eval,
    'DEBUG_PROPAGATE_EXCEPTIONS': ast.literal_eval,
    'DECIMAL_SEPARATOR': str,
    'DEFAULT_CHARSET': str,
    'DEFAULT_EXCEPTION_REPORTER_FILTER': str,
    'DEFAULT_FILE_STORAGE': str,
    'DEFAULT_FROM_EMAIL': str,
    'DEFAULT_INDEX_TABLESPACE': str,
    'DEFAULT_TABLESPACE': str,
    'DISALLOWED_USER_AGENTS': ast.literal_eval,
    'EMAIL_BACKEND': str,
    # EMAIL_FILE_PATH
    'EMAIL_HOST': str,
    'EMAIL_HOST_PASSWORD': str,
    'EMAIL_HOST_USER': str,
    'EMAIL_PORT': int,
    'EMAIL_SSL_CERTFILE': none_or_str,
    'EMAIL_SSL_KEYFILE': none_or_str,
    'EMAIL_SUBJECT_PREFIX': str,
    'EMAIL_TIMEOUT': ast.literal_eval,
    'EMAIL_USE_LOCALTIME': ast.literal_eval,
    'EMAIL_USE_SSL': ast.literal_eval,
    'EMAIL_USE_TLS': ast.literal_eval,
    'FILE_CHARSET': str,
    'FILE_UPLOAD_DIRECTORY_PERMISSIONS': ast.literal_eval,
    'FILE_UPLOAD_HANDLERS': ast.literal_eval,
    'FILE_UPLOAD_MAX_MEMORY_SIZE': ast.literal_eval,
    'FILE_UPLOAD_PERMISSIONS': ast.literal_eval,
    'FILE_UPLOAD_TEMP_DIR': none_or_str,
    'FIRST_DAY_OF_WEEK': int,
    'FIXTURE_DIRS': ast.literal_eval,
    'FORCE_SCRIPT_NAME': none_or_str,
    'FORMAT_MODULE_PATH': none_or_str,
    'FORM_RENDERER': str,
    'IGNORABLE_404_URLS': ast.literal_eval,
    'INSTALLED_APPS': ast.literal_eval,
    'INTERNAL_IPS': ast.literal_eval,
    'LANGUAGES': ast.literal_eval,
    'LANGUAGES_BIDI': ast.literal_eval,
    'LANGUAGE_CODE': str,
    'LANGUAGE_COOKIE_AGE': ast.literal_eval,
    'LANGUAGE_COOKIE_DOMAIN': none_or_str,
    'LANGUAGE_COOKIE_HTTPONLY': ast.literal_eval,
    'LANGUAGE_COOKIE_NAME': str,
    'LANGUAGE_COOKIE_PATH': str,
    'LANGUAGE_COOKIE_SAMESITE': none_or_str,
    'LANGUAGE_COOKIE_SECURE': ast.literal_eval,
    'LOCALE_PATHS': ast.literal_eval,
    'LOGGING': ast.literal_eval,
    'LOGGING_CONFIG': none_or_str,
    'LOGIN_REDIRECT_URL': str,
    'LOGIN_URL': str,
    'LOGOUT_REDIRECT_URL': none_or_str,
    'MANAGERS': ast.literal_eval,
    'MEDIA_ROOT': str,
    'MEDIA_URL': str,
    'MESSAGE_STORAGE': str,
    'MIDDLEWARE': ast.literal_eval,
    'MIGRATION_MODULES': ast.literal_eval,
    'MONTH_DAY_FORMAT': str,
    'NUMBER_GROUPING': ast.literal_eval,
    'PASSWORD_HASHERS': ast.literal_eval,
    'PASSWORD_RESET_TIMEOUT_DAYS': int,
    'PREPEND_WWW': ast.literal_eval,
    'SECRET_KEY': str,
    'SECURE_BROWSER_XSS_FILTER': ast.literal_eval,
    'SECURE_CONTENT_TYPE_NOSNIFF': ast.literal_eval,
    'SECURE_HSTS_INCLUDE_SUBDOMAINS': ast.literal_eval,
    'SECURE_HSTS_PRELOAD': ast.literal_eval,
    'SECURE_HSTS_SECONDS': int,
    'SECURE_PROXY_SSL_HEADER': ast.literal_eval,
    'SECURE_REDIRECT_EXEMPT': ast.literal_eval,
    'SECURE_REFERRER_POLICY': none_or_str,
    'SECURE_SSL_HOST': none_or_str,
    'SECURE_SSL_REDIRECT': ast.literal_eval,
    'SERVER_EMAIL': str,
    'SESSION_CACHE_ALIAS': str,
    'SESSION_COOKIE_AGE': int,
    'SESSION_COOKIE_DOMAIN': none_or_str,
    'SESSION_COOKIE_HTTPONLY': ast.literal_eval,
    'SESSION_COOKIE_NAME': str,
    'SESSION_COOKIE_PATH': str,
    'SESSION_COOKIE_SAMESITE': none_or_str,
    'SESSION_COOKIE_SECURE': ast.literal_eval,
    'SESSION_ENGINE': str,
    'SESSION_EXPIRE_AT_BROWSER_CLOSE': ast.literal_eval,
    'SESSION_FILE_PATH': none_or_str,
    'SESSION_SAVE_EVERY_REQUEST': ast.literal_eval,
    'SESSION_SERIALIZER': str,
    'SHORT_DATETIME_FORMAT': str,
    'SHORT_DATE_FORMAT': str,
    'SIGNING_BACKEND': str,
    'SILENCED_SYSTEM_CHECKS': ast.literal_eval,
    'STATICFILES_DIRS': ast.literal_eval,
    'STATICFILES_FINDERS': ast.literal_eval,
    'STATICFILES_STORAGE': str,
    'STATIC_ROOT': none_or_str,
    'STATIC_URL': none_or_str,
    'TEMPLATES': ast.literal_eval,
    'TEST_NON_SERIALIZED_APPS': ast.literal_eval,
    'TEST_RUNNER': str,
    'THOUSAND_SEPARATOR': str,
    'TIME_FORMAT': str,
    'TIME_INPUT_FORMATS': ast.literal_eval,
    'TIME_ZONE': str,   # todo can be verified
    'USE_I18N': ast.literal_eval,
    'USE_L10N': ast.literal_eval,
    'USE_THOUSAND_SEPARATOR': ast.literal_eval,
    'USE_TZ': ast.literal_eval,
    'USE_X_FORWARDED_HOST': ast.literal_eval,
    'USE_X_FORWARDED_PORT': ast.literal_eval,
    'WSGI_APPLICATION': none_or_str,
    'X_FRAME_OPTIONS': str,
    'YEAR_MONTH_FORMAT': str,
    'CSRF_COOKIE_MASKED': ast.literal_eval,
    'DEFAULT_AUTO_FIELD': str,
    'DEFAULT_EXCEPTION_REPORTER': str,
    'PASSWORD_RESET_TIMEOUT': int,
    'SECRET_KEY_FALLBACKS': ast.literal_eval,
    'SECURE_CROSS_ORIGIN_OPENER_POLICY': str,
    'USE_DEPRECATED_PYTZ': ast.literal_eval,
}
