"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
/**
 * An Amplify Console domain
 */
class Domain extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Domain);
            }
            throw error;
        }
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new aws_amplify_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: props.autoSubDomainIamRole?.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
        this.node.addValidation({ validate: () => this.validateDomain() });
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapSubDomain);
            }
            throw error;
        }
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapRoot);
            }
            throw error;
        }
        return this.mapSubDomain(branch, '');
    }
    validateDomain() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix ?? s.branch.branchName,
        }));
    }
}
exports.Domain = Domain;
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Domain", version: "2.48.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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