/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.AbstractProtobufList;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    public static final LazyStringList EMPTY;
    private final List<Object> list;

    static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int initialCapacity) {
        this(new ArrayList<Object>(initialCapacity));
    }

    public LazyStringArrayList(LazyStringList from) {
        this.list = new ArrayList<Object>(from.size());
        this.addAll(from);
    }

    public LazyStringArrayList(List<String> from) {
        this(new ArrayList<Object>(from));
    }

    private LazyStringArrayList(ArrayList<Object> list) {
        this.list = list;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int capacity) {
        if (capacity < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(capacity);
        arrayList.addAll(this.list);
        return new LazyStringArrayList(arrayList);
    }

    @Override
    public String get(int index) {
        Object object = this.list.get(index);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            String string = byteString.toStringUtf8();
            if (byteString.isValidUtf8()) {
                this.list.set(index, string);
            }
            return string;
        }
        byte[] byArray = (byte[])object;
        String string = Internal.toStringUtf8(byArray);
        if (Internal.isValidUtf8(byArray)) {
            this.list.set(index, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int index, String s2) {
        this.ensureIsMutable();
        Object object = this.list.set(index, s2);
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void add(int index, String element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, ByteString element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    private void add(int index, byte[] element) {
        this.ensureIsMutable();
        this.list.add(index, element);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> c2) {
        LazyStringArrayList lazyStringArrayList = this;
        return lazyStringArrayList.addAll(lazyStringArrayList.size(), c2);
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c2) {
        this.ensureIsMutable();
        Collection<? extends String> collection = c2 instanceof LazyStringList ? ((LazyStringList)c2).getUnderlyingElements() : c2;
        boolean bl = this.list.addAll(index, collection);
        ++this.modCount;
        return bl;
    }

    @Override
    public boolean addAllByteString(Collection<? extends ByteString> values) {
        this.ensureIsMutable();
        boolean bl = this.list.addAll(values);
        ++this.modCount;
        return bl;
    }

    @Override
    public boolean addAllByteArray(Collection<byte[]> c2) {
        this.ensureIsMutable();
        boolean bl = this.list.addAll(c2);
        ++this.modCount;
        return bl;
    }

    @Override
    public String remove(int index) {
        this.ensureIsMutable();
        Object object = this.list.remove(index);
        ++this.modCount;
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public void add(byte[] element) {
        this.ensureIsMutable();
        this.list.add(element);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int index) {
        return this.list.get(index);
    }

    @Override
    public ByteString getByteString(int index) {
        Object object = this.list.get(index);
        ByteString byteString = LazyStringArrayList.asByteString(object);
        if (byteString != object) {
            this.list.set(index, byteString);
        }
        return byteString;
    }

    @Override
    public byte[] getByteArray(int index) {
        Object object = this.list.get(index);
        byte[] byArray = LazyStringArrayList.asByteArray(object);
        if (byArray != object) {
            this.list.set(index, byArray);
        }
        return byArray;
    }

    @Override
    public void set(int index, ByteString s2) {
        this.setAndReturn(index, s2);
    }

    private Object setAndReturn(int index, ByteString s2) {
        this.ensureIsMutable();
        return this.list.set(index, s2);
    }

    @Override
    public void set(int index, byte[] s2) {
        this.setAndReturn(index, s2);
    }

    private Object setAndReturn(int index, byte[] s2) {
        this.ensureIsMutable();
        return this.list.set(index, s2);
    }

    private static String asString(Object o2) {
        if (o2 instanceof String) {
            return (String)o2;
        }
        if (o2 instanceof ByteString) {
            return ((ByteString)o2).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])o2);
    }

    private static ByteString asByteString(Object o2) {
        if (o2 instanceof ByteString) {
            return (ByteString)o2;
        }
        if (o2 instanceof String) {
            return ByteString.copyFromUtf8((String)o2);
        }
        return ByteString.copyFrom((byte[])o2);
    }

    private static byte[] asByteArray(Object o2) {
        if (o2 instanceof byte[]) {
            return (byte[])o2;
        }
        if (o2 instanceof String) {
            return Internal.toByteArray((String)o2);
        }
        return ((ByteString)o2).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void mergeFrom(LazyStringList other) {
        this.ensureIsMutable();
        for (Object obj : other.getUnderlyingElements()) {
            if (obj instanceof byte[]) {
                byte[] byArray = (byte[])obj;
                this.list.add(Arrays.copyOf(byArray, byArray.length));
                continue;
            }
            this.list.add(obj);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteStringListView(LazyStringArrayList list) {
            this.list = list;
        }

        @Override
        public ByteString get(int index) {
            return this.list.getByteString(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public ByteString set(int index, ByteString s2) {
            Object object = this.list.setAndReturn(index, s2);
            ++this.modCount;
            return LazyStringArrayList.asByteString(object);
        }

        @Override
        public void add(int index, ByteString s2) {
            this.list.add(index, s2);
            ++this.modCount;
        }

        @Override
        public ByteString remove(int index) {
            String string = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteString(string);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteArrayListView(LazyStringArrayList list) {
            this.list = list;
        }

        @Override
        public byte[] get(int index) {
            return this.list.getByteArray(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public byte[] set(int index, byte[] s2) {
            Object object = this.list.setAndReturn(index, s2);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(object);
        }

        @Override
        public void add(int index, byte[] s2) {
            this.list.add(index, s2);
            ++this.modCount;
        }

        @Override
        public byte[] remove(int index) {
            String string = this.list.remove(index);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(string);
        }
    }
}

