/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.GeneratedMessage;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.Message;
import ai.h2o.com.google.protobuf.MessageOrBuilder;
import ai.h2o.com.google.protobuf.SingleFieldBuilder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RepeatedFieldBuilder<MType extends GeneratedMessage, BType extends GeneratedMessage.Builder, IType extends MessageOrBuilder>
implements GeneratedMessage.BuilderParent {
    private GeneratedMessage.BuilderParent parent;
    private List<MType> messages;
    private boolean isMessagesListMutable;
    private List<SingleFieldBuilder<MType, BType, IType>> builders;
    private boolean isClean;
    private MessageExternalList<MType, BType, IType> externalMessageList;
    private BuilderExternalList<MType, BType, IType> externalBuilderList;
    private MessageOrBuilderExternalList<MType, BType, IType> externalMessageOrBuilderList;

    public RepeatedFieldBuilder(List<MType> messages, boolean isMessagesListMutable, GeneratedMessage.BuilderParent parent, boolean isClean) {
        this.messages = messages;
        this.isMessagesListMutable = isMessagesListMutable;
        this.parent = parent;
        this.isClean = isClean;
    }

    public void dispose() {
        this.parent = null;
    }

    private void ensureMutableMessageList() {
        if (!this.isMessagesListMutable) {
            this.messages = new ArrayList<MType>(this.messages);
            this.isMessagesListMutable = true;
        }
    }

    private void ensureBuilders() {
        if (this.builders == null) {
            this.builders = new ArrayList<SingleFieldBuilder<MType, BType, IType>>(this.messages.size());
            for (int i2 = 0; i2 < this.messages.size(); ++i2) {
                this.builders.add(null);
            }
        }
    }

    public int getCount() {
        return this.messages.size();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public MType getMessage(int index) {
        return this.getMessage(index, false);
    }

    private MType getMessage(int index, boolean forBuild) {
        if (this.builders == null) {
            return (MType)((GeneratedMessage)this.messages.get(index));
        }
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(index);
        if (singleFieldBuilder == null) {
            return (MType)((GeneratedMessage)this.messages.get(index));
        }
        if (forBuild) {
            return singleFieldBuilder.build();
        }
        return singleFieldBuilder.getMessage();
    }

    public BType getBuilder(int index) {
        this.ensureBuilders();
        SingleFieldBuilder<Object, BType, IType> singleFieldBuilder = this.builders.get(index);
        if (singleFieldBuilder == null) {
            GeneratedMessage generatedMessage = (GeneratedMessage)this.messages.get(index);
            RepeatedFieldBuilder repeatedFieldBuilder = this;
            singleFieldBuilder = new SingleFieldBuilder(generatedMessage, repeatedFieldBuilder, repeatedFieldBuilder.isClean);
            this.builders.set(index, singleFieldBuilder);
        }
        return singleFieldBuilder.getBuilder();
    }

    public IType getMessageOrBuilder(int index) {
        if (this.builders == null) {
            return (IType)((MessageOrBuilder)this.messages.get(index));
        }
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(index);
        if (singleFieldBuilder == null) {
            return (IType)((MessageOrBuilder)this.messages.get(index));
        }
        return singleFieldBuilder.getMessageOrBuilder();
    }

    public RepeatedFieldBuilder<MType, BType, IType> setMessage(int index, MType message) {
        SingleFieldBuilder singleFieldBuilder;
        Internal.checkNotNull(message);
        this.ensureMutableMessageList();
        this.messages.set(index, message);
        if (this.builders != null && (singleFieldBuilder = (SingleFieldBuilder)this.builders.set(index, null)) != null) {
            singleFieldBuilder.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addMessage(MType message) {
        Internal.checkNotNull(message);
        this.ensureMutableMessageList();
        this.messages.add(message);
        if (this.builders != null) {
            this.builders.add(null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addMessage(int index, MType message) {
        Internal.checkNotNull(message);
        this.ensureMutableMessageList();
        this.messages.add(index, message);
        if (this.builders != null) {
            this.builders.add(index, null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public RepeatedFieldBuilder<MType, BType, IType> addAllMessages(Iterable<? extends MType> values) {
        for (Object object : values) {
            Internal.checkNotNull(object);
        }
        int n2 = -1;
        if (values instanceof Collection) {
            Object object;
            object = (Collection)values;
            if (object.size() == 0) {
                return this;
            }
            n2 = object.size();
        }
        this.ensureMutableMessageList();
        if (n2 >= 0 && this.messages instanceof ArrayList) {
            ((ArrayList)this.messages).ensureCapacity(this.messages.size() + n2);
        }
        for (GeneratedMessage generatedMessage : values) {
            this.addMessage(generatedMessage);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    public BType addBuilder(MType message) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        RepeatedFieldBuilder repeatedFieldBuilder = this;
        SingleFieldBuilder singleFieldBuilder = new SingleFieldBuilder(message, repeatedFieldBuilder, repeatedFieldBuilder.isClean);
        this.messages.add(null);
        this.builders.add(singleFieldBuilder);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilder.getBuilder();
    }

    public BType addBuilder(int index, MType message) {
        this.ensureMutableMessageList();
        this.ensureBuilders();
        RepeatedFieldBuilder repeatedFieldBuilder = this;
        SingleFieldBuilder singleFieldBuilder = new SingleFieldBuilder(message, repeatedFieldBuilder, repeatedFieldBuilder.isClean);
        this.messages.add(index, null);
        this.builders.add(index, singleFieldBuilder);
        this.onChanged();
        this.incrementModCounts();
        return singleFieldBuilder.getBuilder();
    }

    public void remove(int index) {
        SingleFieldBuilder<MType, BType, IType> singleFieldBuilder;
        this.ensureMutableMessageList();
        this.messages.remove(index);
        if (this.builders != null && (singleFieldBuilder = this.builders.remove(index)) != null) {
            singleFieldBuilder.dispose();
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public void clear() {
        this.messages = Collections.emptyList();
        this.isMessagesListMutable = false;
        if (this.builders != null) {
            for (SingleFieldBuilder<MType, BType, IType> singleFieldBuilder : this.builders) {
                if (singleFieldBuilder == null) continue;
                singleFieldBuilder.dispose();
            }
            this.builders = null;
        }
        this.onChanged();
        this.incrementModCounts();
    }

    public List<MType> build() {
        int n2;
        this.isClean = true;
        if (!this.isMessagesListMutable && this.builders == null) {
            return this.messages;
        }
        boolean bl = true;
        if (!this.isMessagesListMutable) {
            for (n2 = 0; n2 < this.messages.size(); ++n2) {
                Message message = (Message)this.messages.get(n2);
                SingleFieldBuilder<MType, BType, IType> singleFieldBuilder = this.builders.get(n2);
                if (singleFieldBuilder == null || singleFieldBuilder.build() == message) continue;
                bl = false;
                break;
            }
            if (bl) {
                return this.messages;
            }
        }
        this.ensureMutableMessageList();
        for (n2 = 0; n2 < this.messages.size(); ++n2) {
            this.messages.set(n2, this.getMessage(n2, true));
        }
        this.messages = Collections.unmodifiableList(this.messages);
        this.isMessagesListMutable = false;
        return this.messages;
    }

    public List<MType> getMessageList() {
        if (this.externalMessageList == null) {
            this.externalMessageList = new MessageExternalList(this);
        }
        return this.externalMessageList;
    }

    public List<BType> getBuilderList() {
        if (this.externalBuilderList == null) {
            this.externalBuilderList = new BuilderExternalList(this);
        }
        return this.externalBuilderList;
    }

    public List<IType> getMessageOrBuilderList() {
        if (this.externalMessageOrBuilderList == null) {
            this.externalMessageOrBuilderList = new MessageOrBuilderExternalList(this);
        }
        return this.externalMessageOrBuilderList;
    }

    private void onChanged() {
        if (this.isClean && this.parent != null) {
            this.parent.markDirty();
            this.isClean = false;
        }
    }

    @Override
    public void markDirty() {
        this.onChanged();
    }

    private void incrementModCounts() {
        if (this.externalMessageList != null) {
            this.externalMessageList.incrementModCount();
        }
        if (this.externalBuilderList != null) {
            this.externalBuilderList.incrementModCount();
        }
        if (this.externalMessageOrBuilderList != null) {
            this.externalMessageOrBuilderList.incrementModCount();
        }
    }

    private static class MessageOrBuilderExternalList<MType extends GeneratedMessage, BType extends GeneratedMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<IType>
    implements List<IType> {
        RepeatedFieldBuilder<MType, BType, IType> builder;

        MessageOrBuilderExternalList(RepeatedFieldBuilder<MType, BType, IType> builder) {
            this.builder = builder;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public IType get(int index) {
            return this.builder.getMessageOrBuilder(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class BuilderExternalList<MType extends GeneratedMessage, BType extends GeneratedMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<BType>
    implements List<BType> {
        RepeatedFieldBuilder<MType, BType, IType> builder;

        BuilderExternalList(RepeatedFieldBuilder<MType, BType, IType> builder) {
            this.builder = builder;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public BType get(int index) {
            return this.builder.getBuilder(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }

    private static class MessageExternalList<MType extends GeneratedMessage, BType extends GeneratedMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<MType>
    implements List<MType> {
        RepeatedFieldBuilder<MType, BType, IType> builder;

        MessageExternalList(RepeatedFieldBuilder<MType, BType, IType> builder) {
            this.builder = builder;
        }

        @Override
        public int size() {
            return this.builder.getCount();
        }

        @Override
        public MType get(int index) {
            return this.builder.getMessage(index);
        }

        void incrementModCount() {
            ++this.modCount;
        }
    }
}

