/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HashUtils {
    private final int _shiftNBits;

    public HashUtils() {
        this(0);
    }

    public HashUtils(int shiftNBits) {
        assert (shiftNBits >= 0) : "Cannot shift bits by a negative amount";
        this._shiftNBits = shiftNBits;
    }

    public long hash(byte val) {
        return (long)val & 0xFFL;
    }

    public long hash(int val) {
        return (long)val & 0xFFFFFFFFL;
    }

    public long hash(long val) {
        return val;
    }

    public long hash(float val) {
        return Double.doubleToRawLongBits(val) >>> this._shiftNBits;
    }

    public long hash(double val) {
        return Double.doubleToRawLongBits(val) >>> this._shiftNBits;
    }

    public long hash(String val) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(ByteOrder.nativeOrder());
        if (val == null) {
            return 0L;
        }
        byte[] byArray = val.getBytes();
        long l2 = (long)byArray.length * -4132994306676758123L;
        int n2 = byArray.length / 8 << 3;
        for (int i2 = 0; i2 != n2; i2 += 8) {
            byteBuffer.put(0, byArray[i2]);
            byteBuffer.put(1, byArray[i2 + 1]);
            byteBuffer.put(2, byArray[i2 + 2]);
            byteBuffer.put(3, byArray[i2 + 3]);
            byteBuffer.put(4, byArray[i2 + 4]);
            byteBuffer.put(5, byArray[i2 + 5]);
            byteBuffer.put(6, byArray[i2 + 6]);
            byteBuffer.put(7, byArray[i2 + 7]);
            long l3 = byteBuffer.getLong(0);
            l3 *= -4132994306676758123L;
            l3 ^= l3 >>> 47;
            l2 ^= (l3 *= -4132994306676758123L);
            l2 *= -4132994306676758123L;
        }
        switch (byArray.length & 7) {
            case 7: {
                l2 ^= ((long)byArray[n2 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l2 ^= ((long)byArray[n2 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l2 ^= ((long)byArray[n2 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l2 ^= ((long)byArray[n2 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l2 ^= ((long)byArray[n2 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l2 ^= ((long)byArray[n2 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l2 ^= (long)byArray[n2] & 0xFFL;
                l2 *= -4132994306676758123L;
            }
        }
        long l4 = l2;
        l2 = l4 ^ l4 >>> 47;
        l2 *= -4132994306676758123L;
        l2 ^= l2 >>> 47;
        return l2;
    }
}

