/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OBinomialMetrics;
import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all binomial metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\f\u0018\u0001\tB\u0001B\u000b\u0001\u0003\u0006\u0004%\te\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005Y!)!\b\u0001C\u0001w!)!\b\u0001C\u0001}!9q\b\u0001b\u0001\n#\u0001\u0005B\u0002(\u0001A\u0003%\u0011\tC\u0004P\u0001\t\u0007I\u0011\u0003!\t\rA\u0003\u0001\u0015!\u0003B\u0011\u001d\t\u0006A1A\u0005\u0012\u0001CaA\u0015\u0001!\u0002\u0013\t\u0005bB*\u0001\u0005\u0004%\t\u0002\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\t)\"1!\f\u0001Q\u0001\nUCQa\u0017\u0001\u0005\u0002qCQ!\u0019\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002qCQa\u0019\u0001\u0005\u0002\u0011DQ\u0001\u001b\u0001\u0005\u0002\u0011DQ!\u001b\u0001\u0005B)DQ\u0001 \u0001\u0005Bu\u0014Q\u0003\u0013\u001aP\u0005&tw.\\5bY\u001ecU*T3ue&\u001c7O\u0003\u0002\u00193\u00059Q.\u001a;sS\u000e\u001c(B\u0001\u000e\u001c\u0003\tiGN\u0003\u0002\u001d;\u0005I1\u000f]1sW2Lgn\u001a\u0006\u0003=}\t1\u0001\u001b\u001ap\u0015\u0005\u0001\u0013AA1j\u0007\u0001\u00192\u0001A\u0012(!\t!S%D\u0001\u0018\u0013\t1sC\u0001\nIe=\u0013\u0015N\\8nS\u0006dW*\u001a;sS\u000e\u001c\bC\u0001\u0013)\u0013\tIsCA\u0007Ie=;E*T'fiJL7m]\u0001\u0004k&$W#\u0001\u0017\u0011\u000552dB\u0001\u00185!\ty#'D\u00011\u0015\t\t\u0014%\u0001\u0004=e>|GO\u0010\u0006\u0002g\u0005)1oY1mC&\u0011QGM\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026e\u0005!Q/\u001b3!\u0003\u0019a\u0014N\\5u}Q\u0011A(\u0010\t\u0003I\u0001AQAK\u0002A\u00021\"\u0012\u0001P\u0001\u0011e\u0016\u001c\u0018\u000eZ;bY\u0012+g/[1oG\u0016,\u0012!\u0011\t\u0003\u00052k\u0011a\u0011\u0006\u0003\t\u0016\u000bQ\u0001]1sC6T!A\u0007$\u000b\u0005\u001dC\u0015!B:qCJ\\'BA%K\u0003\u0019\t\u0007/Y2iK*\t1*A\u0002pe\u001eL!!T\"\u0003\u0017\u0011{WO\u00197f!\u0006\u0014\u0018-\\\u0001\u0012e\u0016\u001c\u0018\u000eZ;bY\u0012+g/[1oG\u0016\u0004\u0013\u0001\u00048vY2$UM^5b]\u000e,\u0017!\u00048vY2$UM^5b]\u000e,\u0007%A\u0002bS\u000e\fA!Y5dA\u0005!b.\u001e7m\t\u0016<'/Z3t\u001f\u001a4%/Z3e_6,\u0012!\u0016\t\u0003\u0005ZK!aV\"\u0003\u00131{gn\u001a)be\u0006l\u0017!\u00068vY2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000eI\u0001\u0019e\u0016\u001c\u0018\u000eZ;bY\u0012+wM]3fg>3gI]3fI>l\u0017!\u0007:fg&$W/\u00197EK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\u0002\n1cZ3u%\u0016\u001c\u0018\u000eZ;bY\u0012+g/[1oG\u0016$\u0012!\u0018\t\u0003=~k\u0011AM\u0005\u0003AJ\u0012a\u0001R8vE2,\u0017aD4fi:+H\u000e\u001c#fm&\fgnY3\u0002\r\u001d,G/Q%D\u0003]9W\r\u001e(vY2$Um\u001a:fKN|eM\u0012:fK\u0012|W\u000eF\u0001f!\tqf-\u0003\u0002he\t!Aj\u001c8h\u0003m9W\r\u001e*fg&$W/\u00197EK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\u0006Q1/\u001a;NKR\u0014\u0018nY:\u0015\u0007-t'\u0010\u0005\u0002_Y&\u0011QN\r\u0002\u0005+:LG\u000fC\u0003p)\u0001\u0007\u0001/\u0001\u0003kg>t\u0007CA9y\u001b\u0005\u0011(BA:u\u0003\u001197o\u001c8\u000b\u0005U4\u0018AB4p_\u001edWMC\u0001x\u0003\r\u0019w.\\\u0005\u0003sJ\u0014!BS:p]>\u0013'.Z2u\u0011\u0015YH\u00031\u0001-\u0003\u001d\u0019wN\u001c;fqR\fAaY8qsR\u0011ap`\u0007\u0002\u0001!9\u0011\u0011A\u000bA\u0002\u0005\r\u0011!B3yiJ\f\u0007c\u0001\"\u0002\u0006%\u0019\u0011qA\"\u0003\u0011A\u000b'/Y7NCBDs\u0001AA\u0006\u0003#\t\u0019\u0002E\u0002%\u0003\u001bI1!a\u0004\u0018\u0005IiU\r\u001e:jGN$Um]2sSB$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003+\t!\n\u00165fA\rd\u0017m]:![\u0006\\Wm\u001d\u0011bm\u0006LG.\u00192mK\u0002\nG\u000e\u001c\u0011cS:|W.[1mA5,GO]5dg\u0002\u001aX\u000f\u001d9peR,G\r\t2zA\u001dcU\nI1mO>\u0014\u0018\u000e\u001e5n]\u0001")
public class H2OBinomialGLMMetrics
extends H2OBinomialMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block47: {
            Params params;
            block44: {
                block43: {
                    Params params2;
                    block40: {
                        block39: {
                            Params params3;
                            block36: {
                                block35: {
                                    Params params4;
                                    block32: {
                                        super.setMetrics(json, context);
                                        if (!json.has("residual_deviance")) break block32;
                                        try {
                                            params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2;
                                            block34: {
                                                block33: {
                                                    Throwable throwable3 = throwable;
                                                    if (throwable3 == null) break block33;
                                                    throwable2 = throwable3;
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string2 = "true";
                                                    if (string == null ? string2 != null : !string.equals(string2)) break block34;
                                                }
                                                throw throwable;
                                            }
                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Unsuccessful try to extract 'residual_deviance' from ").append(context).toString(), throwable2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            params4 = boxedUnit;
                                        }
                                        break block35;
                                    }
                                    String message = new StringBuilder(50).append("The metric 'residual_deviance' in ").append(context).append(" does not exist.").toString();
                                    String string = System.getProperty("spark.testing", "false");
                                    String string3 = "true";
                                    if (!(string == null ? string3 != null : !string.equals(string3))) {
                                        throw new AssertionError((Object)message);
                                    }
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                    params4 = BoxedUnit.UNIT;
                                }
                                if (!json.has("null_deviance")) break block36;
                                try {
                                    params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable4;
                                    block38: {
                                        block37: {
                                            Throwable throwable5 = throwable;
                                            if (throwable5 == null) break block37;
                                            throwable4 = throwable5;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string4 = "true";
                                            if (string == null ? string4 != null : !string.equals(string4)) break block38;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Unsuccessful try to extract 'null_deviance' from ").append(context).toString(), throwable4);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block39;
                            }
                            String message = new StringBuilder(46).append("The metric 'null_deviance' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string5 = "true";
                            if (!(string == null ? string5 != null : !string.equals(string5))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("AIC")) break block40;
                        try {
                            params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable6;
                            block42: {
                                block41: {
                                    Throwable throwable7 = throwable;
                                    if (throwable7 == null) break block41;
                                    throwable6 = throwable7;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string6 = "true";
                                    if (string == null ? string6 != null : !string.equals(string6)) break block42;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Unsuccessful try to extract 'AIC' from ").append(context).toString(), throwable6);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block43;
                    }
                    String message = new StringBuilder(36).append("The metric 'AIC' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string7 = "true";
                    if (!(string == null ? string7 != null : !string.equals(string7))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("null_degrees_of_freedom")) break block44;
                try {
                    params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
                }
                catch (Throwable throwable) {
                    Throwable throwable8;
                    block46: {
                        block45: {
                            Throwable throwable9 = throwable;
                            if (throwable9 == null) break block45;
                            throwable8 = throwable9;
                            String string = System.getProperty("spark.testing", "false");
                            String string8 = "true";
                            if (string == null ? string8 != null : !string.equals(string8)) break block46;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Unsuccessful try to extract 'null_degrees_of_freedom' from ").append(context).toString(), throwable8);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block47;
            }
            String message = new StringBuilder(56).append("The metric 'null_degrees_of_freedom' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (!(string == null ? string9 != null : !string.equals(string9))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 != null) {
                    Throwable throwable11 = throwable10;
                    String string = System.getProperty("spark.testing", "false");
                    String string10 = "true";
                    if (string == null ? string10 != null : !string.equals(string10)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append(context).toString(), throwable11);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(60).append("The metric 'residual_degrees_of_freedom' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null ? string11 != null : !string.equals(string11)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OBinomialGLMMetrics copy(ParamMap extra) {
        return (H2OBinomialGLMMetrics)this.defaultCopy(extra);
    }

    public H2OBinomialGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OBinomialGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OBinomialGLMMetrics"));
    }
}

