/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.H2OMultinomialMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all multinomial metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\f\u0018\u0001\tB\u0001B\u000b\u0001\u0003\u0006\u0004%\te\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005Y!)!\b\u0001C\u0001w!)!\b\u0001C\u0001}!9q\b\u0001b\u0001\n#\u0001\u0005B\u0002(\u0001A\u0003%\u0011\tC\u0004P\u0001\t\u0007I\u0011\u0003!\t\rA\u0003\u0001\u0015!\u0003B\u0011\u001d\t\u0006A1A\u0005\u0012\u0001CaA\u0015\u0001!\u0002\u0013\t\u0005bB*\u0001\u0005\u0004%\t\u0002\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\t)\"1!\f\u0001Q\u0001\nUCQa\u0017\u0001\u0005\u0002qCQ!\u0019\u0001\u0005\u0002qCQA\u0019\u0001\u0005\u0002qCQa\u0019\u0001\u0005\u0002\u0011DQ\u0001\u001b\u0001\u0005\u0002\u0011DQ!\u001b\u0001\u0005B)DQ\u0001 \u0001\u0005Bu\u0014\u0001\u0004\u0013\u001aP\u001bVdG/\u001b8p[&\fGn\u0012'N\u001b\u0016$(/[2t\u0015\tA\u0012$A\u0004nKR\u0014\u0018nY:\u000b\u0005iY\u0012AA7m\u0015\taR$A\u0005ta\u0006\u00148\u000e\\5oO*\u0011adH\u0001\u0004QJz'\"\u0001\u0011\u0002\u0005\u0005L7\u0001A\n\u0004\u0001\r:\u0003C\u0001\u0013&\u001b\u00059\u0012B\u0001\u0014\u0018\u0005UA%gT'vYRLgn\\7jC2lU\r\u001e:jGN\u0004\"\u0001\n\u0015\n\u0005%:\"!\u0004%3\u001f\u001ecU*T3ue&\u001c7/A\u0002vS\u0012,\u0012\u0001\f\t\u0003[Yr!A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\n\u0013A\u0002\u001fs_>$hHC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$'\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b3\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\taT\b\u0005\u0002%\u0001!)!f\u0001a\u0001YQ\tA(\u0001\tsKNLG-^1m\t\u00164\u0018.\u00198dKV\t\u0011\t\u0005\u0002C\u00196\t1I\u0003\u0002E\u000b\u0006)\u0001/\u0019:b[*\u0011!D\u0012\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO&\u0011Qj\u0011\u0002\f\t>,(\r\\3QCJ\fW.A\tsKNLG-^1m\t\u00164\u0018.\u00198dK\u0002\nAB\\;mY\u0012+g/[1oG\u0016\fQB\\;mY\u0012+g/[1oG\u0016\u0004\u0013aA1jG\u0006!\u0011-[2!\u0003QqW\u000f\u001c7EK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[V\tQ\u000b\u0005\u0002C-&\u0011qk\u0011\u0002\n\u0019>tw\rU1sC6\fQC\\;mY\u0012+wM]3fg>3gI]3fI>l\u0007%\u0001\rsKNLG-^1m\t\u0016<'/Z3t\u001f\u001a4%/Z3e_6\f\u0011D]3tS\u0012,\u0018\r\u001c#fOJ,Wm](g\rJ,W\rZ8nA\u0005\u0019r-\u001a;SKNLG-^1m\t\u00164\u0018.\u00198dKR\tQ\f\u0005\u0002_?6\t!'\u0003\u0002ae\t1Ai\\;cY\u0016\fqbZ3u\u001dVdG\u000eR3wS\u0006t7-Z\u0001\u0007O\u0016$\u0018)S\"\u0002/\u001d,GOT;mY\u0012+wM]3fg>3gI]3fI>lG#A3\u0011\u0005y3\u0017BA43\u0005\u0011auN\\4\u00027\u001d,GOU3tS\u0012,\u0018\r\u001c#fOJ,Wm](g\rJ,W\rZ8n\u0003)\u0019X\r^'fiJL7m\u001d\u000b\u0004W:T\bC\u00010m\u0013\ti'G\u0001\u0003V]&$\b\"B8\u0015\u0001\u0004\u0001\u0018\u0001\u00026t_:\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\t\u001d\u001cxN\u001c\u0006\u0003kZ\faaZ8pO2,'\"A<\u0002\u0007\r|W.\u0003\u0002ze\nQ!j]8o\u001f\nTWm\u0019;\t\u000bm$\u0002\u0019\u0001\u0017\u0002\u000f\r|g\u000e^3yi\u0006!1m\u001c9z)\tqx0D\u0001\u0001\u0011\u001d\t\t!\u0006a\u0001\u0003\u0007\tQ!\u001a=ue\u0006\u00042AQA\u0003\u0013\r\t9a\u0011\u0002\t!\u0006\u0014\u0018-\\'ba\":\u0001!a\u0003\u0002\u0012\u0005M\u0001c\u0001\u0013\u0002\u000e%\u0019\u0011qB\f\u0003%5+GO]5dg\u0012+7o\u0019:jaRLwN\\\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002\u0016\u0005iE\u000b[3!G2\f7o\u001d\u0011nC.,7\u000fI1wC&d\u0017M\u00197fA\u0005dG\u000eI7vYRLgn\\7jC2\u0004S.\u001a;sS\u000e\u001c\be];qa>\u0014H/\u001a3!Ef\u0004s\tT'!C2<wN]5uQ6t\u0003")
public class H2OMultinomialGLMMetrics
extends H2OMultinomialMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block47: {
            Params params;
            block44: {
                block43: {
                    Params params2;
                    block40: {
                        block39: {
                            Params params3;
                            block36: {
                                block35: {
                                    Params params4;
                                    block32: {
                                        super.setMetrics(json, context);
                                        if (!json.has("residual_deviance")) break block32;
                                        try {
                                            params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable2;
                                            block34: {
                                                block33: {
                                                    Throwable throwable3 = throwable;
                                                    if (throwable3 == null) break block33;
                                                    throwable2 = throwable3;
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string2 = "true";
                                                    if (string == null ? string2 != null : !string.equals(string2)) break block34;
                                                }
                                                throw throwable;
                                            }
                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Unsuccessful try to extract 'residual_deviance' from ").append(context).toString(), throwable2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            params4 = boxedUnit;
                                        }
                                        break block35;
                                    }
                                    String message = new StringBuilder(50).append("The metric 'residual_deviance' in ").append(context).append(" does not exist.").toString();
                                    String string = System.getProperty("spark.testing", "false");
                                    String string3 = "true";
                                    if (!(string == null ? string3 != null : !string.equals(string3))) {
                                        throw new AssertionError((Object)message);
                                    }
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                    params4 = BoxedUnit.UNIT;
                                }
                                if (!json.has("null_deviance")) break block36;
                                try {
                                    params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable4;
                                    block38: {
                                        block37: {
                                            Throwable throwable5 = throwable;
                                            if (throwable5 == null) break block37;
                                            throwable4 = throwable5;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string4 = "true";
                                            if (string == null ? string4 != null : !string.equals(string4)) break block38;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Unsuccessful try to extract 'null_deviance' from ").append(context).toString(), throwable4);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block39;
                            }
                            String message = new StringBuilder(46).append("The metric 'null_deviance' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string5 = "true";
                            if (!(string == null ? string5 != null : !string.equals(string5))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("AIC")) break block40;
                        try {
                            params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable6;
                            block42: {
                                block41: {
                                    Throwable throwable7 = throwable;
                                    if (throwable7 == null) break block41;
                                    throwable6 = throwable7;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string6 = "true";
                                    if (string == null ? string6 != null : !string.equals(string6)) break block42;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Unsuccessful try to extract 'AIC' from ").append(context).toString(), throwable6);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block43;
                    }
                    String message = new StringBuilder(36).append("The metric 'AIC' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string7 = "true";
                    if (!(string == null ? string7 != null : !string.equals(string7))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("null_degrees_of_freedom")) break block44;
                try {
                    params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
                }
                catch (Throwable throwable) {
                    Throwable throwable8;
                    block46: {
                        block45: {
                            Throwable throwable9 = throwable;
                            if (throwable9 == null) break block45;
                            throwable8 = throwable9;
                            String string = System.getProperty("spark.testing", "false");
                            String string8 = "true";
                            if (string == null ? string8 != null : !string.equals(string8)) break block46;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Unsuccessful try to extract 'null_degrees_of_freedom' from ").append(context).toString(), throwable8);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block47;
            }
            String message = new StringBuilder(56).append("The metric 'null_degrees_of_freedom' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (!(string == null ? string9 != null : !string.equals(string9))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 != null) {
                    Throwable throwable11 = throwable10;
                    String string = System.getProperty("spark.testing", "false");
                    String string10 = "true";
                    if (string == null ? string10 != null : !string.equals(string10)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append(context).toString(), throwable11);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(60).append("The metric 'residual_degrees_of_freedom' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null ? string11 != null : !string.equals(string11)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OMultinomialGLMMetrics copy(ParamMap extra) {
        return (H2OMultinomialGLMMetrics)this.defaultCopy(extra);
    }

    public H2OMultinomialGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OMultinomialGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OMultinomialGLMMetrics"));
    }
}

