/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OCommonMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import ai.h2o.sparkling.ml.params.NullableDataFrameParam;
import ai.h2o.sparkling.utils.DataFrameSerializationWrappers$;
import com.google.gson.JsonObject;
import java.io.Serializable;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all metrics that shared across all algorithms supporting multinomial classification.")
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001\u0002\u0012$\u00019B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0005\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005k!)1\t\u0001C\u0001\t\")1\t\u0001C\u0001\u000f\"9\u0001\n\u0001b\u0001\n#I\u0005BB,\u0001A\u0003%!\nC\u0004Y\u0001\t\u0007I\u0011C-\t\r\u0001\u0004\u0001\u0015!\u0003[\u0011\u001d\t\u0007A1A\u0005\u0012eCaA\u0019\u0001!\u0002\u0013Q\u0006bB2\u0001\u0005\u0004%\t\"\u0013\u0005\u0007I\u0002\u0001\u000b\u0011\u0002&\t\u000f\u0015\u0004!\u0019!C\t\u0013\"1a\r\u0001Q\u0001\n)Cqa\u001a\u0001C\u0002\u0013E\u0011\n\u0003\u0004i\u0001\u0001\u0006IA\u0013\u0005\bS\u0002\u0011\r\u0011\"\u0005J\u0011\u0019Q\u0007\u0001)A\u0005\u0015\"91\u000e\u0001b\u0001\n#I\u0006B\u00027\u0001A\u0003%!\fC\u0004n\u0001\t\u0007I\u0011C-\t\r9\u0004\u0001\u0015!\u0003[\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0001w\u0011\u0019\t\t\u0002\u0001C\u0001m\"1\u00111\u0003\u0001\u0005\u0002ADa!!\u0006\u0001\t\u0003\u0001\bBBA\f\u0001\u0011\u0005\u0001\u000f\u0003\u0004\u0002\u001a\u0001!\t\u0001\u001d\u0005\u0007\u00037\u0001A\u0011\u0001<\t\r\u0005u\u0001\u0001\"\u0001w\u0011\u001d\ty\u0002\u0001C!\u0003CAq!!\u0012\u0001\t\u0003\n9EA\u000bIe=kU\u000f\u001c;j]>l\u0017.\u00197NKR\u0014\u0018nY:\u000b\u0005\u0011*\u0013aB7fiJL7m\u001d\u0006\u0003M\u001d\n!!\u001c7\u000b\u0005!J\u0013!C:qCJ\\G.\u001b8h\u0015\tQ3&A\u0002ie=T\u0011\u0001L\u0001\u0003C&\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001'M\u0007\u0002G%\u0011!g\t\u0002\u0011\u0011Jz5i\\7n_:lU\r\u001e:jGN\f1!^5e+\u0005)\u0004C\u0001\u001c@\u001d\t9T\b\u0005\u00029w5\t\u0011H\u0003\u0002;[\u00051AH]8pizR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ahO\u0001\u0005k&$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\u000b\u001a\u0003\"\u0001\r\u0001\t\u000bM\u001a\u0001\u0019A\u001b\u0015\u0003\u0015\u000b!A\u001d\u001a\u0016\u0003)\u0003\"aS+\u000e\u00031S!!\u0014(\u0002\u000bA\f'/Y7\u000b\u0005\u0019z%B\u0001)R\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Yc%a\u0003#pk\ndW\rU1sC6\f1A\u001d\u001a!\u00035A\u0017\u000e\u001e*bi&|G+\u00192mKV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^K\u00051\u0001/\u0019:b[NL!a\u0018/\u0003-9+H\u000e\\1cY\u0016$\u0015\r^1Ge\u0006lW\rU1sC6\fa\u0002[5u%\u0006$\u0018n\u001c+bE2,\u0007%A\bd_:4Wo]5p]6\u000bGO]5y\u0003A\u0019wN\u001c4vg&|g.T1ue&D\b%A\u0004m_\u001edwn]:\u0002\u00111|w\r\\8tg\u0002\n\u0011#\\3b]B+'o\u00117bgN,%O]8s\u0003IiW-\u00198QKJ\u001cE.Y:t\u000bJ\u0014xN\u001d\u0011\u0002\u0007\u0005,8-\u0001\u0003bk\u000e\u0004\u0013!\u00029sCV\u001c\u0017A\u00029sCV\u001c\u0007%A\nnk2$\u0018N\\8nS\u0006d\u0017)V\"UC\ndW-\u0001\u000bnk2$\u0018N\\8nS\u0006d\u0017)V\"UC\ndW\rI\u0001\u0016[VdG/\u001b8p[&\fG\u000e\u0015*B+\u000e#\u0016M\u00197f\u0003YiW\u000f\u001c;j]>l\u0017.\u00197Q%\u0006+6\tV1cY\u0016\u0004\u0013!B4fiJ\u0013D#A9\u0011\u0005I\u001cX\"A\u001e\n\u0005Q\\$A\u0002#pk\ndW-\u0001\thKRD\u0015\u000e\u001e*bi&|G+\u00192mKR\tq\u000fE\u0002y\u0003\u0017q1!_A\u0003\u001d\rQ\u0018\u0011\u0001\b\u0003w~t!\u0001 @\u000f\u0005aj\u0018\"\u0001+\n\u0005I\u001b\u0016B\u0001)R\u0013\r\t\u0019aT\u0001\u0004gFd\u0017\u0002BA\u0004\u0003\u0013\tq\u0001]1dW\u0006<WMC\u0002\u0002\u0004=KA!!\u0004\u0002\u0010\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u000f\tI!\u0001\nhKR\u001cuN\u001c4vg&|g.T1ue&D\u0018AC4fi2{w\r\\8tg\u0006!r-\u001a;NK\u0006t\u0007+\u001a:DY\u0006\u001c8/\u0012:s_J\faaZ3u\u0003V\u001b\u0015\u0001C4fiB\u0013\u0016)V\"\u0002-\u001d,G/T;mi&tw.\\5bY\u0006+6\tV1cY\u0016\f\u0001dZ3u\u001bVdG/\u001b8p[&\fG\u000e\u0015*B+\u000e#\u0016M\u00197f\u0003)\u0019X\r^'fiJL7m\u001d\u000b\u0007\u0003G\tI#!\u0011\u0011\u0007I\f)#C\u0002\u0002(m\u0012A!\u00168ji\"9\u00111\u0006\u0011A\u0002\u00055\u0012\u0001\u00026t_:\u0004B!a\f\u0002>5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003hg>t'\u0002BA\u001c\u0003s\taaZ8pO2,'BAA\u001e\u0003\r\u0019w.\\\u0005\u0005\u0003\u007f\t\tD\u0001\u0006Kg>twJ\u00196fGRDa!a\u0011!\u0001\u0004)\u0014aB2p]R,\u0007\u0010^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0002J\u0005-S\"\u0001\u0001\t\u000f\u00055\u0013\u00051\u0001\u0002P\u0005)Q\r\u001f;sCB\u00191*!\u0015\n\u0007\u0005MCJ\u0001\u0005QCJ\fW.T1qQ\u001d\u0001\u0011qKA/\u0003?\u00022\u0001MA-\u0013\r\tYf\t\u0002\u0013\u001b\u0016$(/[2t\t\u0016\u001c8M]5qi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA1\u00039$\u0006.\u001a\u0011dY\u0006\u001c8\u000fI7bW\u0016\u001c\b%\u0019<bS2\f'\r\\3!C2d\u0007%\\3ue&\u001c7\u000f\t;iCR\u00043\u000f[1sK\u0012\u0004\u0013m\u0019:pgN\u0004\u0013\r\u001c7!C2<wN]5uQ6\u001c\be];qa>\u0014H/\u001b8hA5,H\u000e^5o_6L\u0017\r\u001c\u0011dY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8/\u0001")
public class H2OMultinomialMetrics
extends H2OCommonMetrics {
    private final String uid;
    private final DoubleParam r2;
    private final NullableDataFrameParam hitRatioTable;
    private final NullableDataFrameParam confusionMatrix;
    private final DoubleParam logloss;
    private final DoubleParam meanPerClassError;
    private final DoubleParam auc;
    private final DoubleParam prauc;
    private final NullableDataFrameParam multinomialAUCTable;
    private final NullableDataFrameParam multinomialPRAUCTable;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam r2() {
        return this.r2;
    }

    public NullableDataFrameParam hitRatioTable() {
        return this.hitRatioTable;
    }

    public NullableDataFrameParam confusionMatrix() {
        return this.confusionMatrix;
    }

    public DoubleParam logloss() {
        return this.logloss;
    }

    public DoubleParam meanPerClassError() {
        return this.meanPerClassError;
    }

    public DoubleParam auc() {
        return this.auc;
    }

    public DoubleParam prauc() {
        return this.prauc;
    }

    public NullableDataFrameParam multinomialAUCTable() {
        return this.multinomialAUCTable;
    }

    public NullableDataFrameParam multinomialPRAUCTable() {
        return this.multinomialPRAUCTable;
    }

    public double getR2() {
        return BoxesRunTime.unboxToDouble(this.$(this.r2()));
    }

    public Dataset<Row> getHitRatioTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.hitRatioTable()));
    }

    public Dataset<Row> getConfusionMatrix() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.confusionMatrix()));
    }

    public double getLogloss() {
        return BoxesRunTime.unboxToDouble(this.$(this.logloss()));
    }

    public double getMeanPerClassError() {
        return BoxesRunTime.unboxToDouble(this.$(this.meanPerClassError()));
    }

    public double getAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.auc()));
    }

    public double getPRAUC() {
        return BoxesRunTime.unboxToDouble(this.$(this.prauc()));
    }

    public Dataset<Row> getMultinomialAUCTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.multinomialAUCTable()));
    }

    public Dataset<Row> getMultinomialPRAUCTable() {
        return DataFrameSerializationWrappers$.MODULE$.toDataFrame(this.$(this.multinomialPRAUCTable()));
    }

    @Override
    public void setMetrics(JsonObject json, String context) {
        block87: {
            Params params;
            block84: {
                block83: {
                    Params params2;
                    block80: {
                        block79: {
                            Params params3;
                            block76: {
                                block75: {
                                    Params params4;
                                    block72: {
                                        block71: {
                                            Params params5;
                                            block68: {
                                                block67: {
                                                    Params params6;
                                                    block64: {
                                                        block63: {
                                                            Params params7;
                                                            block60: {
                                                                block59: {
                                                                    Params params8;
                                                                    block56: {
                                                                        super.setMetrics(json, context);
                                                                        if (!json.has("r2")) break block56;
                                                                        try {
                                                                            params8 = this.set("r2", BoxesRunTime.boxToDouble((double)json.get("r2").getAsDouble()));
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Throwable throwable2;
                                                                            block58: {
                                                                                block57: {
                                                                                    Throwable throwable3 = throwable;
                                                                                    if (throwable3 == null) break block57;
                                                                                    throwable2 = throwable3;
                                                                                    String string = System.getProperty("spark.testing", "false");
                                                                                    String string2 = "true";
                                                                                    if (string == null ? string2 != null : !string.equals(string2)) break block58;
                                                                                }
                                                                                throw throwable;
                                                                            }
                                                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'r2' from ").append(context).toString(), throwable2);
                                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                            params8 = boxedUnit;
                                                                        }
                                                                        break block59;
                                                                    }
                                                                    String message = new StringBuilder(35).append("The metric 'r2' in ").append(context).append(" does not exist.").toString();
                                                                    String string = System.getProperty("spark.testing", "false");
                                                                    String string3 = "true";
                                                                    if (!(string == null ? string3 != null : !string.equals(string3))) {
                                                                        throw new AssertionError((Object)message);
                                                                    }
                                                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                                    params8 = BoxedUnit.UNIT;
                                                                }
                                                                if (!json.has("hit_ratio_table")) break block60;
                                                                try {
                                                                    params7 = this.set("hitRatioTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "hit_ratio_table")));
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Throwable throwable4;
                                                                    block62: {
                                                                        block61: {
                                                                            Throwable throwable5 = throwable;
                                                                            if (throwable5 == null) break block61;
                                                                            throwable4 = throwable5;
                                                                            String string = System.getProperty("spark.testing", "false");
                                                                            String string4 = "true";
                                                                            if (string == null ? string4 != null : !string.equals(string4)) break block62;
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Unsuccessful try to extract 'hit_ratio_table' from ").append(context).toString(), throwable4);
                                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    params7 = boxedUnit;
                                                                }
                                                                break block63;
                                                            }
                                                            String message = new StringBuilder(48).append("The metric 'hit_ratio_table' in ").append(context).append(" does not exist.").toString();
                                                            String string = System.getProperty("spark.testing", "false");
                                                            String string5 = "true";
                                                            if (!(string == null ? string5 != null : !string.equals(string5))) {
                                                                throw new AssertionError((Object)message);
                                                            }
                                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                            params7 = BoxedUnit.UNIT;
                                                        }
                                                        if (!json.has("cm")) break block64;
                                                        try {
                                                            params6 = this.set("confusionMatrix", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json.getAsJsonObject("cm"), "table")));
                                                        }
                                                        catch (Throwable throwable) {
                                                            Throwable throwable6;
                                                            block66: {
                                                                block65: {
                                                                    Throwable throwable7 = throwable;
                                                                    if (throwable7 == null) break block65;
                                                                    throwable6 = throwable7;
                                                                    String string = System.getProperty("spark.testing", "false");
                                                                    String string6 = "true";
                                                                    if (string == null ? string6 != null : !string.equals(string6)) break block66;
                                                                }
                                                                throw throwable;
                                                            }
                                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Unsuccessful try to extract 'cm' from ").append(context).toString(), throwable6);
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            params6 = boxedUnit;
                                                        }
                                                        break block67;
                                                    }
                                                    String message = new StringBuilder(35).append("The metric 'cm' in ").append(context).append(" does not exist.").toString();
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string7 = "true";
                                                    if (!(string == null ? string7 != null : !string.equals(string7))) {
                                                        throw new AssertionError((Object)message);
                                                    }
                                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                                    params6 = BoxedUnit.UNIT;
                                                }
                                                if (!json.has("logloss")) break block68;
                                                try {
                                                    params5 = this.set("logloss", BoxesRunTime.boxToDouble((double)json.get("logloss").getAsDouble()));
                                                }
                                                catch (Throwable throwable) {
                                                    Throwable throwable8;
                                                    block70: {
                                                        block69: {
                                                            Throwable throwable9 = throwable;
                                                            if (throwable9 == null) break block69;
                                                            throwable8 = throwable9;
                                                            String string = System.getProperty("spark.testing", "false");
                                                            String string8 = "true";
                                                            if (string == null ? string8 != null : !string.equals(string8)) break block70;
                                                        }
                                                        throw throwable;
                                                    }
                                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Unsuccessful try to extract 'logloss' from ").append(context).toString(), throwable8);
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    params5 = boxedUnit;
                                                }
                                                break block71;
                                            }
                                            String message = new StringBuilder(40).append("The metric 'logloss' in ").append(context).append(" does not exist.").toString();
                                            String string = System.getProperty("spark.testing", "false");
                                            String string9 = "true";
                                            if (!(string == null ? string9 != null : !string.equals(string9))) {
                                                throw new AssertionError((Object)message);
                                            }
                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                            params5 = BoxedUnit.UNIT;
                                        }
                                        if (!json.has("mean_per_class_error")) break block72;
                                        try {
                                            params4 = this.set("meanPerClassError", BoxesRunTime.boxToDouble((double)json.get("mean_per_class_error").getAsDouble()));
                                        }
                                        catch (Throwable throwable) {
                                            Throwable throwable10;
                                            block74: {
                                                block73: {
                                                    Throwable throwable11 = throwable;
                                                    if (throwable11 == null) break block73;
                                                    throwable10 = throwable11;
                                                    String string = System.getProperty("spark.testing", "false");
                                                    String string10 = "true";
                                                    if (string == null ? string10 != null : !string.equals(string10)) break block74;
                                                }
                                                throw throwable;
                                            }
                                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Unsuccessful try to extract 'mean_per_class_error' from ").append(context).toString(), throwable10);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            params4 = boxedUnit;
                                        }
                                        break block75;
                                    }
                                    String message = new StringBuilder(53).append("The metric 'mean_per_class_error' in ").append(context).append(" does not exist.").toString();
                                    String string = System.getProperty("spark.testing", "false");
                                    String string11 = "true";
                                    if (!(string == null ? string11 != null : !string.equals(string11))) {
                                        throw new AssertionError((Object)message);
                                    }
                                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                                    params4 = BoxedUnit.UNIT;
                                }
                                if (!json.has("AUC")) break block76;
                                try {
                                    params3 = this.set("auc", BoxesRunTime.boxToDouble((double)json.get("AUC").getAsDouble()));
                                }
                                catch (Throwable throwable) {
                                    Throwable throwable12;
                                    block78: {
                                        block77: {
                                            Throwable throwable13 = throwable;
                                            if (throwable13 == null) break block77;
                                            throwable12 = throwable13;
                                            String string = System.getProperty("spark.testing", "false");
                                            String string12 = "true";
                                            if (string == null ? string12 != null : !string.equals(string12)) break block78;
                                        }
                                        throw throwable;
                                    }
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Unsuccessful try to extract 'AUC' from ").append(context).toString(), throwable12);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    params3 = boxedUnit;
                                }
                                break block79;
                            }
                            String message = new StringBuilder(36).append("The metric 'AUC' in ").append(context).append(" does not exist.").toString();
                            String string = System.getProperty("spark.testing", "false");
                            String string13 = "true";
                            if (!(string == null ? string13 != null : !string.equals(string13))) {
                                throw new AssertionError((Object)message);
                            }
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                            params3 = BoxedUnit.UNIT;
                        }
                        if (!json.has("pr_auc")) break block80;
                        try {
                            params2 = this.set("prauc", BoxesRunTime.boxToDouble((double)json.get("pr_auc").getAsDouble()));
                        }
                        catch (Throwable throwable) {
                            Throwable throwable14;
                            block82: {
                                block81: {
                                    Throwable throwable15 = throwable;
                                    if (throwable15 == null) break block81;
                                    throwable14 = throwable15;
                                    String string = System.getProperty("spark.testing", "false");
                                    String string14 = "true";
                                    if (string == null ? string14 != null : !string.equals(string14)) break block82;
                                }
                                throw throwable;
                            }
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Unsuccessful try to extract 'pr_auc' from ").append(context).toString(), throwable14);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            params2 = boxedUnit;
                        }
                        break block83;
                    }
                    String message = new StringBuilder(39).append("The metric 'pr_auc' in ").append(context).append(" does not exist.").toString();
                    String string = System.getProperty("spark.testing", "false");
                    String string15 = "true";
                    if (!(string == null ? string15 != null : !string.equals(string15))) {
                        throw new AssertionError((Object)message);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    params2 = BoxedUnit.UNIT;
                }
                if (!json.has("multinomial_auc_table")) break block84;
                try {
                    params = this.set("multinomialAUCTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "multinomial_auc_table")));
                }
                catch (Throwable throwable) {
                    Throwable throwable16;
                    block86: {
                        block85: {
                            Throwable throwable17 = throwable;
                            if (throwable17 == null) break block85;
                            throwable16 = throwable17;
                            String string = System.getProperty("spark.testing", "false");
                            String string16 = "true";
                            if (string == null ? string16 != null : !string.equals(string16)) break block86;
                        }
                        throw throwable;
                    }
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Unsuccessful try to extract 'multinomial_auc_table' from ").append(context).toString(), throwable16);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    params = boxedUnit;
                }
                break block87;
            }
            String message = new StringBuilder(54).append("The metric 'multinomial_auc_table' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string17 = "true";
            if (!(string == null ? string17 != null : !string.equals(string17))) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            params = BoxedUnit.UNIT;
        }
        if (json.has("multinomial_aucpr_table")) {
            try {
                this.set("multinomialPRAUCTable", DataFrameSerializationWrappers$.MODULE$.toWrapper(this.jsonFieldToDataFrame(json, "multinomial_aucpr_table")));
            }
            catch (Throwable throwable) {
                Throwable throwable18 = throwable;
                if (throwable18 != null) {
                    Throwable throwable19 = throwable18;
                    String string = System.getProperty("spark.testing", "false");
                    String string18 = "true";
                    if (string == null ? string18 != null : !string.equals(string18)) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Unsuccessful try to extract 'multinomial_aucpr_table' from ").append(context).toString(), throwable19);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable;
            }
        } else {
            String message = new StringBuilder(56).append("The metric 'multinomial_aucpr_table' in ").append(context).append(" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string19 = "true";
            if (string == null ? string19 != null : !string.equals(string19)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            } else {
                throw new AssertionError((Object)message);
            }
        }
    }

    @Override
    public H2OMultinomialMetrics copy(ParamMap extra) {
        return (H2OMultinomialMetrics)this.defaultCopy(extra);
    }

    public H2OMultinomialMetrics(String uid) {
        this.uid = uid;
        this.r2 = this.doubleParam("r2", "The R^2 for this scoring run.");
        this.hitRatioTable = this.nullableDataFrameParam("hitRatioTable", "The hit ratio table for this scoring run.");
        this.confusionMatrix = this.nullableDataFrameParam("confusionMatrix", "The ConfusionMatrix object for this scoring run.");
        this.logloss = this.doubleParam("logloss", "The logarithmic loss for this scoring run.");
        this.meanPerClassError = this.doubleParam("meanPerClassError", "The mean misclassification error per class.");
        this.auc = this.doubleParam("auc", "The average AUC for this scoring run.");
        this.prauc = this.doubleParam("prauc", "The average precision-recall AUC for this scoring run.");
        this.multinomialAUCTable = this.nullableDataFrameParam("multinomialAUCTable", "The multinomial AUC values.");
        this.multinomialPRAUCTable = this.nullableDataFrameParam("multinomialPRAUCTable", "The multinomial PR AUC values.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.r2().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.hitRatioTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.confusionMatrix().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.logloss().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.meanPerClassError().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.auc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.prauc().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.multinomialAUCTable().$minus$greater(null)}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.multinomialPRAUCTable().$minus$greater(null)}));
    }

    public H2OMultinomialMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OMultinomialMetrics"));
    }
}

