/*
 * Decompiled with CFR 0.152.
 */
package biz.k11i.xgboost.gbm;

import biz.k11i.xgboost.config.PredictorConfiguration;
import biz.k11i.xgboost.gbm.GBBase;
import biz.k11i.xgboost.tree.RegTree;
import biz.k11i.xgboost.util.FVec;
import biz.k11i.xgboost.util.ModelReader;
import java.io.IOException;
import java.io.Serializable;

public class GBTree
extends GBBase {
    ModelParam mparam;
    private RegTree[] trees;
    RegTree[][] _groupTrees;

    @Override
    public void loadModel(PredictorConfiguration config, ModelReader reader, boolean with_pbuffer) throws IOException {
        int[] tree_info;
        this.mparam = new ModelParam(reader);
        this.trees = new RegTree[this.mparam.num_trees];
        for (int i2 = 0; i2 < this.mparam.num_trees; ++i2) {
            this.trees[i2] = config.getRegTreeFactory().loadTree(reader);
        }
        int[] nArray = tree_info = this.mparam.num_trees > 0 ? reader.readIntArray(this.mparam.num_trees) : new int[]{};
        if (this.mparam.num_pbuffer != 0L && with_pbuffer) {
            reader.skip(4L * this.predBufferSize());
            reader.skip(4L * this.predBufferSize());
        }
        this._groupTrees = new RegTree[this.num_output_group][];
        for (int i3 = 0; i3 < this.num_output_group; ++i3) {
            int j2;
            int treeCount = 0;
            for (j2 = 0; j2 < tree_info.length; ++j2) {
                if (tree_info[j2] != i3) continue;
                ++treeCount;
            }
            this._groupTrees[i3] = new RegTree[treeCount];
            treeCount = 0;
            for (j2 = 0; j2 < tree_info.length; ++j2) {
                if (tree_info[j2] != i3) continue;
                this._groupTrees[i3][treeCount++] = this.trees[j2];
            }
        }
    }

    @Override
    public float[] predict(FVec feat, int ntree_limit) {
        float[] preds = new float[this.num_output_group];
        for (int gid = 0; gid < this.num_output_group; ++gid) {
            preds[gid] = this.pred(feat, gid, 0, ntree_limit);
        }
        return preds;
    }

    @Override
    public float predictSingle(FVec feat, int ntree_limit) {
        if (this.num_output_group != 1) {
            throw new IllegalStateException("Can't invoke predictSingle() because this model outputs multiple values: " + this.num_output_group);
        }
        return this.pred(feat, 0, 0, ntree_limit);
    }

    float pred(FVec feat, int bst_group, int root_index, int ntree_limit) {
        RegTree[] trees = this._groupTrees[bst_group];
        int treeleft = ntree_limit == 0 ? trees.length : ntree_limit;
        float psum = 0.0f;
        for (int i2 = 0; i2 < treeleft; ++i2) {
            psum += trees[i2].getLeafValue(feat, root_index);
        }
        return psum;
    }

    @Override
    public int[] predictLeaf(FVec feat, int ntree_limit) {
        int treeleft = ntree_limit == 0 ? this.trees.length : ntree_limit;
        int[] leafIndex = new int[treeleft];
        for (int i2 = 0; i2 < treeleft; ++i2) {
            leafIndex[i2] = this.trees[i2].getLeafIndex(feat);
        }
        return leafIndex;
    }

    @Override
    public String[] predictLeafPath(FVec feat, int ntree_limit) {
        int treeleft = ntree_limit == 0 ? this.trees.length : ntree_limit;
        String[] leafPath = new String[treeleft];
        StringBuilder sb = new StringBuilder(64);
        for (int i2 = 0; i2 < treeleft; ++i2) {
            this.trees[i2].getLeafPath(feat, sb);
            leafPath[i2] = sb.toString();
            sb.setLength(0);
        }
        return leafPath;
    }

    private long predBufferSize() {
        return (long)this.num_output_group * this.mparam.num_pbuffer * (long)(this.mparam.size_leaf_vector + 1);
    }

    public RegTree[][] getGroupedTrees() {
        return this._groupTrees;
    }

    static class ModelParam
    implements Serializable {
        final int num_trees;
        final int num_roots;
        final long num_pbuffer;
        final int size_leaf_vector;
        final int[] reserved;

        ModelParam(ModelReader reader) throws IOException {
            this.num_trees = reader.readInt();
            this.num_roots = reader.readInt();
            reader.readInt();
            reader.readInt();
            this.num_pbuffer = reader.readLong();
            reader.readInt();
            this.size_leaf_vector = reader.readInt();
            this.reserved = reader.readIntArray(31);
            reader.readInt();
        }
    }
}

