/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractBeanField;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;

public class BeanFieldDate<T>
extends AbstractBeanField<T> {
    private final String formatString;
    private final String locale;

    public BeanFieldDate(Field field, boolean required, String formatString, String locale, Locale errorLocale) {
        super(field, required, errorLocale);
        this.formatString = formatString;
        this.locale = locale;
    }

    private SimpleDateFormat getFormat() {
        SimpleDateFormat sdf;
        if (StringUtils.isNotEmpty(this.locale)) {
            Locale l2 = Locale.forLanguageTag(this.locale);
            sdf = new SimpleDateFormat(this.formatString, l2);
        } else {
            sdf = new SimpleDateFormat(this.formatString);
        }
        return sdf;
    }

    private <U> U convertDate(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o2;
        if (value instanceof String) {
            try {
                Date d2 = this.getFormat().parse((String)value);
                o2 = fieldType.getConstructor(Long.TYPE).newInstance(d2.getTime());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParseException e2) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e2);
                throw csve;
            }
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            o2 = fieldType.cast(this.getFormat().format((Date)value));
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return o2;
    }

    private <U> U convertCalendar(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o2;
        if (value instanceof String) {
            Date d2;
            try {
                d2 = this.getFormat().parse((String)value);
            }
            catch (ParseException e2) {
                CsvDataTypeMismatchException csve = new CsvDataTypeMismatchException(value, fieldType);
                csve.initCause(e2);
                throw csve;
            }
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d2);
            if (fieldType == XMLGregorianCalendar.class) {
                try {
                    o2 = fieldType.cast(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
                }
                catch (DatatypeConfigurationException e3) {
                    CsvDataTypeMismatchException ex = new CsvDataTypeMismatchException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("xmlgregoriancalendar.impossible"));
                    ex.initCause(e3);
                    throw ex;
                }
            } else {
                o2 = fieldType.cast(gc);
            }
        } else {
            Calendar c2;
            if (value instanceof XMLGregorianCalendar) {
                c2 = ((XMLGregorianCalendar)value).toGregorianCalendar();
            } else if (value instanceof Calendar) {
                c2 = (Calendar)value;
            } else {
                throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
            }
            o2 = fieldType.cast(this.getFormat().format(c2.getTime()));
        }
        return o2;
    }

    private <U> U convertCommon(Object value, Class<U> fieldType) throws CsvDataTypeMismatchException {
        U o2;
        Class<Object> conversionClass;
        Class<Object> clazz = conversionClass = fieldType == String.class ? value.getClass() : fieldType;
        if (Date.class.isAssignableFrom(conversionClass)) {
            o2 = this.convertDate(value, fieldType);
        } else if (Calendar.class.isAssignableFrom(conversionClass) || XMLGregorianCalendar.class.isAssignableFrom(conversionClass)) {
            o2 = this.convertCalendar(value, fieldType);
        } else {
            throw new CsvDataTypeMismatchException(value, fieldType, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("csvdate.not.date"));
        }
        return o2;
    }

    @Override
    protected Object convert(String value) throws CsvDataTypeMismatchException {
        return StringUtils.isBlank(value) ? null : this.convertCommon(value, this.field.getType());
    }

    @Override
    protected String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        return value == null ? null : this.convertCommon(value, String.class);
    }
}

