/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.GenModel;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.exception.PredictNumberFormatException;
import hex.genmodel.easy.exception.PredictUnknownCategoricalLevelException;
import hex.genmodel.easy.exception.PredictUnknownTypeException;
import java.io.Serializable;
import java.util.Map;

public class RowToRawDataConverter
implements Serializable {
    private final Map<String, Integer> _modelColumnNameToIndexMap;
    private final Map<Integer, CategoricalEncoder> _domainMap;
    private final EasyPredictModelWrapper.ErrorConsumer _errorConsumer;
    private final boolean _convertUnknownCategoricalLevelsToNa;
    private final boolean _convertInvalidNumbersToNa;

    public RowToRawDataConverter(GenModel m2, Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        this._modelColumnNameToIndexMap = modelColumnNameToIndexMap;
        this._domainMap = domainMap;
        this._errorConsumer = errorConsumer;
        this._convertUnknownCategoricalLevelsToNa = config.getConvertUnknownCategoricalLevelsToNa();
        this._convertInvalidNumbersToNa = config.getConvertInvalidNumbersToNa();
    }

    public double[] convert(RowData data, double[] rawData) throws PredictException {
        for (String dataColumnName : data.keySet()) {
            Object o2;
            Integer index = this._modelColumnNameToIndexMap.get(dataColumnName);
            if (index == null || index >= rawData.length || !this.convertValue(dataColumnName, o2 = data.get(dataColumnName), this._domainMap.get(index), index, rawData)) continue;
            return rawData;
        }
        return rawData;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean convertValue(String columnName, Object o, CategoricalEncoder catEncoder, int targetIndex, double[] rawData) throws PredictException {
        if (catEncoder == null) {
            value = NaN;
            if (o instanceof String) {
                s = ((String)o).trim();
                try {
                    value = Double.parseDouble(s);
                }
                catch (NumberFormatException nfe) {
                    if (this._convertInvalidNumbersToNa) ** GOTO lbl13
                    throw new PredictNumberFormatException("Unable to parse value: " + s + ", from column: " + columnName + ", as Double; " + nfe.getMessage());
                }
            } else {
                if (!(o instanceof Double)) throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for numeric column " + columnName);
                value = (Double)o;
            }
lbl13:
            // 3 sources

            if (Double.isNaN(value)) {
                this._errorConsumer.dataTransformError(columnName, o, "Given non-categorical value is unparseable, treating as NaN.");
            }
            rawData[targetIndex] = value;
            return false;
        }
        if (!(o instanceof String)) ** GOTO lbl26
        levelName = (String)o;
        if (catEncoder.encodeCatValue(levelName, rawData)) return false;
        if (this._convertUnknownCategoricalLevelsToNa) {
            catEncoder.encodeNA(rawData);
            this._errorConsumer.unseenCategorical(columnName, o, "Previously unseen categorical level detected, marking as NaN.");
            return false;
        } else {
            this._errorConsumer.dataTransformError(columnName, o, "Unknown categorical level detected.");
            throw new PredictUnknownCategoricalLevelException("Unknown categorical level (" + columnName + "," + levelName + ")", columnName, levelName);
lbl26:
            // 1 sources

            if (o instanceof Double && Double.isNaN((Double)o)) {
                this._errorConsumer.dataTransformError(columnName, o, "Missing factor value detected, setting to NaN");
                catEncoder.encodeNA(rawData);
                return false;
            } else {
                this._errorConsumer.dataTransformError(columnName, o, "Unknown categorical variable type.");
                throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for categorical column " + columnName);
            }
        }
    }

    EasyPredictModelWrapper.ErrorConsumer getErrorConsumer() {
        return this._errorConsumer;
    }
}

