# finbourne-insights-sdk
FINBOURNE Technology

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.229
- Package version: 0.0.229
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen
For more information, please visit [https://www.finbourne.com](https://www.finbourne.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import finbourne_insights
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import finbourne_insights
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import finbourne_insights
from finbourne_insights.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://fbn-ci.lusid.com/insights
# See configuration.py for a list of all supported configuration parameters.
configuration = finbourne_insights.Configuration(
    host = "https://fbn-ci.lusid.com/insights"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oauth2
configuration = finbourne_insights.Configuration(
    host = "https://fbn-ci.lusid.com/insights"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with finbourne_insights.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = finbourne_insights.AccessEvaluationsApi(api_client)
    id = 'id_example' # str | The identifier of the access evaluation to obtain the log for.

    try:
        # [EXPERIMENTAL] GetAccessEvaluationLog: Get the log for a specific access evaluation.
        api_response = api_instance.get_access_evaluation_log(id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AccessEvaluationsApi->get_access_evaluation_log: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://fbn-ci.lusid.com/insights*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccessEvaluationsApi* | [**get_access_evaluation_log**](docs/AccessEvaluationsApi.md#get_access_evaluation_log) | **GET** /api/access/{id} | [EXPERIMENTAL] GetAccessEvaluationLog: Get the log for a specific access evaluation.
*AccessEvaluationsApi* | [**list_access_evaluation_logs**](docs/AccessEvaluationsApi.md#list_access_evaluation_logs) | **GET** /api/access | [EXPERIMENTAL] ListAccessEvaluationLogs: List the logs for access evaluations.
*ApplicationMetadataApi* | [**list_access_controlled_resources**](docs/ApplicationMetadataApi.md#list_access_controlled_resources) | **GET** /api/metadata/access/resources | [EARLY ACCESS] ListAccessControlledResources: Get resources available for access control
*AuditingApi* | [**create_entry**](docs/AuditingApi.md#create_entry) | **POST** /api/auditing/entries | [EARLY ACCESS] CreateEntry: Create (persist) and audit entry..
*AuditingApi* | [**get_processes**](docs/AuditingApi.md#get_processes) | **GET** /api/auditing/processes | [EARLY ACCESS] GetProcesses: Get the latest audit entry for each process.
*AuditingApi* | [**list_entries**](docs/AuditingApi.md#list_entries) | **GET** /api/auditing/entries | [EARLY ACCESS] ListEntries: Get the audit entries.
*RequestsApi* | [**get_request**](docs/RequestsApi.md#get_request) | **GET** /api/requests/{id}/request | [EXPERIMENTAL] GetRequest: Get the request content for a specific API request.
*RequestsApi* | [**get_request_log**](docs/RequestsApi.md#get_request_log) | **GET** /api/requests/{id} | [EXPERIMENTAL] GetRequestLog: Get the log for a specific API request.
*RequestsApi* | [**get_response**](docs/RequestsApi.md#get_response) | **GET** /api/requests/{id}/response | [EXPERIMENTAL] GetResponse: Get the response for a specific API request.
*RequestsApi* | [**list_request_logs**](docs/RequestsApi.md#list_request_logs) | **GET** /api/requests | [EXPERIMENTAL] ListRequestLogs: Get the logs for API requests.
*VendorLogsApi* | [**get_vendor_log**](docs/VendorLogsApi.md#get_vendor_log) | **GET** /api/vendor/{id} | [EXPERIMENTAL] GetVendorLog: Get the log for a specific vendor request.
*VendorLogsApi* | [**get_vendor_request**](docs/VendorLogsApi.md#get_vendor_request) | **GET** /api/vendor/{id}/request | [EXPERIMENTAL] GetVendorRequest: Get the request body for a vendor request.
*VendorLogsApi* | [**get_vendor_response**](docs/VendorLogsApi.md#get_vendor_response) | **GET** /api/vendor/{id}/response | [EXPERIMENTAL] GetVendorResponse: Get the response from a vendor request.
*VendorLogsApi* | [**list_vendor_logs**](docs/VendorLogsApi.md#list_vendor_logs) | **GET** /api/vendor | [EXPERIMENTAL] ListVendorLogs: List the logs for vendor requests.


## Documentation For Models

 - [AccessControlledAction](docs/AccessControlledAction.md)
 - [AccessControlledResource](docs/AccessControlledResource.md)
 - [AccessEvaluationLog](docs/AccessEvaluationLog.md)
 - [ActionId](docs/ActionId.md)
 - [AuditData](docs/AuditData.md)
 - [AuditDataSummary](docs/AuditDataSummary.md)
 - [AuditEntry](docs/AuditEntry.md)
 - [AuditEntryNote](docs/AuditEntryNote.md)
 - [AuditProcess](docs/AuditProcess.md)
 - [AuditProcessSummary](docs/AuditProcessSummary.md)
 - [Bucket](docs/Bucket.md)
 - [CreateAuditEntry](docs/CreateAuditEntry.md)
 - [Histogram](docs/Histogram.md)
 - [IdSelectorDefinition](docs/IdSelectorDefinition.md)
 - [IdentifierPartSchema](docs/IdentifierPartSchema.md)
 - [Link](docs/Link.md)
 - [LusidProblemDetails](docs/LusidProblemDetails.md)
 - [LusidValidationProblemDetails](docs/LusidValidationProblemDetails.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [Request](docs/Request.md)
 - [RequestLog](docs/RequestLog.md)
 - [Resource](docs/Resource.md)
 - [ResourceListOfAccessControlledResource](docs/ResourceListOfAccessControlledResource.md)
 - [ResourceListOfAuditProcessSummary](docs/ResourceListOfAuditProcessSummary.md)
 - [ResourceListWithHistogramOfAccessEvaluationLog](docs/ResourceListWithHistogramOfAccessEvaluationLog.md)
 - [ResourceListWithHistogramOfRequestLog](docs/ResourceListWithHistogramOfRequestLog.md)
 - [ResourceListWithHistogramOfVendorLog](docs/ResourceListWithHistogramOfVendorLog.md)
 - [Response](docs/Response.md)
 - [ScrollableCollectionOfAuditEntry](docs/ScrollableCollectionOfAuditEntry.md)
 - [VendorLog](docs/VendorLog.md)
 - [VendorRequest](docs/VendorRequest.md)
 - [VendorResponse](docs/VendorResponse.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://lusid.okta.com/oauth2/default/v1/authorize
- **Scopes**: N/A


## Author

info@finbourne.com


