# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetRegistryImageResult',
    'AwaitableGetRegistryImageResult',
    'get_registry_image',
    'get_registry_image_output',
]

@pulumi.output_type
class GetRegistryImageResult:
    """
    A collection of values returned by getRegistryImage.
    """
    def __init__(__self__, id=None, insecure_skip_verify=None, name=None, sha256_digest=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insecure_skip_verify and not isinstance(insecure_skip_verify, bool):
            raise TypeError("Expected argument 'insecure_skip_verify' to be a bool")
        pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sha256_digest and not isinstance(sha256_digest, str):
            raise TypeError("Expected argument 'sha256_digest' to be a str")
        pulumi.set(__self__, "sha256_digest", sha256_digest)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[bool]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Docker image, including any tags. e.g. `alpine:latest`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sha256Digest")
    def sha256_digest(self) -> str:
        """
        The content digest of the image, as stored in the registry.
        """
        return pulumi.get(self, "sha256_digest")


class AwaitableGetRegistryImageResult(GetRegistryImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryImageResult(
            id=self.id,
            insecure_skip_verify=self.insecure_skip_verify,
            name=self.name,
            sha256_digest=self.sha256_digest)


def get_registry_image(insecure_skip_verify: Optional[bool] = None,
                       name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryImageResult:
    """
    Reads the image metadata from a Docker Registry. Used in conjunction with the RemoteImage resource to keep an image up to date on the latest available version of the tag.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    ubuntu_registry_image = docker.get_registry_image(name="ubuntu:precise")
    ubuntu_remote_image = docker.RemoteImage("ubuntuRemoteImage",
        name=ubuntu_registry_image.name,
        pull_triggers=[ubuntu_registry_image.sha256_digest])
    ```


    :param bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param str name: The name of the Docker image, including any tags. e.g. `alpine:latest`
    """
    __args__ = dict()
    __args__['insecureSkipVerify'] = insecure_skip_verify
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('docker:index/getRegistryImage:getRegistryImage', __args__, opts=opts, typ=GetRegistryImageResult).value

    return AwaitableGetRegistryImageResult(
        id=__ret__.id,
        insecure_skip_verify=__ret__.insecure_skip_verify,
        name=__ret__.name,
        sha256_digest=__ret__.sha256_digest)


@_utilities.lift_output_func(get_registry_image)
def get_registry_image_output(insecure_skip_verify: Optional[pulumi.Input[Optional[bool]]] = None,
                              name: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegistryImageResult]:
    """
    Reads the image metadata from a Docker Registry. Used in conjunction with the RemoteImage resource to keep an image up to date on the latest available version of the tag.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    ubuntu_registry_image = docker.get_registry_image(name="ubuntu:precise")
    ubuntu_remote_image = docker.RemoteImage("ubuntuRemoteImage",
        name=ubuntu_registry_image.name,
        pull_triggers=[ubuntu_registry_image.sha256_digest])
    ```


    :param bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param str name: The name of the Docker image, including any tags. e.g. `alpine:latest`
    """
    ...
