# Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
# This product includes software developed at Datadog (https://www.datadoghq.com/).
# Copyright 2019-Present Datadog, Inc.
from __future__ import annotations


from datadog_api_client.model_utils import (
    ModelComposed,
    cached_property,
)


class IncidentTodoAssignee(ModelComposed):
    def __init__(self, **kwargs):
        """
        A todo assignee.

        :param icon: URL for assignee's icon.
        :type icon: str

        :param id: Anonymous assignee's ID.
        :type id: str

        :param name: Assignee's name.
        :type name: str

        :param source: The source of the anonymous assignee.
        :type source: IncidentTodoAnonymousAssigneeSource
        """
        super().__init__(kwargs)

    @cached_property
    def _composed_schemas(_):
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        from datadog_api_client.v2.model.incident_todo_anonymous_assignee import IncidentTodoAnonymousAssignee

        return {
            "oneOf": [
                str,
                IncidentTodoAnonymousAssignee,
            ],
        }
