"use strict";
const nodeunit = require("nodeunit");
const lib_1 = require("../../lib");
module.exports = nodeunit.testCase({
    'blank amount'(test) {
        test.throws(() => lib_1.IdentitySource.context(''), /empty/);
        test.done();
    },
    'IdentitySource header'(test) {
        const identitySource = lib_1.IdentitySource.header('Authorization');
        test.equal(identitySource.toString(), 'method.request.header.Authorization');
        test.done();
    },
    'IdentitySource queryString'(test) {
        const identitySource = lib_1.IdentitySource.queryString('param');
        test.equal(identitySource.toString(), 'method.request.querystring.param');
        test.done();
    },
    'IdentitySource stageVariable'(test) {
        const identitySource = lib_1.IdentitySource.stageVariable('var1');
        test.equal(identitySource.toString(), 'stageVariables.var1');
        test.done();
    },
    'IdentitySource context'(test) {
        const identitySource = lib_1.IdentitySource.context('httpMethod');
        test.equal(identitySource.toString(), 'context.httpMethod');
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,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