from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Bundle_LinkSchema:
    """
    A container for a collection of resources.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A container for a collection of resources.


        relation: A name which details the functional use for this link - see
            [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-
            relations-1](http://www.iana.org/assignments/link-relations/link-
            relations.xhtml#link-relations-1).

        url: The reference details for the link.

        """
        if (
            max_recursion_limit
            and nesting_list.count("Bundle_Link") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Bundle_Link"]
        schema = StructType(
            [
                # A name which details the functional use for this link - see
                # [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-
                # relations-1](http://www.iana.org/assignments/link-relations/link-
                # relations.xhtml#link-relations-1).
                StructField("relation", StringType(), True),
                # The reference details for the link.
                StructField("url", StringType(), True),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
